/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class YoutubeUtils {
    public static String toWWWUrl(String url) {
        Pattern titlePattern = Pattern.compile("(.*)(\\.youtube.com/watch?.*$)");
        Matcher match = titlePattern.matcher(url);
        if (match.matches()) {
            return "http://www" + match.group(2);
        }
        return url;
    }

    public static String toFLVFileName(URL url) {
        String id = YoutubeUtils.getId(url);
        if (id != null) {
            return String.valueOf(id) + ".flv";
        }
        return null;
    }

    public static String getId(URL url) {
        String id = null;
        String q = url.getQuery();
        String[] values = q.split("&");
        int i = 0;
        while (i < values.length) {
            if (values[i].startsWith("v=")) {
                id = values[i].substring(2);
                break;
            }
            ++i;
        }
        return id;
    }

    public static String getTitle(String key) {
        String base = "http://www.youtube.com/watch?v=" + key;
        try {
            return YoutubeUtils.getTitle(new URL(base));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getTitle(String key, String user, String password) {
        String cookieValue2 = null;
        try {
            URLConnection cc = new URL("http://www.youtube.com/watch?v=" + key).openConnection();
            cc.setDoOutput(false);
            Map<String, List<String>> headers2 = cc.getHeaderFields();
            List<String> values2 = headers2.get("Set-Cookie");
            for (String v : values2) {
                cookieValue2 = cookieValue2 == null ? v : String.valueOf(cookieValue2) + ";" + v;
            }
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            int b;
            String urlString = "http://www.youtube.com/login?";
            String postStr = "current_form=loginForm&next=" + URLEncoder.encode("/watch?v=", "UTF-8") + key + "&username=" + user + "&password=" + password + "&action_login=Log+In";
            URL url = new URL(urlString);
            URLConnection uc = url.openConnection();
            uc.setDoOutput(true);
            uc.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1) Gecko/20061010 Firefox/2.0");
            uc.setRequestProperty("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7");
            uc.setRequestProperty("Accept", "text/xml,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5");
            uc.setRequestProperty("Accept-Language", "en-us,en;q=0.5");
            uc.setRequestProperty("Cookie", cookieValue2);
            OutputStream os = uc.getOutputStream();
            PrintStream ps = new PrintStream(os);
            ps.print(postStr);
            ps.close();
            Map<String, List<String>> headers = uc.getHeaderFields();
            List<String> values = headers.get("Set-Cookie");
            String cookieValue = null;
            for (String v : values) {
                cookieValue = cookieValue == null ? v : String.valueOf(cookieValue) + ";" + v;
            }
            URL url2 = new URL("http://www.youtube.com/verify_age?next_url=/watch%%3Fv%%3D" + key);
            URLConnection uc2 = url2.openConnection();
            uc2.setDoOutput(true);
            uc2.setDefaultUseCaches(true);
            uc2.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1) Gecko/20061010 Firefox/2.0");
            uc2.setRequestProperty("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7");
            uc2.setRequestProperty("Accept", "text/xml,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5");
            uc2.setRequestProperty("Accept-Language", "en-us,en;q=0.5");
            uc2.setRequestProperty("Cookie", cookieValue);
            PrintStream ps2 = new PrintStream(uc2.getOutputStream());
            ps2.print("next_url=%2Fwatch%3Fv%3D" + key + "&action_confirm=Confirm'");
            ps2.close();
            InputStream is = uc2.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            int readed = 0;
            StringBuffer buffer = new StringBuffer();
            while ((b = reader.read()) != -1) {
                buffer.append((char)b);
                if (++readed <= 400) continue;
                buffer.toString().indexOf("</title>");
            }
            reader.close();
            String html = buffer.toString().replaceAll("\n", "");
            Pattern titlePattern = Pattern.compile(".*<title>YouTube\\s*-\\s*(.*)</title>.*");
            Matcher match = titlePattern.matcher(html);
            if (match.matches()) {
                return match.group(1);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getTitle(URL url) {
        try {
            int b;
            InputStreamReader input = new InputStreamReader(url.openStream(), "UTF-8");
            int readed = 0;
            StringBuffer buffer = new StringBuffer();
            while ((b = input.read()) != -1) {
                buffer.append((char)b);
                if (++readed > 400 && buffer.toString().indexOf("</title>") != -1) break;
            }
            input.close();
            String html = buffer.toString().replaceAll("\n", "");
            Pattern titlePattern = Pattern.compile(".*<title>YouTube\\s*-\\s*(.*)</title>.*");
            Matcher match = titlePattern.matcher(html);
            if (match.matches()) {
                return match.group(1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String fixFileName(String title) {
        if ((title = title.substring(0, Math.min(251, title.length()))).startsWith(".")) {
            title = "\u3002" + title.substring(1);
        }
        String shoudreplace = "/:;,*?\"<>|?";
        String replace = "\u30fb\uff1a\uff1b\u3001\uff0a\uff1f\uffe5\u201d\uff1c\uff1e\uff5c\uff1f";
        String ret = title;
        ret = StringUtils.replaceChars((String)ret, (String)shoudreplace, (String)replace);
        return ret;
    }

    public static boolean isYoutubeVideoURL(String url) {
        if (url == null) {
            return false;
        }
        if (url.length() < "http://youtube.com/watch?v=".length()) {
            return false;
        }
        if (!url.startsWith("http://")) {
            return false;
        }
        try {
            String key;
            URL u = new URL(url);
            if (u.getHost().toLowerCase().endsWith("youtube.com") && (key = YoutubeUtils.getId(u)) != null) {
                return true;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return false;
    }
}

