/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.util;

public class TimeUtils {
    public static String toTimeText(long millisecond) {
        return TimeUtils.toTimeText(millisecond, true, true, true, true);
    }

    public static long toMillisecond(int hour, int minute, int second, int millisecond) {
        long ret = 0L;
        ret += (long)(hour * 60 * 60 * 1000);
        ret += (long)(minute * 60 * 1000);
        ret += (long)(second * 1000);
        return ret += (long)millisecond;
    }

    public static long toMillisecond(String text) {
        int[] vs = TimeUtils.toHourMinSecMilliSecond(text);
        if (vs == null) {
            return 0L;
        }
        return TimeUtils.toMillisecond(vs[0], vs[1], vs[2], vs[3]);
    }

    public static int[] toHourMinSecMilliSecond(String text) {
        int[] ret = new int[4];
        String[] values = text.split(":");
        if (values.length > 3) {
            return null;
        }
        if (values[values.length - 1].indexOf(".") != -1) {
            String[] sec_milli = values[values.length - 1].split("\\.");
            if (sec_milli.length != 2) {
                return null;
            }
            if (TimeUtils.isDigitOnly(sec_milli[0]) && TimeUtils.isDigitOnly(sec_milli[1])) {
                values[values.length - 1] = sec_milli[0];
                ret[3] = Integer.parseInt(sec_milli[1]);
            } else {
                return null;
            }
        }
        if (values.length == 1) {
            String[] tValues = new String[]{"h", "m", "s"};
            String checkValue = values[0];
            String ends = "";
            int i = 0;
            while (i < tValues.length) {
                if (checkValue.toLowerCase().endsWith(tValues[i])) {
                    checkValue = checkValue.substring(0, checkValue.length() - 1);
                    ends = tValues[i];
                    break;
                }
                ++i;
            }
            if (TimeUtils.isDigitOnly(checkValue)) {
                if (ends.equals("h")) {
                    ret[0] = Integer.parseInt(checkValue);
                } else if (ends.equals("m")) {
                    ret[1] = Integer.parseInt(checkValue);
                } else {
                    ret[2] = Integer.parseInt(checkValue);
                }
                return ret;
            }
            return null;
        }
        int i = 0;
        while (i < values.length) {
            if (!TimeUtils.isDigitOnly(values[i])) {
                return null;
            }
            ret[i] = Integer.parseInt(values[i]);
            ++i;
        }
        return ret;
    }

    public static boolean isTimeText(String text) {
        return TimeUtils.toHourMinSecMilliSecond(text) != null;
    }

    public static boolean isDigitOnly(String text) {
        int i = 0;
        while (i < text.length()) {
            if (!Character.isDigit(text.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String toTimeText(long millisecond, boolean showHour, boolean showMinute, boolean showSecond, boolean showMilliSecond) {
        long hour_millisecond = 3600000L;
        int minute_millisecond = 60000;
        int second_millisecond = 1000;
        int hour = (int)(millisecond / hour_millisecond);
        long remain = millisecond % hour_millisecond;
        int minute = (int)(remain / (long)minute_millisecond);
        int second = (int)((remain %= (long)minute_millisecond) / (long)second_millisecond);
        remain %= (long)second_millisecond;
        String ret = "";
        if (showHour) {
            ret = String.valueOf(ret) + TimeUtils.toLabel2(hour) + ":";
            if (!showMinute) {
                ret = String.valueOf(ret) + "00:";
                if (!showSecond) {
                    ret = String.valueOf(ret) + "00";
                }
            }
        }
        if (showMinute) {
            ret = String.valueOf(ret) + TimeUtils.toLabel2(minute) + ":";
            if (!showSecond) {
                ret = String.valueOf(ret) + "00";
            }
        }
        if (showSecond) {
            ret = String.valueOf(ret) + TimeUtils.toLabel2(second);
        }
        if (showMilliSecond) {
            ret = String.valueOf(ret) + TimeUtils.toLabel3((int)remain);
        }
        return ret;
    }

    private static String toLabel2(int number) {
        String v = "" + number;
        if (v.length() < 2) {
            v = "0" + v;
        }
        return v;
    }

    private static String toLabel3(int number) {
        String v = "" + number;
        if (v.length() < 2) {
            v = "0" + v;
        }
        if (v.length() < 3) {
            v = "0" + v;
        }
        if (v.length() > 3) {
            return "000";
        }
        return v;
    }
}

