/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ui.param;

import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.akjrcp.ui.param.AbstractParamItem;
import jp.sourceforge.akjrcp.ui.param.ParamItemActionListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ParamTab
extends AbstractParamItem {
    private Map<String, TabItem> tabItems = new HashMap<String, TabItem>();
    private Map<String, Composite> composites = new HashMap<String, Composite>();
    private TabFolder tabFolder;
    private String key;
    private String value;

    public ParamTab(Composite parent, int style, String key) {
        this.tabFolder = new TabFolder(parent, style);
        this.key = key;
        this.tabFolder.addSelectionListener((SelectionListener)new AbstractParamItem.SelectionCheck());
    }

    public Composite createGridLayoutTab(String label, int style) {
        TabItem item = new TabItem(this.tabFolder, style);
        item.setText(label);
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        composite.setLayout((Layout)new GridLayout());
        item.setControl((Control)composite);
        if (this.tabItems.size() == 0) {
            this.value = label;
        }
        this.tabItems.put(label, item);
        this.composites.put(label, composite);
        return composite;
    }

    public String getValue() {
        TabItem item;
        int index = this.tabFolder.getSelectionIndex();
        if (index >= 0 && (item = this.tabFolder.getItem(index)) != null) {
            return item.getText();
        }
        return "";
    }

    public String getKey() {
        return this.key;
    }

    public boolean isModified() {
        return this.getValue().equals(this.value);
    }

    public void setParamItemActionListener(ParamItemActionListener listener) {
    }

    public void setValue(String value) {
        this.value = value;
        int i = 0;
        while (i < this.tabFolder.getItemCount()) {
            TabItem item = this.tabFolder.getItem(i);
            if (item.getText().equals(value)) {
                this.tabFolder.setSelection(i);
                break;
            }
            ++i;
        }
    }
}

