/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ui.draw2d;

import java.util.ArrayList;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;

public class WrapTextPainter {
    private int width;
    private Font font;
    public static Font defaultFont = new Font(null, "MS Gothic", 24, 0);
    private String text;
    String[] texts;
    int[] styles;
    int[] returnPoint;
    byte[] charWidths;
    private char[] splitchars = new char[]{'\n', ' ', ':', ';', '.', ','};
    private boolean wrap = true;
    private boolean reanalyze = true;
    private int stringHeight;

    public WrapTextPainter(int width, Font font) {
        this.width = width;
        this.font = font;
    }

    public void paint(GC g, int drawX, int drawY) {
        if (this.reanalyze) {
            g.setFont(this.font);
            this.charWidths = this.toCharByte(g, this.getText());
            this.returnPoint = this.splitLine(g);
            this.reanalyze = false;
        }
        g.setFont(this.font);
        if (this.texts != null) {
            int dx = drawX;
            int dy = drawY;
            int index = 0;
            int j = 0;
            while (j < this.texts.length) {
                if (this.isReturn(j)) {
                    dx = drawX;
                    dy += this.stringHeight;
                }
                if (!this.texts[j].equals("\n")) {
                    int length = this.toWordLength(index, this.texts[j].length());
                    g.drawString(this.texts[j], dx, dy);
                    dx += length;
                }
                index += this.texts[j].length();
                ++j;
            }
        }
    }

    private String getText() {
        return this.text;
    }

    public int getClickIndex(int x, int y) {
        int last = -1;
        int cy = 0;
        if (y > 0) {
            cy = y / this.stringHeight;
        }
        int sx = 0;
        int dx = 0;
        if (cy > this.returnPoint.length) {
            return -1;
        }
        if (cy > 0) {
            if (this.returnPoint.length >= cy) {
                sx = this.returnPoint[cy - 1];
                if (this.returnPoint.length > cy) {
                    last = this.returnPoint[cy];
                }
            }
        } else if (this.returnPoint.length > 0) {
            last = this.returnPoint[0];
        }
        int i = sx;
        while (i < this.texts.length) {
            if (i == last) break;
            int length = this.toWordLength(i);
            if (x >= dx && x <= dx + length) {
                return i;
            }
            dx += length;
            ++i;
        }
        return -1;
    }

    public void setText(String text) {
        this.text = text;
        this.texts = this.splitText(text);
        this.reanalyze = true;
    }

    public String[] splitText(String text) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            boolean isSplit = false;
            int j = 0;
            while (j < this.splitchars.length) {
                if (ch == this.splitchars[j]) {
                    isSplit = true;
                    break;
                }
                ++j;
            }
            if (isSplit) {
                if (buffer.length() > 0) {
                    list.add(buffer.toString());
                    list.add("" + ch);
                    buffer = new StringBuffer();
                } else {
                    list.add("" + ch);
                }
            } else {
                buffer.append(ch);
            }
            ++i;
        }
        if (buffer.length() > 0) {
            list.add(buffer.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    public byte[] toCharByte(GC gc, String text) {
        byte[] bytes = new byte[text.length()];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = text.charAt(i) == '\n' ? (byte)0 : (byte)gc.stringExtent((String)new StringBuilder().append((char)text.charAt((int)i)).toString()).x;
            ++i;
        }
        return bytes;
    }

    private int toWordLength(int index) {
        int start = 0;
        int i = 0;
        while (i < index) {
            if (i < this.texts.length) {
                start += this.texts[i].length();
            }
            ++i;
        }
        return this.toWordLength(start, this.texts[index].length());
    }

    private int toWordLength(int start, int length) {
        int result = 0;
        int i = start;
        while (i < start + length) {
            result += this.charWidths[i];
            ++i;
        }
        return result;
    }

    public int[] splitLine(GC gc) {
        ArrayList<Integer> returnList = new ArrayList<Integer>();
        int dx = 0;
        int dy = 0;
        this.stringHeight = gc.getFontMetrics().getHeight();
        int index = 0;
        int j = 0;
        while (j < this.texts.length) {
            if (!this.texts[j].equals("\n")) {
                int length = this.toWordLength(index, this.texts[j].length());
                if (this.wrap && dx + length > this.width) {
                    returnList.add(new Integer(j));
                    dx = 0;
                    dy += this.stringHeight;
                }
                dx += length;
            } else {
                dx = 0;
                dy += this.stringHeight;
                returnList.add(new Integer(j));
            }
            index += this.texts[j].length();
            ++j;
        }
        Integer[] integers = returnList.toArray(new Integer[returnList.size()]);
        int[] ret = new int[integers.length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = integers[i];
            ++i;
        }
        return ret;
    }

    public String getWord(int index) {
        return this.texts[index];
    }

    public int countWord() {
        return this.texts.length;
    }

    public boolean isReturn(int index) {
        int i = 0;
        while (i < this.returnPoint.length) {
            if (this.returnPoint[i] == index) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

