/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.snack;

import jp.sourceforge.akjrcp.audiotools.WaveFormViewer;
import jp.sourceforge.akjrcp.snack.SmallFormant;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class FormantFigure
extends Figure {
    public static Log log = LogFactory.getLog(FormantFigure.class);
    private double formantFrameMilliSecond = 10.0;
    private final double basePPS = 6.25;
    SmallFormant[] formants;
    private int drawHeight = 512;
    private double offsetX;
    private int sampleRate = 48000;
    private double wzoom = 1.0;
    private double viewpps = 6.25 * this.wzoom;
    private boolean syncParent = true;
    private boolean fit;
    private boolean drawUnder = true;
    private int marginY;
    private int marginX;
    private Color[] fColor = new Color[]{new Color(null, 255, 0, 0), new Color(null, 0, 255, 0), new Color(null, 0, 0, 255)};

    public double getWzoom() {
        return this.wzoom;
    }

    public void setWzoom(double wzoom) {
        this.wzoom = wzoom;
        this.viewpps = 6.25 / wzoom;
        this.resize();
    }

    public boolean isFit() {
        return this.fit;
    }

    public void setFit(boolean fit) {
        this.fit = fit;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public void resize() {
        if (this.formants != null) {
            this.setSize((int)((double)this.formants.length * (this.formantFrameMilliSecond / this.viewpps)), this.drawHeight);
            log.trace((Object)("resize():" + this.getSize()));
        }
    }

    public int getMarginX() {
        return this.marginX;
    }

    public void setMarginX(int marginX) {
        this.marginX = marginX;
    }

    public int getMarginY() {
        return this.marginY;
    }

    public void setMarginY(int marginY) {
        this.marginY = marginY;
    }

    private int toYLocation(double value) {
        if (this.fit) {
            return this.drawHeight - (int)((double)(this.drawHeight - this.marginY * 2) * (value / (double)(this.sampleRate / 2)));
        }
        if (this.drawUnder) {
            return this.getParent().getClientArea().height - (int)((double)(this.drawHeight - this.marginY * 2) * (value / (double)(this.sampleRate / 2)));
        }
        return this.drawHeight - (int)((double)(this.drawHeight - this.marginY * 2) * (value / (double)(this.sampleRate / 2)));
    }

    public void paintFigure(Graphics g) {
        org.eclipse.swt.graphics.Rectangle r = WaveFormViewer.self.waveInfoCanvas.getBounds();
        Rectangle clip = new Rectangle(r.x, r.y, r.width, r.height);
        g.clipRect(clip);
        double ignorePixel = 0.0;
        int offset = (int)(this.offsetX * this.wzoom);
        if (this.syncParent) {
            offset += this.getParent().getBounds().x;
        }
        Point[] preF = new Point[3];
        if (this.formants != null) {
            log.info((Object)("formantsize:" + this.formants.length));
            double resize = this.formantFrameMilliSecond / this.viewpps;
            log.trace((Object)("resize:" + resize));
            int i = 0;
            while (i < this.formants.length) {
                int j = 0;
                while (j < 3) {
                    double f = j == 0 ? (double)this.formants[i].getF1() : (j == 1 ? (double)this.formants[i].getF2() : (double)this.formants[i].getF3());
                    Point currentF = new Point((double)offset + ignorePixel + (double)this.marginX * this.wzoom + (double)i * resize, (double)(this.marginY + this.toYLocation(f)));
                    g.setForegroundColor(this.fColor[j]);
                    if (i == 100) {
                        // empty if block
                    }
                    if (preF[j] != null) {
                        if (clip.contains(preF[j]) && clip.contains(currentF)) {
                            g.drawLine(preF[j], currentF);
                        }
                    } else {
                        g.drawLine(currentF, currentF);
                    }
                    preF[j] = currentF;
                    ++j;
                }
                ++i;
            }
        }
    }

    public void setFormants(SmallFormant[] formants) {
        this.formants = formants;
        this.resize();
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(double offsetX) {
        this.offsetX = offsetX;
    }
}

