/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.psp.imageconvert;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import jp.sourceforge.akjrcp.psp.imageconvert.AbstractImageChanger;

public class ImageSplitter
extends AbstractImageChanger {
    private int overwrap = 136;
    private int ignore = 3;
    private int splitNum = 4;
    private int mode;
    public static final int PIXEL_MODE = 0;
    public static final int NUMBER_MODE = 1;
    private boolean supportDoubleSize;
    private int doubleSizeLimit = 1300;

    public ImageSplitter() {
        this.time = System.currentTimeMillis();
    }

    public void changeImage(String imageFileName, InputStream imageInput, File exportDir) throws IOException {
        int thisHeight;
        int thisWidth;
        if (this.cancel) {
            return;
        }
        BufferedImage baseImage = this.imageLoader.loadImage(imageFileName, imageInput);
        if (baseImage == null) {
            return;
        }
        if (this.supportDoubleSize && baseImage.getWidth() > this.doubleSizeLimit) {
            thisWidth = this.width * 2;
            thisHeight = this.height * 2;
        } else {
            thisWidth = this.width;
            thisHeight = this.height;
        }
        double ratio = 1.0;
        ratio = (double)thisWidth / (double)baseImage.getWidth();
        int resizedImageHeight = (int)((double)baseImage.getHeight() * ratio);
        BufferedImage resizedImage = baseImage;
        if (ratio != 1.0) {
            BufferedImage rgb = this.toRGB(baseImage);
            baseImage.getGraphics().dispose();
            baseImage = null;
            System.gc();
            resizedImage = ImageSplitter.resize(rgb, thisWidth, resizedImageHeight);
            rgb.getGraphics().dispose();
            rgb = null;
            System.gc();
        }
        if (resizedImageHeight - this.ignore <= thisHeight) {
            this.saveImage(this.toRGB(resizedImage), 1, imageFileName, exportDir);
        } else {
            if (this.mode == 0) {
                this.splitImage(imageFileName, exportDir, resizedImage, resizedImageHeight, this.overwrap, thisWidth, thisHeight);
            } else {
                int mod = thisHeight * this.splitNum - resizedImageHeight;
                if (mod <= 0) {
                    int minSplit = resizedImageHeight / thisHeight;
                    if (resizedImageHeight % thisHeight > 0) {
                        ++minSplit;
                    }
                    int m = thisHeight * minSplit - resizedImageHeight;
                    double ov = 0.0;
                    if (m > 0) {
                        ov = (double)m / (double)(minSplit - 1);
                    }
                    this.splitImage(imageFileName, exportDir, resizedImage, resizedImageHeight, ov, thisWidth, thisHeight);
                } else {
                    double ov = (double)mod / (double)(this.splitNum - 1);
                    if (thisHeight == this.height * 2) {
                        int num = this.splitNum;
                        while (ov > (double)(thisHeight / 2)) {
                            int m = thisHeight * num - resizedImageHeight;
                            ov = (double)m / (double)(num - 1);
                            if (--num == 1) break;
                        }
                        this.splitImage(imageFileName, exportDir, resizedImage, resizedImageHeight, ov, thisWidth, thisHeight);
                    } else {
                        this.splitImage(imageFileName, exportDir, resizedImage, resizedImageHeight, ov, thisWidth, thisHeight);
                    }
                }
            }
            resizedImage.getGraphics().dispose();
            System.gc();
        }
    }

    public void splitImage(String imageFileName, File exportDir, BufferedImage resizedImage, int imageHeight, double wrapValue, int thisWidth, int thisHeight) throws IOException {
        int index = 1;
        double current = 0.0;
        while (current < (double)imageHeight) {
            if (this.cancel) {
                return;
            }
            if (current + wrapValue > (double)(imageHeight - this.ignore)) break;
            BufferedImage clipImage = new BufferedImage(thisWidth, thisHeight, 1);
            clipImage.getGraphics().drawImage(resizedImage, 0, 0, thisWidth, thisHeight, 0, (int)current, thisWidth, (int)((double)thisHeight + current), null);
            this.saveImage(clipImage, index, imageFileName, exportDir);
            current += (double)thisHeight - wrapValue;
            ++index;
            clipImage = null;
        }
    }

    public static BufferedImage resize(BufferedImage baseImage, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(baseImage, 0, 0, width, height, 0, 0, baseImage.getWidth(), baseImage.getHeight(), null);
        return image;
    }

    public int getOverwrap() {
        return this.overwrap;
    }

    public void setOverwrap(int overwrap) {
        this.overwrap = overwrap;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public boolean isSupportDoubleSize() {
        return this.supportDoubleSize;
    }

    public void setSupportDoubleSize(boolean supportDoubleSize) {
        this.supportDoubleSize = supportDoubleSize;
    }

    public int getSplitNum() {
        return this.splitNum;
    }

    public void setSplitNum(int splitNum) {
        this.splitNum = splitNum;
    }

    public int getDoubleSizeLimit() {
        return this.doubleSizeLimit;
    }

    public void setDoubleSizeLimit(int doubleSizeLimit) {
        this.doubleSizeLimit = doubleSizeLimit;
    }
}

