/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.dropsomething;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.dropsomething.DefaultFFMpegMonitor;
import jp.sourceforge.akjrcp.dropsomething.DirectoryBasedDropSomething;
import jp.sourceforge.akjrcp.dropsomething.FFMpegDropSomethingTab;
import jp.sourceforge.akjrcp.dropsomething.IDropSomething;
import jp.sourceforge.akjrcp.dropsomething.actions.MakePSPThumbnailAction;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegExecuter;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUI;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUtils;
import jp.sourceforge.akjrcp.psp.PSPFFMpegPreference;
import jp.sourceforge.akjrcp.psp.PSPMovieSetting;
import jp.sourceforge.akjrcp.psp.PSPMovieSettingTableViewer;
import jp.sourceforge.akjrcp.ui.FileOverwriteControler;
import jp.sourceforge.akjrcp.util.StatusBarUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PSPConvertTabBuilder
implements IDropSomething {
    private FileOverwriteControler fileOverwriteControler;
    public static final String TYPE_SELECT = "type_select";
    public static final String AVISYNTH = "avisynth";
    public static final String TWO_PASS = "twopass";
    public static final String PSPCONVERT = "pspconvert";
    private static String icon_xvid = "icons/psp_xvid1.png";
    private static String icon_xvid_hq = "icons/psp_xvid3.png";
    private static String icon_h264 = "icons/psp_h2641.png";
    private static String icon_h264_hq = "icons/psp_h2643.png";

    public void createTab(ViewPart part, CTabFolder tab) {
        CTabItem tabItem1 = new CTabItem(tab, 0);
        tabItem1.setText(Messages.getString("pspconvert.tab"));
        PSPConvertTab dtab = new PSPConvertTab((Composite)tab, 0);
        dtab.setViewPart(part);
        tabItem1.setControl((Control)dtab);
        this.fileOverwriteControler = new FileOverwriteControler(tab.getShell());
    }

    public static PSPFFMpegPreference toPreference(PSPMovieSetting setting) {
        PSPFFMpegPreference preference = new PSPFFMpegPreference();
        String ffmpegPath = FFMpegUI.getFFmpeg();
        preference.setFfmpegPath(ffmpegPath);
        preference.setFlags(new String[]{"bitexact"});
        preference.setExtension("mp4");
        preference.setFormat("psp");
        preference.setCoder(1);
        if (setting.getVideoCodec() == 1) {
            preference.setVideoCodec("h264");
            preference.setH264HQ(setting.isHighQuality());
            preference.setLevel(21);
        } else {
            preference.setVtag("mp4v");
            preference.setVideoCodec("xvid");
        }
        preference.setVideoBitrate(setting.getVideoBitrate() - 8);
        preference.setMaxRate(setting.getVideoBitrate());
        preference.setBufSize(setting.getVideoBitrate());
        setting.getVideoCodec();
        preference.setVideoRate(setting.getVideoRate());
        preference.setVideoSize(setting.getVideoSize());
        if (setting.getVideoSize().equals("368x272")) {
            preference.setLevel(30);
        } else if (setting.getVideoSize().equals("720x480")) {
            preference.setLevel(30);
        } else if (setting.getVideoSize().equals("480x272")) {
            preference.setLevel(30);
        } else if (setting.getVideoSize().equals("352x480")) {
            preference.setLevel(30);
        }
        if (preference.getLevel() == 30) {
            if (setting.getVideoBitrate() == 768) {
                preference.setMaxRate(4000);
                preference.setBufSize(4000);
            } else if (setting.getVideoBitrate() == 1536) {
                preference.setMaxRate(10000);
                preference.setBufSize(10000);
            }
        }
        preference.setAudioCodec("aac");
        preference.setAudioBitrate(setting.getAudioBitrate());
        preference.setAudioRate(setting.getAudioRate());
        preference.setAudioChannel(setting.getAudioChannel());
        return preference;
    }

    public class PSPConvertTab
    extends DirectoryBasedDropSomething
    implements FFMpegDropSomethingTab {
        private FFMpegExecuter ffmpegExecuter;
        private Label dragHere;
        private String currentTarget;
        private Button avisynth;
        private Button twoPass;
        private List settingList;
        private PSPMovieSettingTableViewer tableViewer;
        private Button fileChooser;

        public PSPConvertTab(Composite parent, int style) {
            super(parent, style);
        }

        public Composite createControls(Composite parent) {
            String typeSelected;
            this.settingList = new ArrayList();
            this.setPreferenceKey(PSPConvertTabBuilder.PSPCONVERT);
            SavePreferenceStore savePreference = new SavePreferenceStore();
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, true));
            Composite pspDirectoryPanel = new Composite(composite, 0);
            pspDirectoryPanel.setLayout((Layout)new GridLayout(2, false));
            Button pspFolder = new Button(pspDirectoryPanel, 8);
            pspFolder.setText("PSP\u30d3\u30c7\u30aa\u30d5\u30a9\u30eb\u30c0\u30fc\u3078\u51fa\u529b");
            pspFolder.addSelectionListener((SelectionListener)new SetPSPDir());
            this.createDirectoryInfo(composite);
            Composite typeGroup = new Composite(composite, 0);
            typeGroup.setLayout((Layout)new GridLayout(4, false));
            List list = PSPMovieSettingTableViewer.loadList(this.getPreferenceStore().getString("pspsetting.movie_settings"));
            log.info((Object)list.size());
            int i = 0;
            while (i < 4 & i < list.size()) {
                PSPSettingComposite setting = new PSPSettingComposite(typeGroup, 0, (PSPMovieSetting)list.get(i), i);
                this.settingList.add(setting);
                ++i;
            }
            GridData gd = new GridData(1808);
            this.tableViewer = new PSPMovieSettingTableViewer(composite);
            this.tableViewer.getTable().setLayoutData((Object)gd);
            this.tableViewer.setMovieSettingList(list);
            int defaultSelect = this.getPreferenceStore().getInt("ppssetting.movie_settings_index");
            this.tableViewer.getTable().setSelection(defaultSelect);
            this.tableViewer.addSelectionChangedListener(new StoreSelect());
            this.twoPass = new Button(composite, 32);
            this.twoPass.setText(Messages.getString("mpegconvert.twopass"));
            this.twoPass.setToolTipText(Messages.getString("mpegconvert.twopass_tooltip"));
            this.twoPass.addSelectionListener((SelectionListener)savePreference);
            this.twoPass.setVisible(false);
            this.avisynth = new Button(composite, 32);
            this.avisynth.setText(Messages.getString("pspconvert.use_avisynth"));
            this.avisynth.setToolTipText(Messages.getString("pspconvert.use_avisynth_tooltip"));
            this.avisynth.addSelectionListener((SelectionListener)savePreference);
            Composite dragHereComposite = new Composite(composite, 0);
            dragHereComposite.setLayout((Layout)new GridLayout(2, false));
            dragHereComposite.setLayoutData((Object)new GridData(768));
            this.dragHere = new Label(dragHereComposite, 0);
            this.dragHere.setLayoutData((Object)new GridData(768));
            this.fileChooser = new Button(dragHereComposite, 0);
            this.fileChooser.setText(Messages.getString("dropsomething.or_select_file"));
            this.fileChooser.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 2);
                    dialog.setFilterExtensions(new String[]{"*.avi;*.flv;*.mpg;*.wmv;*.avs;*.mp4;*.vob;*.mpeg"});
                    String path = dialog.open();
                    if (path != null) {
                        if (PSPConvertTab.this.isCanConvert()) {
                            String[] paths = dialog.getFileNames();
                            int i = 0;
                            while (i < paths.length) {
                                PSPConvertTab.this.addDragAndDropFile(paths[i]);
                                ++i;
                            }
                        } else {
                            StatusBarUtils.showStatusBar(PSPConvertTab.this.getCantConvertStatusbarMessage());
                        }
                    }
                }
            });
            IPreferenceStore store = this.getPreferenceStore();
            store.setDefault(String.valueOf(this.getPreferenceKey()) + "." + PSPConvertTabBuilder.TYPE_SELECT, "h2642_2");
            this.currentTarget = typeSelected = store.getString(String.valueOf(this.getPreferenceKey()) + "." + PSPConvertTabBuilder.TYPE_SELECT);
            log.info((Object)(String.valueOf(this.getPreferenceKey()) + "." + PSPConvertTabBuilder.TYPE_SELECT + "," + this.currentTarget));
            this.restoreControl((Control)this.avisynth);
            this.restoreControl((Control)this.twoPass);
            this.updateStatus();
            PlatformUI.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)new SettingMonitor());
            return composite;
        }

        public void restoreControl(Control control) {
            IPreferenceStore store = this.getPreferenceStore();
            if (control == this.avisynth) {
                this.avisynth.setSelection(store.getBoolean(String.valueOf(this.getPreferenceKey()) + "." + PSPConvertTabBuilder.AVISYNTH));
            } else if (control == this.twoPass) {
                this.twoPass.setSelection(store.getBoolean(String.valueOf(this.getPreferenceKey()) + "." + PSPConvertTabBuilder.TWO_PASS));
            }
        }

        public void selectCombo(CCombo combo, String value) {
            int s = combo.getItemCount();
            int i = 0;
            while (i < s) {
                if (combo.getItem(i).equals(value)) {
                    combo.select(i);
                    break;
                }
                ++i;
            }
        }

        public void storeControl(Control control) {
            IPreferenceStore store = this.getPreferenceStore();
            if (control == this.avisynth) {
                store.setValue(String.valueOf(this.getPreferenceKey()) + "." + PSPConvertTabBuilder.AVISYNTH, this.avisynth.getSelection());
            } else if (control == this.twoPass) {
                store.setValue(String.valueOf(this.getPreferenceKey()) + "." + PSPConvertTabBuilder.TWO_PASS, this.twoPass.getSelection());
            }
        }

        public String toTime(long bps, long maxMega) {
            String sstring;
            String mstring;
            long bytes = bps / 8L;
            long second = maxMega * 1024L * 1024L / bytes;
            long hour = second / 3600L;
            long min = (second %= 3600L) / 60L;
            long sec = second % 60L;
            String hstring = "" + hour;
            if (hstring.length() < 2) {
                hstring = "0" + hstring;
            }
            if ((mstring = "" + min).length() < 2) {
                mstring = "0" + mstring;
            }
            if ((sstring = "" + sec).length() < 2) {
                sstring = "0" + sstring;
            }
            return String.valueOf(hstring) + ":" + mstring + ":" + sstring;
        }

        public void inconvert(File file) {
            this.ffmpegExecuter.execute(new File[]{file});
        }

        public void beforeConvert() {
            this.ffmpegExecuter = new FFMpegExecuter();
            DefaultFFMpegMonitor monitor = new DefaultFFMpegMonitor(this, "PSP");
            monitor.setAfterAction(new MakePSPThumbnailAction());
            this.ffmpegExecuter.setExecuteListener(monitor);
            PSPMovieSetting setting = (PSPMovieSetting)this.tableViewer.getMovieSettingList().get(this.tableViewer.getTable().getSelectionIndex());
            PSPFFMpegPreference preference = PSPConvertTabBuilder.toPreference(setting);
            log.info((Object)("hq:" + preference.isH264HQ()));
            this.setHeaderText(this.tableViewer.toLabel(setting));
            log.info((Object)preference);
            boolean threads = FFMpegUI.isUseThread();
            if (threads) {
                preference.setThreads(2);
            }
            this.ffmpegExecuter.setFfmpegPreference(preference);
            this.ffmpegExecuter.setUseAvisynth(this.avisynth.getSelection());
            this.ffmpegExecuter.setIgnoreAvisynthExtensions(new String[0]);
            this.ffmpegExecuter.setSameDirectory(this.samefolder.getSelection());
            this.ffmpegExecuter.setBackup(this.backup.getSelection());
            if (!this.samefolder.getSelection()) {
                this.ffmpegExecuter.setExportDir(this.directoryChooser.getAbsoluteFilePath());
            }
        }

        public void afterConvert() {
        }

        public boolean isCanConvert() {
            String ffmpegPath = FFMpegUI.getFFmpeg();
            if (!FFMpegUtils.isFFMpegAvailable(ffmpegPath)) {
                this.setCantConvertStatusbarMessage(Messages.getString("ffmpeg_statusbar.no_ffmpeg"));
                return false;
            }
            return super.isCanConvert();
        }

        public void cancelConvert() {
            this.ffmpegExecuter.cancel();
        }

        public void updateStatus() {
            if (this.samefolder.getSelection() || this.directoryChooser.getFile() != null) {
                this.setMessage(Messages.getString("dropsomething.drag_folder"));
                this.setCanConvert(true);
            } else {
                this.setErrorMessage(Messages.getString("dropsomething.choose_folder"));
                this.setCantConvertStatusbarMessage(Messages.getString("dropsomething.choose_folder"));
                this.setCanConvert(false);
            }
            if (!FFMpegUtils.isFFMpegAvailable(FFMpegUI.getFFmpeg())) {
                this.setErrorMessage(Messages.getString("dropsomething.setup_ffmpeg"));
            }
            if (this.fileChooser != null) {
                this.fileChooser.setEnabled(this.isCanConvert());
            }
        }

        public void setMessage(String text) {
            if (this.dragHere != null) {
                this.dragHere.setForeground(new Color(null, 64, 200, 64));
                this.dragHere.setText(text);
            }
        }

        public void setErrorMessage(String text) {
            if (this.dragHere != null) {
                this.dragHere.setForeground(new Color(null, 255, 0, 0));
                this.dragHere.setText(text);
            }
        }

        public IPreferenceStore getPreferenceStore() {
            return Akj_betasPlugin.getDefault().getPreferenceStore();
        }

        public boolean setFocus() {
            return this.tableViewer.getTable().setFocus();
        }

        public FFMpegExecuter getFFMpegExecuter() {
            return this.ffmpegExecuter;
        }

        public FileOverwriteControler getFileOverWriteControler() {
            return PSPConvertTabBuilder.this.fileOverwriteControler;
        }

        public class SettingMonitor
        implements IPropertyChangeListener {
            public void propertyChange(PropertyChangeEvent event) {
                log.info((Object)event.getProperty());
                if (event.getProperty().equals("ffmpeg.ffmpeg_path")) {
                    PSPConvertTab.this.updateStatus();
                }
            }
        }

        public class StoreSelect
        implements ISelectionChangedListener {
            public void selectionChanged(SelectionChangedEvent event) {
                PSPConvertTab.this.getPreferenceStore().setValue("ppssetting.movie_settings_index", PSPConvertTab.this.tableViewer.getTable().getSelectionIndex());
            }
        }

        public class SetPSPDir
        implements SelectionListener {
            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent e) {
                File[] roots = File.listRoots();
                int i = roots.length - 1;
                while (i > 0) {
                    File videoFolder;
                    File tmp = new File(roots[i], "PSP");
                    if (tmp.exists() && (videoFolder = new File(roots[i], "VIDEO")).exists()) {
                        PSPConvertTab.this.directoryChooser.setEnabled(true);
                        PSPConvertTab.this.samefolder.setSelection(false);
                        PSPConvertTab.this.directoryChooser.setFile(videoFolder);
                        PSPConvertTab.this.updateStatus();
                    }
                    --i;
                }
            }
        }

        public class PSPSettingComposite
        extends Composite
        implements SelectionListener {
            private Button checkbox;
            private int tableIndex;

            public boolean getSlected() {
                return this.checkbox.getSelection();
            }

            public Button getButton() {
                return this.checkbox;
            }

            public PSPSettingComposite(Composite parent, int style, PSPMovieSetting setting, int tableIndex) {
                super(parent, style);
                this.tableIndex = tableIndex;
                this.setLayout((Layout)new GridLayout(3, false));
                this.checkbox = new Button((Composite)this, 0);
                this.checkbox.addSelectionListener((SelectionListener)this);
                String icon = null;
                icon = setting.getVideoCodec() == 0 ? (setting.isHighQuality() ? icon_xvid_hq : icon_xvid) : (setting.isHighQuality() ? icon_h264_hq : icon_h264);
                this.checkbox.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"jp.sourceforge.akjrcp.akj_betas", (String)icon).createImage());
                Label infoLabel = new Label((Composite)this, 0);
                String info = "";
                info = String.valueOf(info) + setting.getVideoSize() + " " + setting.getVideoBitrate() + "k " + "\n";
                info = String.valueOf(info) + setting.getAudioRate() + "hz " + setting.getAudioBitrate() + "k" + "\n";
                info = String.valueOf(info) + setting.getComment();
                infoLabel.setText(info);
            }

            public void mouseReleased(MouseEvent arg0) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PSPConvertTab.this.tableViewer.getTable().setSelection(this.tableIndex);
                PSPConvertTab.this.tableViewer.getTable().setFocus();
            }
        }

        public class SavePreferenceStore
        implements SelectionListener {
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PSPConvertTab.this.storeControl((Control)e.getSource());
            }
        }
    }
}

