/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.audiotools.spectrogram;

import java.io.File;
import java.util.Iterator;
import jp.sourceforge.akjrcp.audiotools.spectrogram.SpectrogramDrawInfo;
import jp.sourceforge.akjrcp.audiotools.spectrogram.SpectrogramFigure;
import jp.sourceforge.akjrcp.ui.draw2d.FileImageCache;
import jp.sourceforge.akjrcp.ui.draw2d.ScalableImageFigure;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class SpectrogramListFigure
extends Figure
implements SpectrogramDrawInfo {
    public static Log log = LogFactory.getLog(SpectrogramListFigure.class);
    private int samplerate = 48000;
    public static final int MAX_SAMPLERATE = 48000;
    private int baseHeight = 512;
    private boolean fit;
    private double vzoom = 1.0;
    private double wzoom = 1.0;
    private double offsetX;
    private boolean drawUnder = true;

    public SpectrogramListFigure() {
        this.setLayoutManager((LayoutManager)new ListLayout());
        this.setSize(100, this.baseHeight);
    }

    public int getBaseHeight() {
        return this.baseHeight;
    }

    public void setBaseHeight(int baseHeight) {
        this.baseHeight = baseHeight;
    }

    public boolean isFit() {
        return this.fit;
    }

    public void setFit(boolean fit) {
        this.fit = fit;
    }

    public int getSampleRate() {
        return this.samplerate;
    }

    public void setSampleRate(int samplerate) {
        this.samplerate = samplerate;
    }

    public double getVzoom() {
        return this.vzoom;
    }

    public void setVzoom(double vzoom) {
        this.vzoom = vzoom;
    }

    public double getWzoom() {
        return this.wzoom;
    }

    public void setWzoom(double wzoom) {
        this.wzoom = wzoom;
        IFigure[] figures = this.getChildren().toArray(new IFigure[this.getChildren().size()]);
        int i = 0;
        while (i < figures.length) {
            if (figures[i] instanceof ScalableImageFigure) {
                ((ScalableImageFigure)figures[i]).setScale(wzoom, this.vzoom);
            }
            ++i;
        }
        this.revalidate();
    }

    public void setZoom(double w, double v) {
        this.setVzoom(v);
        this.setWzoom(w);
    }

    public void paintFigure(Graphics g) {
    }

    public void init(int imageWidth, int compositeHeight, int totalPixelSize, FileImageCache imageCache, File baseFolder) {
        this.removeAll();
        this.baseHeight = compositeHeight;
        log.warn((Object)("pixelSize = " + totalPixelSize + ",imageWidth=" + imageWidth));
        int figureNumber = totalPixelSize / imageWidth;
        if (totalPixelSize % imageWidth > 0) {
            ++figureNumber;
        }
        log.trace((Object)("image-Figure-Size:" + figureNumber));
        int i = 0;
        while (i < figureNumber) {
            SpectrogramFigure scalableImageFigure = new SpectrogramFigure(this, imageCache, new File(baseFolder, String.valueOf(SpectrogramListFigure.toLabel(i)) + ".gif").getAbsolutePath(), imageWidth, compositeHeight);
            scalableImageFigure.setScale(this.wzoom, this.vzoom);
            this.add(scalableImageFigure);
            ++i;
        }
        this.revalidate();
    }

    public static String toLabel(int v) {
        int k = 5;
        String ret = "" + v;
        while (ret.length() < k) {
            ret = "0" + ret;
        }
        return ret;
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(double offsetX) {
        this.offsetX = offsetX;
    }

    public class ListLayout
    extends AbstractHintLayout {
        protected Dimension calculatePreferredSize(IFigure arg0, int arg1, int arg2) {
            return arg0.getPreferredSize(arg1, arg2);
        }

        public void layout(IFigure parent) {
            Iterator iterator = parent.getChildren().iterator();
            double dx = (int)(SpectrogramListFigure.this.offsetX * SpectrogramListFigure.this.wzoom);
            if (SpectrogramListFigure.this.getParent().getBounds().x < 0) {
                dx += (double)SpectrogramListFigure.this.getParent().getBounds().x;
            }
            int marginY = 0;
            int dy = 0;
            if (SpectrogramListFigure.this.drawUnder) {
                dy = SpectrogramListFigure.this.getClientArea().height - SpectrogramListFigure.this.baseHeight - marginY;
            }
            while (iterator.hasNext()) {
                SpectrogramFigure f = (SpectrogramFigure)iterator.next();
                Dimension d = f.getPreferredSize();
                Rectangle rect = new Rectangle((int)dx, dy, d.width, d.height);
                f.setBounds(rect);
                dx += f.calculateImageWidth();
            }
        }
    }
}

