/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osgi.internal.module.ResolverImpl;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.GenericDescriptionImpl;
import org.eclipse.osgi.internal.resolver.GenericSpecificationImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ImportPackageSpecificationImpl;
import org.eclipse.osgi.internal.resolver.StateBuilder;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.StateReader;
import org.eclipse.osgi.internal.resolver.StateWriter;
import org.eclipse.osgi.internal.resolver.SystemState;
import org.eclipse.osgi.internal.resolver.UserState;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class StateObjectFactoryImpl
implements StateObjectFactory {
    public BundleDescription createBundleDescription(Dictionary manifest, String location, long id) throws BundleException {
        return this.createBundleDescription(null, manifest, location, id);
    }

    public BundleDescription createBundleDescription(State state, Dictionary manifest, String location, long id) throws BundleException {
        BundleDescriptionImpl result = (BundleDescriptionImpl)StateBuilder.createBundleDescription((StateImpl)state, manifest, location);
        result.setBundleId(id);
        return result;
    }

    public BundleDescription createBundleDescription(long id, String symbolicName, Version version, String location, BundleSpecification[] required, HostSpecification host, ImportPackageSpecification[] imports, ExportPackageDescription[] exports, String[] providedPackages, boolean singleton) {
        return this.createBundleDescription(id, symbolicName, version, location, required, host, imports, exports, providedPackages, singleton, true, true, null, null, null, null);
    }

    public BundleDescription createBundleDescription(long id, String symbolicName, Version version, String location, BundleSpecification[] required, HostSpecification host, ImportPackageSpecification[] imports, ExportPackageDescription[] exports, String[] providedPackages, boolean singleton, boolean attachFragments, boolean dynamicFragments, String platformFilter, String executionEnvironment, GenericSpecification[] genericRequires, GenericDescription[] genericCapabilities) {
        return this.createBundleDescription(id, symbolicName, version, location, required, host, imports, exports, singleton, attachFragments, dynamicFragments, platformFilter, ManifestElement.getArrayFromList(executionEnvironment), genericRequires, genericCapabilities);
    }

    public BundleDescription createBundleDescription(long id, String symbolicName, Version version, String location, BundleSpecification[] required, HostSpecification host, ImportPackageSpecification[] imports, ExportPackageDescription[] exports, boolean singleton, boolean attachFragments, boolean dynamicFragments, String platformFilter, String[] executionEnvironments, GenericSpecification[] genericRequires, GenericDescription[] genericCapabilities) {
        BundleDescriptionImpl bundle = new BundleDescriptionImpl();
        bundle.setBundleId(id);
        bundle.setSymbolicName(symbolicName);
        bundle.setVersion(version);
        bundle.setLocation(location);
        bundle.setRequiredBundles(required);
        bundle.setHost(host);
        bundle.setImportPackages(imports);
        bundle.setExportPackages(exports);
        bundle.setStateBit(2, singleton);
        bundle.setStateBit(64, attachFragments);
        bundle.setStateBit(128, dynamicFragments);
        bundle.setPlatformFilter(platformFilter);
        bundle.setExecutionEnvironments(executionEnvironments);
        bundle.setGenericRequires(genericRequires);
        bundle.setGenericCapabilities(genericCapabilities);
        return bundle;
    }

    public BundleDescription createBundleDescription(BundleDescription original) {
        BundleDescriptionImpl bundle = new BundleDescriptionImpl();
        bundle.setBundleId(original.getBundleId());
        bundle.setSymbolicName(original.getSymbolicName());
        bundle.setVersion(original.getVersion());
        bundle.setLocation(original.getLocation());
        BundleSpecification[] originalRequired = original.getRequiredBundles();
        BundleSpecification[] newRequired = new BundleSpecification[originalRequired.length];
        int i = 0;
        while (i < newRequired.length) {
            newRequired[i] = this.createBundleSpecification(originalRequired[i]);
            ++i;
        }
        bundle.setRequiredBundles(newRequired);
        ExportPackageDescription[] originalExports = original.getExportPackages();
        ExportPackageDescription[] newExports = new ExportPackageDescription[originalExports.length];
        int i2 = 0;
        while (i2 < newExports.length) {
            newExports[i2] = this.createExportPackageDescription(originalExports[i2]);
            ++i2;
        }
        bundle.setExportPackages(newExports);
        ImportPackageSpecification[] originalImports = original.getImportPackages();
        ImportPackageSpecification[] newImports = new ImportPackageSpecification[originalImports.length];
        int i3 = 0;
        while (i3 < newImports.length) {
            newImports[i3] = this.createImportPackageSpecification(originalImports[i3]);
            ++i3;
        }
        bundle.setImportPackages(newImports);
        if (original.getHost() != null) {
            bundle.setHost(this.createHostSpecification(original.getHost()));
        }
        bundle.setStateBit(2, original.isSingleton());
        bundle.setStateBit(64, original.attachFragments());
        bundle.setStateBit(128, original.dynamicFragments());
        bundle.setStateBit(32, original.hasDynamicImports());
        bundle.setPlatformFilter(original.getPlatformFilter());
        bundle.setExecutionEnvironments(original.getExecutionEnvironments());
        bundle.setGenericCapabilities(this.createGenericCapabilities(original.getGenericCapabilities()));
        bundle.setGenericRequires(this.createGenericRequires(original.getGenericRequires()));
        return bundle;
    }

    private GenericDescription[] createGenericCapabilities(GenericDescription[] genericCapabilities) {
        if (genericCapabilities == null || genericCapabilities.length == 0) {
            return null;
        }
        GenericDescription[] result = new GenericDescription[genericCapabilities.length];
        int i = 0;
        while (i < genericCapabilities.length) {
            GenericDescriptionImpl cap = new GenericDescriptionImpl();
            cap.setName(genericCapabilities[i].getName());
            cap.setVersion(genericCapabilities[i].getVersion());
            cap.setAttributes(genericCapabilities[i].getAttributes());
            result[i] = cap;
            ++i;
        }
        return result;
    }

    private GenericSpecification[] createGenericRequires(GenericSpecification[] genericRequires) {
        if (genericRequires == null || genericRequires.length == 0) {
            return null;
        }
        GenericSpecification[] result = new GenericSpecification[genericRequires.length];
        int i = 0;
        while (i < genericRequires.length) {
            GenericSpecificationImpl req = new GenericSpecificationImpl();
            req.setName(genericRequires[i].getName());
            try {
                req.setMatchingFilter(genericRequires[i].getMatchingFilter());
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
            result[i] = req;
            ++i;
        }
        return result;
    }

    public BundleSpecification createBundleSpecification(String requiredSymbolicName, VersionRange requiredVersionRange, boolean export, boolean optional) {
        BundleSpecificationImpl bundleSpec = new BundleSpecificationImpl();
        bundleSpec.setName(requiredSymbolicName);
        bundleSpec.setVersionRange(requiredVersionRange);
        bundleSpec.setExported(export);
        bundleSpec.setOptional(optional);
        return bundleSpec;
    }

    public BundleSpecification createBundleSpecification(BundleSpecification original) {
        BundleSpecificationImpl bundleSpec = new BundleSpecificationImpl();
        bundleSpec.setName(original.getName());
        bundleSpec.setVersionRange(original.getVersionRange());
        bundleSpec.setExported(original.isExported());
        bundleSpec.setOptional(original.isOptional());
        return bundleSpec;
    }

    public HostSpecification createHostSpecification(String hostSymbolicName, VersionRange versionRange) {
        HostSpecificationImpl hostSpec = new HostSpecificationImpl();
        hostSpec.setName(hostSymbolicName);
        hostSpec.setVersionRange(versionRange);
        return hostSpec;
    }

    public HostSpecification createHostSpecification(HostSpecification original) {
        HostSpecificationImpl hostSpec = new HostSpecificationImpl();
        hostSpec.setName(original.getName());
        hostSpec.setVersionRange(original.getVersionRange());
        return hostSpec;
    }

    public ImportPackageSpecification createImportPackageSpecification(String packageName, VersionRange versionRange, String bundleSymbolicName, VersionRange bundleVersionRange, Map directives, Map attributes, BundleDescription importer) {
        ImportPackageSpecificationImpl packageSpec = new ImportPackageSpecificationImpl();
        packageSpec.setName(packageName);
        packageSpec.setVersionRange(versionRange);
        packageSpec.setBundleSymbolicName(bundleSymbolicName);
        packageSpec.setBundleVersionRange(bundleVersionRange);
        packageSpec.setDirectives(directives);
        packageSpec.setAttributes(attributes);
        packageSpec.setBundle(importer);
        return packageSpec;
    }

    public ImportPackageSpecification createImportPackageSpecification(ImportPackageSpecification original) {
        ImportPackageSpecificationImpl packageSpec = new ImportPackageSpecificationImpl();
        packageSpec.setName(original.getName());
        packageSpec.setVersionRange(original.getVersionRange());
        packageSpec.setBundleSymbolicName(original.getBundleSymbolicName());
        packageSpec.setBundleVersionRange(original.getBundleVersionRange());
        packageSpec.setDirectives(original.getDirectives());
        packageSpec.setAttributes(original.getAttributes());
        return packageSpec;
    }

    public ExportPackageDescription createExportPackageDescription(ExportPackageDescription original) {
        return this.createExportPackageDescription(original.getName(), original.getVersion(), original.getDirectives(), original.getAttributes(), original.isRoot(), null);
    }

    public ExportPackageDescription createExportPackageDescription(String packageName, Version version, Map directives, Map attributes, boolean root, BundleDescription exporter) {
        ExportPackageDescriptionImpl exportPackage = new ExportPackageDescriptionImpl();
        exportPackage.setName(packageName);
        exportPackage.setVersion(version);
        exportPackage.setDirectives(directives);
        exportPackage.setAttributes(attributes);
        exportPackage.setRoot(root);
        exportPackage.setExporter(exporter);
        return exportPackage;
    }

    public GenericDescription createGenericDescription(String name, String type, Version version, Map attributes) {
        Object versionObj;
        GenericDescriptionImpl result = new GenericDescriptionImpl();
        result.setName(name);
        result.setType(type);
        result.setVersion(version);
        Object v0 = versionObj = attributes == null ? null : attributes.remove("version");
        if (versionObj instanceof Version) {
            result.setVersion(versionObj);
        }
        Hashtable attrs = new Hashtable();
        if (attributes != null) {
            Iterator keys = attributes.keySet().iterator();
            while (keys.hasNext()) {
                Object key = keys.next();
                ((Dictionary)attrs).put(key, attributes.get(key));
            }
        }
        result.setAttributes(attrs);
        return result;
    }

    public GenericSpecification createGenericSpecification(String name, String type, String matchingFilter, boolean optional, boolean multiple) throws InvalidSyntaxException {
        GenericSpecificationImpl result = new GenericSpecificationImpl();
        result.setName(name);
        result.setType(type);
        result.setMatchingFilter(matchingFilter);
        int resolution = 0;
        if (optional) {
            resolution |= 1;
        }
        if (multiple) {
            resolution |= 2;
        }
        result.setResolution(resolution);
        return result;
    }

    public SystemState createSystemState() {
        SystemState state = new SystemState();
        state.setFactory(this);
        return state;
    }

    public State createState() {
        return this.internalCreateState();
    }

    public State createState(boolean createResolver) {
        StateImpl result = this.internalCreateState();
        if (createResolver) {
            result.setResolver(new ResolverImpl(null, false));
        }
        return result;
    }

    public State createState(State original) {
        StateImpl newState = this.internalCreateState();
        newState.setTimeStamp(original.getTimeStamp());
        BundleDescription[] bundles = original.getBundles();
        int i = 0;
        while (i < bundles.length) {
            newState.basicAddBundle(this.createBundleDescription(bundles[i]));
            ++i;
        }
        newState.setResolved(false);
        return newState;
    }

    private StateImpl internalCreateState() {
        UserState state = new UserState();
        state.setFactory(this);
        return state;
    }

    public SystemState readSystemState(File stateFile, File lazyFile, boolean lazyLoad, long expectedTimeStamp) throws IOException {
        StateReader reader = new StateReader(stateFile, lazyFile, lazyLoad);
        SystemState restoredState = new SystemState();
        restoredState.setReader(reader);
        restoredState.setFactory(this);
        if (!reader.loadState(restoredState, expectedTimeStamp)) {
            return null;
        }
        return restoredState;
    }

    public State readState(InputStream stream) throws IOException {
        return this.internalReadStateDeprecated(this.internalCreateState(), new DataInputStream(stream), -1L);
    }

    public State readState(DataInputStream stream) throws IOException {
        return this.internalReadStateDeprecated(this.internalCreateState(), stream, -1L);
    }

    public State readState(File stateDirectory) throws IOException {
        return this.internalReadState(this.internalCreateState(), stateDirectory, -1L);
    }

    private State internalReadStateDeprecated(StateImpl toRestore, DataInputStream stream, long expectedTimestamp) throws IOException {
        StateReader reader = new StateReader();
        if (!reader.loadStateDeprecated(toRestore, stream, expectedTimestamp)) {
            return null;
        }
        return toRestore;
    }

    private State internalReadState(StateImpl toRestore, File stateDirectory, long expectedTimestamp) throws IOException {
        File stateFile = new File(stateDirectory, ".state");
        File lazyFile = new File(stateDirectory, ".lazy");
        StateReader reader = new StateReader(stateFile, lazyFile, false);
        if (!reader.loadState(toRestore, expectedTimestamp)) {
            return null;
        }
        return toRestore;
    }

    public void writeState(State state, DataOutputStream stream) throws IOException {
        this.internalWriteStateDeprecated(state, stream);
    }

    public void writeState(State state, File stateDirectory) throws IOException {
        if (stateDirectory == null) {
            throw new IOException();
        }
        StateWriter writer = new StateWriter();
        File stateFile = new File(stateDirectory, ".state");
        File lazyFile = new File(stateDirectory, ".lazy");
        writer.saveState((StateImpl)state, stateFile, lazyFile);
    }

    public void writeState(State state, OutputStream stream) throws IOException {
        this.internalWriteStateDeprecated(state, new DataOutputStream(stream));
    }

    public void writeState(State state, File stateFile, File lazyFile) throws IOException {
        StateWriter writer = new StateWriter();
        writer.saveState((StateImpl)state, stateFile, lazyFile);
    }

    public void internalWriteStateDeprecated(State state, DataOutputStream stream) throws IOException {
        if (state.getFactory() != this) {
            throw new IllegalArgumentException();
        }
        StateWriter writer = new StateWriter();
        writer.saveStateDeprecated((StateImpl)state, stream);
    }
}

