/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.util.directorybased;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import jp.sourceforge.akjrcp.util.ProcessPrinter;
import jp.sourceforge.akjrcp.util.directorybased.DirectoryBasedCommand;
import jp.sourceforge.akjrcp.util.image.ImageUtils;
import jp.sourceforge.akjrcp.util.image.PBMImageFactory;

public class PbmToImageCommand
implements DirectoryBasedCommand {
    private File srcName;
    private File destName;
    private String imageType;

    public PbmToImageCommand(File srcName, File destName, String imageType) {
        this.srcName = srcName;
        this.destName = destName;
        this.imageType = imageType;
    }

    public int exec() throws IOException {
        if (this.srcName == null || this.destName == null) {
            return -1;
        }
        FileInputStream finput = new FileInputStream(this.srcName);
        PBMImageFactory factory = new PBMImageFactory(finput);
        BufferedImage bimage = factory.createByPBM();
        finput.close();
        BufferedImage tmpImage = new BufferedImage(bimage.getWidth(), bimage.getHeight(), 1);
        tmpImage.getGraphics().drawImage(bimage, 0, 0, null);
        if (this.imageType.toLowerCase().equals("jpg") || this.imageType.toLowerCase().equals("jpeg")) {
            ImageUtils.writeJpegWithQuality(tmpImage, this.destName, 1.0f);
        } else {
            ImageIO.write((RenderedImage)tmpImage, this.imageType, this.destName);
        }
        return 0;
    }

    public Process getProcess() {
        return null;
    }

    public void setProcessPrinter(ProcessPrinter processPrinter) {
        try {
            processPrinter.printOutput("pbm to " + this.imageType + " from " + this.srcName + " to " + this.destName + "\r\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

