/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class NewIOFileCopy {
    private static int MAX_COPY = 0x400000;
    private File srcFile;
    private File destFile;
    private boolean canceling;

    public NewIOFileCopy(File srcFile, File destFile) {
        this.srcFile = srcFile;
        this.destFile = destFile;
    }

    public boolean isCanceling() {
        return this.canceling;
    }

    public void setCanceling(boolean canceling) {
        this.canceling = canceling;
    }

    public File getSrcFile() {
        return this.srcFile;
    }

    public void setSrcFile(File srcFile) {
        this.srcFile = srcFile;
    }

    public File getDestFile() {
        return this.destFile;
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int exec() throws IOException {
        FileChannel srcChannel = new FileInputStream(this.getSrcFile()).getChannel();
        FileChannel destChannel = new FileOutputStream(this.getDestFile()).getChannel();
        int myMax = (long)MAX_COPY > this.getSrcFile().length() ? MAX_COPY : (int)this.getSrcFile().length();
        try {
            long size = srcChannel.size();
            long index = 0L;
            while (index < size && !this.canceling) {
                int length = index + (long)myMax < size ? myMax : (int)(size - index);
                MappedByteBuffer srcBuffer = srcChannel.map(FileChannel.MapMode.READ_ONLY, index, length);
                if (this.getDestFile().exists()) {
                    destChannel.write(srcBuffer);
                }
                index += (long)length;
            }
        }
        finally {
            try {
                srcChannel.close();
                srcChannel = null;
                destChannel.close();
                destChannel = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.gc();
        }
        if (this.canceling) {
            return 1;
        }
        return 0;
    }
}

