/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ui.param;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.akjrcp.ui.param.AbstractParamCompositeItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;

public class ParamScale
extends AbstractParamCompositeItem {
    private String key;
    private String label;
    private Label labelItem;
    private String value = "";
    private Scale scale;
    private Label footLabelItem;
    private int offset;
    Pattern pattern = Pattern.compile("%(\\d+)d");

    public String getKey() {
        return this.key;
    }

    public String getLabel() {
        return this.label;
    }

    public void setToolTipText(String text) {
        this.labelItem.setToolTipText(text);
        this.scale.setToolTipText(text);
    }

    public String getValue() {
        return "" + (this.scale.getSelection() + this.offset);
    }

    public void setValue(int value) {
        this.value = "" + value;
        this.scale.setSelection(value - this.offset);
        this.updateLabel();
    }

    public void setValue(String value) {
        this.value = value;
        if (value.length() > 0) {
            this.scale.setSelection(Integer.parseInt(value) - this.offset);
            this.updateLabel();
        }
    }

    public ParamScale(Composite parent, int style, String key, String label, int min, int current, int max) {
        this(parent, style, key, label);
        this.setMinimum(min);
        this.setValue(current);
        this.setMaximum(max);
    }

    public ParamScale(Composite parent, int style, String key, String label) {
        super(parent, style);
        this.key = key;
        this.label = label;
        this.setLayout((Layout)new GridLayout(2, false));
        this.labelItem = new Label((Composite)this, 0);
        this.scale = new Scale((Composite)this, 0);
        this.scale.addSelectionListener((SelectionListener)new LabelUpdate());
        Listener dragListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 37: {
                        ParamScale.this.updateLabel();
                    }
                }
            }
        };
        this.scale.addListener(37, dragListener);
        this.scale.addSelectionListener((SelectionListener)new AbstractParamCompositeItem.SelectionCheck());
        this.scale.addListener(37, (Listener)new AbstractParamCompositeItem.WheelCheck());
        this.updateLabel();
    }

    protected String toValue(String n) {
        int num = Integer.parseInt(n);
        String ret = this.getValue();
        while (ret.length() < num) {
            ret = "0" + ret;
        }
        return ret;
    }

    public void updateLabel() {
        int p = this.label.indexOf("%");
        if (p != -1) {
            Matcher matcher = this.pattern.matcher(this.label);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                String num = matcher.group(1);
                String value = this.toValue(num);
                matcher.appendReplacement(sb, value);
            }
            matcher.appendTail(sb);
            this.labelItem.setText(sb.toString());
            return;
        }
        this.labelItem.setText(this.label);
    }

    public boolean isModified() {
        String oldValue = this.getValue();
        return !oldValue.equals(this.value);
    }

    public void setMaximum(int max) {
        this.scale.setMaximum(max);
    }

    public void setMinimum(int min) {
        this.scale.setMinimum(min);
    }

    public Scale getScale() {
        return this.scale;
    }

    public void setScale(Scale scale) {
        this.scale = scale;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
        this.updateLabel();
    }

    public class LabelUpdate
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
            ParamScale.this.updateLabel();
        }

        public void widgetSelected(SelectionEvent e) {
            ParamScale.this.updateLabel();
        }
    }
}

