/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ui.draw2d;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import jp.sourceforge.akjrcp.ui.draw2d.AlphaLayerFigure;
import jp.sourceforge.akjrcp.ui.draw2d.ChainedFlowFigure;
import jp.sourceforge.akjrcp.ui.draw2d.DefaultZoom;
import jp.sourceforge.akjrcp.ui.draw2d.DoubleScalableFigure;
import jp.sourceforge.akjrcp.ui.draw2d.GraphLabelProvider;
import jp.sourceforge.akjrcp.ui.draw2d.SimpleGraphMemoryPainterDraw2D;
import jp.sourceforge.akjrcp.ui.draw2d.WaveFormFigure;
import jp.sourceforge.akjrcp.ui.draw2d.WaveFormListener;
import jp.sourceforge.akjrcp.ui.draw2d.Zoom;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.jpn.xucker.commons.audio.WaveFormUtils;
import org.jpn.xucker.commons.audio.WaveUtils;

public class WaveFormFigureCanvas
extends Canvas {
    public static Log log = LogFactory.getLog(WaveFormFigureCanvas.class);
    public static final int NORMAL = 0;
    private int mode = 0;
    private double hzoom = 1.0;
    private double vzoom = 0.5;
    private LocationFigure locationFigure;
    private EmptyFigure rootFigure;
    private WaveFormFigure waveFormFigure;
    private ChainedFlowFigure flowFigure;
    private AlphaLayerFigure selectionFigure;
    private AlphaLayerFigure selectionRectangleFigure;
    private Rectangle selectRectangle;
    private long selectionStart;
    private long selectionEnd;
    private long current;
    private LightweightSystem lws;
    private DefaultZoom zoom = new DefaultZoom();
    private WaveFormListener waveFormListener;
    private int autoScrollMargin = 30;
    double splitframe = 0.01;
    Shell shell;
    private int baseMemoryPixel = 100;
    private int perFigure = 2048;
    private DoubleScalableFigure resisableFigure;
    private int waveFormHeight = 256;
    private int panelHeight;
    private long maxAudioTime;
    private int sampleRate;
    public double[] zoomValues = new double[]{0.0078125, 0.015625, 0.03125, 0.0625, 0.125, 0.25, 0.5, 1.0, 2.0, 4.0};
    public int zoomDefaultSelection = 5;
    private WaveFormUtils.Canceller canceller;
    private Drugging drugging;
    private TimeSelectionListener timeSelectionListener;
    boolean pressed;
    int mouseDown;
    int mouseUp;
    private Figure backgroundFigure;
    private Figure foregroundFigure;
    private DoubleScalableFigure inPanel;
    private MemoryFigure memoryFigure;
    private int byteLength;
    private MouseDoubleClickListener mouseDoubleClickListener;
    private Menu popUpMenu;

    public Figure getBackgroundFigure() {
        return this.backgroundFigure;
    }

    public void setBackgroundFigure(Figure backgroundFigure) {
        this.backgroundFigure = backgroundFigure;
    }

    public Figure getForegroundFigure() {
        return this.foregroundFigure;
    }

    public void setForegroundFigure(Figure foregroundFigure) {
        this.foregroundFigure = foregroundFigure;
    }

    public WaveFormFigureCanvas(Composite parent) {
        super(parent, 0x100100);
        this.shell = this.getShell();
        this.zoom.setZooms(this.zoomValues);
        this.zoom.setZoomIndex(this.zoomDefaultSelection);
        this.lws = new LightweightSystem((Canvas)this);
        this.getHorizontalBar().addSelectionListener((SelectionListener)new ScrollHorizontalMove());
        this.getHorizontalBar().setIncrement(100);
        this.rootFigure = new EmptyFigure();
        this.lws.setContents((IFigure)this.rootFigure);
        this.backgroundFigure = new EmptyFigure();
        this.rootFigure.add((IFigure)this.backgroundFigure);
        this.inPanel = new DoubleScalableFigure(1, 1);
        this.inPanel.setLayoutManager(null);
        this.resisableFigure = new DoubleScalableFigure(1, 1);
        this.resisableFigure.setLayoutManager((LayoutManager)new StackLayout());
        this.inPanel.add(this.resisableFigure);
        this.rootFigure.add(this.inPanel);
        this.flowFigure = new ChainedFlowFigure();
        this.resisableFigure.add(this.flowFigure);
        this.memoryFigure = new MemoryFigure();
        this.resisableFigure.add((IFigure)this.memoryFigure);
        this.selectionFigure = new SelectionFigure(ColorConstants.gray, 128);
        this.selectionFigure.setVisible(false);
        this.inPanel.add(this.selectionFigure);
        this.selectionRectangleFigure = new SelectionRectangleFigure(ColorConstants.white, 128);
        this.selectionRectangleFigure.setVisible(false);
        this.inPanel.add(this.selectionRectangleFigure);
        this.locationFigure = new LocationFigure();
        this.inPanel.add(this.locationFigure);
        this.foregroundFigure = new EmptyFigure();
        this.foregroundFigure.setVisible(true);
        this.rootFigure.add((IFigure)this.foregroundFigure);
        this.addMouseListener(new CanvasMouse());
        this.addMouseMoveListener(new CanvasMouseMotion());
        this.foregroundFigure.addMouseMotionListener((MouseMotionListener)new FigureMouseMotion());
        this.addControlListener(new ResizeCheck());
        this.foregroundFigure.addMouseListener((MouseListener)new FigureMouse());
        this.popUpMenu = new Menu((Decorations)this.shell, 8);
        this.setMenu(this.popUpMenu);
    }

    public Zoom getZoomControler() {
        return this.zoom;
    }

    public double getZoom() {
        return this.zoom.getZoom();
    }

    public DoubleScalableFigure getInFigure() {
        return this.resisableFigure;
    }

    public void removeWaveForm() {
        this.flowFigure.removeAll();
        this.byteLength = 0;
    }

    public void zoomUp() {
        int cfr_ignored_0 = this.getHorizontalBar().getSelection() / (this.getHorizontalBar().getMaximum() - this.getHorizontalBar().getThumb());
        double currentZoom = this.zoom.getZoom();
        this.zoom.zoomUp();
        if (currentZoom != this.zoom.getZoom()) {
            double value = this.zoom.getZoom();
            log.info((Object)("zoom:" + value));
            this.inPanel.setScale(value, 1.0);
            this.resize();
            int cx = this.getCurrentMouseValue();
            log.trace((Object)("currentV:" + cx + ",half-client=" + this.getClientArea().width / 2 + ",scroll=" + this.getHorizontalBar().getSelection()));
            this.scrollToX(cx - this.getClientArea().width / 2 + this.getHorizontalBar().getSelection());
        }
    }

    public void zoomDown() {
        double bs = this.getHorizontalBar().getSelection() / (this.getHorizontalBar().getMaximum() - this.getHorizontalBar().getThumb());
        double currentZoom = this.zoom.getZoom();
        this.zoom.zoomDown();
        if (currentZoom != this.zoom.getZoom()) {
            double value = this.zoom.getZoom();
            this.inPanel.setScale(value, 1.0);
            this.resize();
            this.getHorizontalBar().getMaximum();
            this.getHorizontalBar().getThumb();
            if (this.getClientArea().width > this.getWaveFormSize()) {
                log.info((Object)("disable-scrollbar:client-size=" + this.getClientArea().width + ",waveformsize=" + this.getWaveFormSize() + ",zoom=" + this.zoom.getZoom() + ",bytelength=" + this.byteLength + ",currentzoom=" + currentZoom));
                this.getHorizontalBar().setEnabled(false);
                this.scrollToX(0);
            } else {
                int cx = this.getCurrentMouseValue();
                log.info((Object)("currentV:" + cx + ",half-client=" + this.getClientArea().width / 2 + ",scroll=" + this.getHorizontalBar().getSelection()));
                this.scrollToX(cx - this.getClientArea().width / 2 + this.getHorizontalBar().getSelection());
            }
        }
    }

    public void rescrollbar() {
        int waveFormSize = this.getWaveFormSize();
        log.trace((Object)("client:" + this.getClientArea()));
        log.trace((Object)("before-horizontalbar:" + this.getHorizontalBar().getMaximum() + "," + this.getHorizontalBar().getThumb()));
        if (this.getClientArea().width > waveFormSize) {
            this.getHorizontalBar().setEnabled(false);
            this.scrollToX(0);
        } else {
            this.getHorizontalBar().setMaximum(waveFormSize);
            this.getHorizontalBar().setThumb(this.getClientArea().width);
            this.getHorizontalBar().setEnabled(true);
        }
        log.trace((Object)("after-horizontalbar:" + this.getHorizontalBar().getMaximum() + "," + this.getHorizontalBar().getThumb()));
    }

    public void moveCurrentPosition(long tx) {
        this.setCurrentRealValue(tx);
        int x = this.getCurrentMouseValue() - this.inPanel.getBounds().x - this.getHorizontalBar().getSelection();
        if (x > this.getClientArea().width - this.autoScrollMargin) {
            log.info((Object)("auto-x:tx=" + tx + ",x=" + x + ",inPanel.x=" + this.inPanel.getBounds().x + ",client-width=" + this.getClientArea().width + ",scroll=" + this.getHorizontalBar().getSelection()));
            this.autoScroll(2);
        } else if (x < this.autoScrollMargin) {
            this.autoScroll(-2);
        } else {
            log.trace((Object)"no scroll");
        }
    }

    public long getCurrentRealValue() {
        return this.current;
    }

    public int getCurrentMouseValue() {
        return this.realToCanvasValue(this.current);
    }

    public int getLastPosition() {
        int margin = 5;
        log.info((Object)("lastPosition:bytelength:" + this.byteLength + ",baseMemorypixel=" + this.baseMemoryPixel + ",splitframe" + this.splitframe + ",margin" + margin));
        return (int)((double)this.byteLength * (1000.0 * this.splitframe)) + margin;
    }

    public int getXByte(int x) {
        if (x < 0) {
            return 0;
        }
        int figureIndex = x / 256;
        int at = x % 256;
        at = Math.max(0, at);
        if (figureIndex >= this.flowFigure.getChildren().size()) {
            return 0;
        }
        WaveFormFigure figure = (WaveFormFigure)this.flowFigure.getChildren().get(figureIndex);
        if (figure != null && at < figure.getLength()) {
            return figure.getByteAt(at);
        }
        return 0;
    }

    public void loadEmpty(long durationMillisecond) {
        log.info((Object)("ms:" + WaveUtils.toMillisecondLabel((long)durationMillisecond)));
        List byteList = WaveFormUtils.toWavEmptyValue((double)this.splitframe, (long)durationMillisecond, (int)this.perFigure);
        log.info((Object)("listSize:" + byteList.size()));
        this.setByteData(byteList);
    }

    public List loadByteList(AudioInputStream input) {
        this.canceller = new WaveFormUtils.Canceller();
        List byteList = WaveFormUtils.toWavValue((double)this.splitframe, (AudioInputStream)input, (int)this.perFigure, (WaveFormUtils.Canceller)this.canceller);
        log.trace((Object)("listSize:" + byteList.size()));
        return byteList;
    }

    public void loadWave(AudioInputStream input) {
        this.setByteData(this.loadByteList(input));
    }

    public Figure getFlowFigure() {
        return this.flowFigure;
    }

    public void removeAll() {
        this.flowFigure.removeAll();
    }

    public void setByteData(List byteList) {
        this.flowFigure.removeAll();
        log.trace((Object)"removeAll");
        this.byteLength = 0;
        int i = 0;
        while (i < byteList.size()) {
            byte[] bt = (byte[])byteList.get(i);
            WaveFormFigure wf = new WaveFormFigure(bt, this.waveFormHeight);
            this.flowFigure.addChainedFigure(wf);
            wf.setForegroundColor(ColorConstants.orange);
            this.byteLength += bt.length;
            ++i;
        }
        log.warn((Object)("bt-length:" + this.byteLength));
        this.resize();
    }

    public void loadWave(File file) {
        log.trace((Object)("open:" + file));
        try {
            AudioFileFormat format = AudioSystem.getAudioFileFormat(file);
            this.maxAudioTime = (long)((float)format.getFrameLength() / format.getFormat().getSampleRate() * 1000.0f);
            this.setSampleRate((int)format.getFormat().getSampleRate());
            this.loadWave(AudioSystem.getAudioInputStream(file));
        }
        catch (FileNotFoundException e) {
            log.warn((Object)e);
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getWaveFormSize() {
        return (int)((double)this.byteLength * this.zoom.getZoom());
    }

    public int toPanelHeight() {
        if (this.panelHeight > 0) {
            return this.panelHeight;
        }
        return this.getClientArea().height;
    }

    public void resize() {
        int waveFormSize = this.getWaveFormSize();
        this.inPanel.setSize(waveFormSize, this.toPanelHeight());
        this.locationFigure.setSize(this.locationFigure.getSize().width, this.toPanelHeight());
        this.resisableFigure.setSize(waveFormSize, this.toPanelHeight());
        this.flowFigure.setScale(this.zoom.getZoom(), 1.0);
        log.info((Object)("zoom:" + this.zoom.getZoom()));
        log.info((Object)("waveFormSize:" + waveFormSize));
        this.inPanel.revalidate();
        log.info((Object)("panelSize:" + this.inPanel.getClientArea()));
        this.backgroundFigure.setBounds(new Rectangle(this.getClientArea()));
        this.foregroundFigure.setBounds(new Rectangle(this.getClientArea()));
        this.rescrollbar();
        this.rootFigure.revalidate();
        log.info((Object)("root:" + this.rootFigure.getClientArea()));
    }

    public void scrollToX(int tx) {
        int x = Math.max(tx, 0);
        x = Math.min(x, this.getHorizontalBar().getMaximum() - this.getHorizontalBar().getThumb());
        this.getHorizontalBar().setSelection(x);
        log.info((Object)("scrollToX:" + x + ",size" + this.getHorizontalBar().getMaximum() + ",thumb=" + this.getHorizontalBar().getThumb()));
        this.inPanel.setLocation(new Point(-x, 0));
        log.trace((Object)("location:" + this.locationFigure.getClientArea()));
        log.info((Object)("bound:" + this.inPanel.getBounds()));
    }

    public void autoScroll(int duration) {
        log.info((Object)("autoScroll:" + duration));
        int v = this.getHorizontalBar().getIncrement();
        if (this.zoom.getZoom() == 1.0) {
            v *= 2;
        } else if (this.zoom.getZoom() > 1.0) {
            v = (int)((double)v * (2.0 * this.zoom.getZoom()));
        }
        log.info((Object)(String.valueOf(this.zoom.getZoom()) + "," + v));
        this.scrollToX(this.getHorizontalBar().getSelection() + v * duration);
    }

    public void updateSelect() {
        int p1 = this.mouseUp;
        int p2 = this.mouseDown;
        if (this.mouseUp > this.mouseDown) {
            p1 = this.mouseDown;
            p2 = this.mouseUp;
        }
        if (p2 > p1 + 1) {
            this.select(p1, p2);
        } else {
            this.unselect();
        }
    }

    private void unselect() {
        this.selectionFigure.setVisible(false);
        if (this.timeSelectionListener != null) {
            this.timeSelectionListener.timeSelectionChanged(new TimeSelection(0L, 0L));
        }
    }

    private void select(int p1, int p2) {
        this.setSelectMouseValue(p1, p2);
        log.trace((Object)("select:" + this.selectionFigure.getClientArea()));
    }

    public TimeSelection getSelection() {
        if (this.selectionFigure.isVisible()) {
            log.info((Object)("selectionFigure:" + this.selectionFigure.getClientArea()));
            return new TimeSelection(this.selectionStart, this.selectionEnd);
        }
        return null;
    }

    public void setSelectMouseValue(int start, int end) {
        this.selectionStart = this.canvasToRealValue(start);
        this.selectionEnd = this.canvasToRealValue(end);
        this.selectionFigure.setLocation(new Point(start, 0));
        this.selectionFigure.setSize(end - start, this.toPanelHeight());
        this.selectionFigure.setVisible(true);
        if (this.timeSelectionListener != null) {
            this.timeSelectionListener.timeSelectionChanged(new TimeSelection(this.selectionStart, this.selectionEnd));
        }
    }

    public void setSelectRealValue(long start, long end) {
        this.selectionStart = start;
        this.selectionEnd = end;
        int ms = this.realToCanvasValue(start);
        int me = this.realToCanvasValue(end);
        this.selectionFigure.setLocation(new Point(ms, 0));
        this.selectionFigure.setSize(me - ms, this.toPanelHeight());
        this.selectionFigure.setVisible(true);
    }

    public Rectangle setRectangleRealValue() {
        if (this.selectRectangle != null) {
            return this.selectionRectangleFigure.getBounds();
        }
        return null;
    }

    public void setRectangleRealValue(Rectangle rectangle) {
        if (rectangle != null) {
            this.selectRectangle = rectangle;
            int dx = this.realToCanvasValue(rectangle.x);
            int dwidth = this.realToCanvasValue(rectangle.x + rectangle.width);
            this.selectionRectangleFigure.setLocation(new Point(dx, rectangle.y));
            this.selectionRectangleFigure.setSize(dwidth - dx, rectangle.height);
            this.selectionRectangleFigure.setVisible(true);
        } else {
            this.selectionRectangleFigure.setVisible(false);
        }
    }

    public void setCurrentRealValue(long value) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("value:" + value));
            log.trace((Object)("zoom:" + this.zoom.getZoom()));
            log.trace((Object)("bound:" + this.inPanel.getBounds().x));
            log.trace((Object)("location:" + ((int)((double)value * this.zoom.getZoom()) + this.inPanel.getBounds().x)));
        }
        this.current = value;
        this.locationFigure.move(this.realToCanvasValue(value));
    }

    public void setCurrentMouseValue(int value) {
        this.current = this.canvasToRealValue(value);
        this.locationFigure.move(value);
        log.info((Object)("current-time:" + this.current));
        log.trace((Object)("location:" + this.locationFigure.getClientArea()));
    }

    public int realToCanvasValue(long value) {
        int x = (int)((double)value * this.zoom.getZoom() / (1000.0 * this.splitframe)) + this.inPanel.getBounds().x;
        log.info((Object)("value=" + value + ",x=" + x));
        return x;
    }

    public long canvasToRealValue(int value) {
        long ms = (int)((double)(value - this.inPanel.getBounds().x) / this.zoom.getZoom() * (1000.0 * this.splitframe));
        if (ms < 0L) {
            ms = 0L;
        }
        if (ms > this.maxAudioTime) {
            ms = this.maxAudioTime;
        }
        return ms;
    }

    public WaveFormListener getWaveFormListener() {
        return this.waveFormListener;
    }

    public void setWaveFormListener(WaveFormListener waveFormListener) {
        this.waveFormListener = waveFormListener;
    }

    public double getSplitFrame() {
        return this.splitframe;
    }

    public void setSplitFrame(double splitframe) {
        this.splitframe = splitframe;
    }

    public int getBaseMemoryPixel() {
        return this.baseMemoryPixel;
    }

    public void setBaseMemoryPixel(int baseMemoryPixel) {
        this.baseMemoryPixel = baseMemoryPixel;
    }

    public WaveFormUtils.Canceller getCanceller() {
        return this.canceller;
    }

    public MouseDoubleClickListener getMouseDoubleClickListener() {
        return this.mouseDoubleClickListener;
    }

    public void setMouseDoubleClickListener(MouseDoubleClickListener mouseDoubleClickListener) {
        this.mouseDoubleClickListener = mouseDoubleClickListener;
    }

    public TimeSelectionListener getTimeSelectionListener() {
        return this.timeSelectionListener;
    }

    public void setTimeSelectionListener(TimeSelectionListener timeSelectionListener) {
        this.timeSelectionListener = timeSelectionListener;
    }

    public void selectAll() {
        this.setSelectRealValue(0L, this.maxAudioTime);
        if (this.timeSelectionListener != null) {
            this.timeSelectionListener.timeSelectionChanged(this.getSelection());
        }
    }

    public Menu getPopUpMenu() {
        return this.popUpMenu;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public class SelectionFigure
    extends AlphaLayerFigure {
        public SelectionFigure(Color color, int alpha) {
            super(color, alpha);
        }

        public void setScale(double w, double h) {
            if (WaveFormFigureCanvas.this.selectionFigure.isVisible()) {
                WaveFormFigureCanvas.this.setSelectRealValue(WaveFormFigureCanvas.this.selectionStart, WaveFormFigureCanvas.this.selectionEnd);
            }
        }
    }

    public class SelectionRectangleFigure
    extends AlphaLayerFigure {
        public SelectionRectangleFigure(Color color, int alpha) {
            super(color, alpha);
        }

        public void setScale(double w, double h) {
            if (WaveFormFigureCanvas.this.selectionFigure.isVisible()) {
                WaveFormFigureCanvas.this.setRectangleRealValue(WaveFormFigureCanvas.this.selectRectangle);
            }
        }
    }

    public class ScrollHorizontalMove
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            WaveFormFigureCanvas.this.scrollToX(WaveFormFigureCanvas.this.getHorizontalBar().getSelection());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class ResizeCheck
    implements ControlListener {
        public void controlMoved(ControlEvent e) {
            log.trace((Object)"moved");
        }

        public void controlResized(ControlEvent e) {
            log.info((Object)("client:" + WaveFormFigureCanvas.this.getClientArea()));
            WaveFormFigureCanvas.this.backgroundFigure.setBounds(new Rectangle(WaveFormFigureCanvas.this.getClientArea()));
            WaveFormFigureCanvas.this.foregroundFigure.setBounds(new Rectangle(WaveFormFigureCanvas.this.getClientArea()));
            WaveFormFigureCanvas.this.rescrollbar();
        }
    }

    public class LocationFigure
    extends DoubleScalableFigure {
        int markSize;
        int value;
        int height;

        public LocationFigure() {
            super(1, 1);
            this.markSize = 2;
            this.value = 128;
            this.height = 256;
            this.setSize(1 + this.markSize * 2, WaveFormFigureCanvas.this.toPanelHeight());
            this.setForegroundColor(ColorConstants.gray);
            this.setBackgroundColor(ColorConstants.gray);
        }

        public void setScale(double w, double h) {
            this.wzoom = w;
            WaveFormFigureCanvas.this.setCurrentRealValue(WaveFormFigureCanvas.this.current);
        }

        public int getCurrent() {
            return this.getLocation().x + this.markSize;
        }

        public void move(int location) {
            if (WaveFormFigureCanvas.this.waveFormListener != null) {
                WaveFormFigureCanvas.this.waveFormListener.changeCurrent((int)(WaveFormFigureCanvas.this.current * 1000L / (long)WaveFormFigureCanvas.this.baseMemoryPixel));
            }
            this.setLocation(new Point(location - this.markSize, 0));
            this.setValue(WaveFormFigureCanvas.this.getXByte(location));
        }

        public void paintFigure(Graphics g) {
            g.drawLine(this.markSize + this.getClientArea().x, this.getClientArea().y, this.markSize + this.getClientArea().x, this.getClientArea().height);
        }

        public void setValue(int v) {
            this.value = this.height / 2 + v;
        }
    }

    public class CallScroll
    implements Runnable {
        int duration;

        public CallScroll(int duration) {
            this.duration = duration;
        }

        public void run() {
            WaveFormFigureCanvas.this.autoScroll(this.duration);
            WaveFormFigureCanvas.this.mouseUp += this.duration * WaveFormFigureCanvas.this.getHorizontalBar().getIncrement();
            WaveFormFigureCanvas.this.mouseUp = Math.max(0, WaveFormFigureCanvas.this.mouseUp);
            WaveFormFigureCanvas.this.updateSelect();
            WaveFormFigureCanvas.this.setCurrentMouseValue(WaveFormFigureCanvas.this.mouseUp);
        }
    }

    public class Drugging
    implements Runnable {
        private boolean stopped;
        private int duration;

        public Drugging(int duration) {
            this.duration = duration;
        }

        public void setStopped(boolean bool) {
            this.stopped = bool;
        }

        public void run() {
            while (WaveFormFigureCanvas.this.pressed && !this.stopped) {
                log.trace((Object)("drugging:" + this.duration));
                WaveFormFigureCanvas.this.shell.getDisplay().syncExec((Runnable)new CallScroll(this.duration));
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            log.trace((Object)"druggin-finish");
        }
    }

    public class CanvasMouseMotion
    implements MouseMoveListener {
        public void mouseMove(org.eclipse.swt.events.MouseEvent e) {
            int maxwidth = ((WaveFormFigureCanvas)WaveFormFigureCanvas.this).resisableFigure.getBounds().x + ((WaveFormFigureCanvas)WaveFormFigureCanvas.this).resisableFigure.getBounds().width;
            if (e.x < maxwidth && e.x > 0) {
                return;
            }
            if (e.stateMask == 524288) {
                log.info((Object)"canvas-mosue-dragged");
                if (WaveFormFigureCanvas.this.drugging != null) {
                    WaveFormFigureCanvas.this.drugging.setStopped(true);
                }
                WaveFormFigureCanvas.this.mouseUp = e.x;
                log.info((Object)("mosue-up:" + WaveFormFigureCanvas.this.mouseUp));
                if (WaveFormFigureCanvas.this.mode == 0) {
                    WaveFormFigureCanvas.this.setCurrentMouseValue(e.x);
                }
                WaveFormFigureCanvas.this.updateSelect();
                if (WaveFormFigureCanvas.this.getHorizontalBar().isEnabled()) {
                    if (WaveFormFigureCanvas.this.mouseUp > WaveFormFigureCanvas.this.mouseDown && e.x > WaveFormFigureCanvas.this.getClientArea().width - WaveFormFigureCanvas.this.autoScrollMargin) {
                        WaveFormFigureCanvas.this.drugging = new Drugging(1);
                        Thread t = new Thread(WaveFormFigureCanvas.this.drugging);
                        t.start();
                    } else if (WaveFormFigureCanvas.this.mouseUp < WaveFormFigureCanvas.this.mouseDown && e.x < WaveFormFigureCanvas.this.autoScrollMargin) {
                        WaveFormFigureCanvas.this.drugging = new Drugging(-1);
                        Thread t = new Thread(WaveFormFigureCanvas.this.drugging);
                        t.start();
                    }
                }
            }
        }
    }

    public class FigureMouseMotion
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent e) {
            log.trace((Object)"figure-mouse-dragged");
            if (WaveFormFigureCanvas.this.drugging != null) {
                WaveFormFigureCanvas.this.drugging.setStopped(true);
            }
            if (!WaveFormFigureCanvas.this.pressed) {
                log.info((Object)"maybe wrong select");
                return;
            }
            WaveFormFigureCanvas.this.mouseUp = e.x;
            if (WaveFormFigureCanvas.this.mode == 0) {
                WaveFormFigureCanvas.this.setCurrentMouseValue(e.x);
            }
            WaveFormFigureCanvas.this.updateSelect();
            if (WaveFormFigureCanvas.this.getHorizontalBar().isEnabled()) {
                if (WaveFormFigureCanvas.this.mouseUp > WaveFormFigureCanvas.this.mouseDown && e.x > WaveFormFigureCanvas.this.getClientArea().width - WaveFormFigureCanvas.this.autoScrollMargin) {
                    WaveFormFigureCanvas.this.drugging = new Drugging(1);
                    Thread t = new Thread(WaveFormFigureCanvas.this.drugging);
                    t.start();
                } else if (WaveFormFigureCanvas.this.mouseUp < WaveFormFigureCanvas.this.mouseDown && e.x < WaveFormFigureCanvas.this.autoScrollMargin) {
                    WaveFormFigureCanvas.this.drugging = new Drugging(-1);
                    Thread t = new Thread(WaveFormFigureCanvas.this.drugging);
                    t.start();
                }
            }
        }

        public void mouseEntered(MouseEvent me) {
        }

        public void mouseExited(MouseEvent me) {
        }

        public void mouseHover(MouseEvent me) {
        }

        public void mouseMoved(MouseEvent me) {
        }
    }

    public static interface TimeSelectionListener {
        public void timeSelectionChanged(TimeSelection var1);
    }

    public static class TimeSelection {
        private long start;
        private long end;

        public long getEnd() {
            return this.end;
        }

        public void setEnd(long end) {
            this.end = end;
        }

        public long getStart() {
            return this.start;
        }

        public void setStart(long start) {
            this.start = start;
        }

        public TimeSelection(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public boolean equals(Object object) {
            if (object instanceof TimeSelection) {
                TimeSelection ts = (TimeSelection)object;
                return ts.getStart() == this.getStart() && ts.getEnd() == this.getEnd();
            }
            return false;
        }
    }

    public static class EmptyFigure
    extends Figure {
        public void paintFigure(Graphics g) {
        }
    }

    public class MemoryFigure
    extends Figure {
        private SimpleGraphMemoryPainterDraw2D painter = new SimpleGraphMemoryPainterDraw2D();

        public MemoryFigure() {
            this.painter.setVerticalGraph(false);
            this.painter.setGraphPlus(true);
            this.painter.setGridPlus(true);
            this.painter.setLabelProvider(new LabelProvider());
            this.painter.setLineColor(ColorConstants.darkGray);
        }

        public void paintFigure(Graphics g) {
            log.trace((Object)("memoryfigure:" + g.getClip(this.getClientArea())));
            this.painter.draw(g, this.getClientArea().x, this.getClientArea().y, ((WaveFormFigureCanvas)WaveFormFigureCanvas.this).flowFigure.getSize().width);
        }

        public SimpleGraphMemoryPainterDraw2D getPainter() {
            return this.painter;
        }

        public void setPainter(SimpleGraphMemoryPainterDraw2D painter) {
            this.painter = painter;
        }
    }

    public class LabelProvider
    implements GraphLabelProvider {
        private int digit = 6;

        public String getLabel(SimpleGraphMemoryPainterDraw2D painter, int index) {
            double ms = (double)index / WaveFormFigureCanvas.this.zoom.getZoom() * WaveFormFigureCanvas.this.memoryFigure.getPainter().getPerMain() * WaveFormFigureCanvas.this.splitframe;
            BigDecimal bd = new BigDecimal(ms);
            double v = bd.setScale(this.digit, 4).doubleValue();
            return "" + v;
        }
    }

    public class FigureMouse
    implements MouseListener {
        public void mousePressed(MouseEvent me) {
            if (me.button != 1) {
                return;
            }
            log.trace((Object)"figure-mouse-press");
            WaveFormFigureCanvas.this.setCurrentMouseValue(me.x);
            WaveFormFigureCanvas.this.mouseDown = me.x;
            WaveFormFigureCanvas.this.pressed = true;
        }

        public void mouseReleased(MouseEvent me) {
            if (me.button != 1) {
                return;
            }
            log.trace((Object)"figure-mouse-release");
            if (WaveFormFigureCanvas.this.pressed) {
                WaveFormFigureCanvas.this.mouseUp = me.x;
                WaveFormFigureCanvas.this.updateSelect();
            }
            WaveFormFigureCanvas.this.pressed = false;
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }
    }

    public static interface MouseDoubleClickListener {
        public void mouseDoubleClicked(long var1);
    }

    public class CanvasMouse
    implements org.eclipse.swt.events.MouseListener {
        public void mouseDoubleClick(org.eclipse.swt.events.MouseEvent e) {
            long ms = WaveFormFigureCanvas.this.canvasToRealValue(e.x);
            if (WaveFormFigureCanvas.this.mouseDoubleClickListener != null) {
                WaveFormFigureCanvas.this.mouseDoubleClickListener.mouseDoubleClicked(ms);
            }
        }

        public void mouseDown(org.eclipse.swt.events.MouseEvent e) {
            log.trace((Object)"canvas-mouse-release");
            int maxwidth = ((WaveFormFigureCanvas)WaveFormFigureCanvas.this).resisableFigure.getBounds().x + ((WaveFormFigureCanvas)WaveFormFigureCanvas.this).resisableFigure.getBounds().width;
            if (e.x > maxwidth) {
                WaveFormFigureCanvas.this.setCurrentMouseValue(maxwidth);
                WaveFormFigureCanvas.this.mouseDown = maxwidth;
                WaveFormFigureCanvas.this.pressed = true;
            }
        }

        public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
            log.trace((Object)"canvas-mouse-release");
            WaveFormFigureCanvas.this.pressed = false;
        }
    }
}

