/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.akjrcp.ui.GenericParametersFFMpegPreference;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericParameters {
    public static Log log = LogFactory.getLog(GenericParameters.class);
    private Map<String, String> parameters = new HashMap<String, String>();
    public static String PARAM_NAME = "#name";
    public static String PARAM_COMMENT = "#comment";
    protected String[] singleParams = new String[]{"vn", "an", "sameq", "deinterlace"};
    protected String[] customParams = GenericParametersFFMpegPreference.SYSTEM_KEYS;

    public GenericParameters() {
    }

    public GenericParameters(Map<String, String> parameters) {
        this();
        this.setParameters(parameters);
    }

    public boolean isSingleParam(String key) {
        int i = 0;
        while (i < this.singleParams.length) {
            if (key.equals(this.singleParams[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void set(String key, String value) {
        if (GenericParameters.isCSVHeaderKey(key)) {
            this.parseHeaderCSV(key, value);
        } else {
            this.parameters.put(key, value);
        }
    }

    public static String getCSVHeaderParamRemovedLine(String csv) {
        String[] values = csv.split(",");
        String ret = "";
        int i = 0;
        while (i < values.length) {
            if (!GenericParameters.isCSVHeaderKey(values[i])) {
                ret = String.valueOf(ret) + values[i];
                if (i != values.length - 1) {
                    ret = String.valueOf(ret) + ",";
                }
            }
            ++i;
        }
        return ret;
    }

    private boolean isCustomKey(String key) {
        int i = 0;
        while (i < this.customParams.length) {
            if (key.equals(this.customParams[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] toArgParams() {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : this.parameters.keySet()) {
            if (GenericParameters.isCSVHeaderKey(key) || this.isCustomKey(key)) continue;
            String value = this.parameters.get(key);
            if (this.isSingleParam(key)) {
                if (!value.equals("1")) continue;
                list.add("-" + key);
                continue;
            }
            this.addList(list, key, value);
        }
        return list.toArray(new String[list.size()]);
    }

    private void addList(List<String> list, String key, String value) {
        list.add("-" + key);
        list.add(value);
    }

    public static GenericParameters csvToParameters(String csv) {
        csv = StringUtils.replace((String)csv, (String)"\n", (String)"");
        csv = StringUtils.replace((String)csv, (String)"\r", (String)"");
        GenericParameters parameters = new GenericParameters();
        String[] name_value = csv.split(",");
        int i = 0;
        while (i < name_value.length) {
            if (name_value[0].length() > 0) {
                String[] n_v = name_value[i].split("=");
                if (n_v.length > 1) {
                    parameters.set(n_v[0], n_v[1]);
                } else if (GenericParameters.isCSVHeaderKey(n_v[0])) {
                    parameters.set(n_v[0], "");
                } else {
                    parameters.set(n_v[0], "1");
                }
            }
            ++i;
        }
        return parameters;
    }

    public static String parametersToCsv(GenericParameters parameters) {
        String separator = ",";
        StringBuffer buffer = new StringBuffer();
        buffer.append(parameters.toHeaderCSV());
        buffer.append(separator);
        Map<String, String> map = parameters.getParameters();
        for (String key : map.keySet()) {
            if (key.equals(PARAM_NAME) || key.equals(PARAM_COMMENT)) continue;
            String value = map.get(key);
            buffer.append(String.valueOf(key) + "=" + value);
            buffer.append(separator);
        }
        String v = buffer.toString();
        return v.substring(0, v.length() - 1);
    }

    public static String mapToCsv(Map<String, String> map) {
        String separator = ",";
        StringBuffer buffer = new StringBuffer();
        for (String key : map.keySet()) {
            if (key.equals(PARAM_NAME) || key.equals(PARAM_COMMENT)) continue;
            String value = map.get(key);
            buffer.append(String.valueOf(key) + "=" + value);
            buffer.append(separator);
        }
        String v = buffer.toString();
        return v.substring(0, Math.max(0, v.length() - 1));
    }

    private String toHeaderCSV() {
        String separator = ",";
        String v = "";
        v = String.valueOf(v) + PARAM_NAME + "=" + this.storeCharacters(this.getName()) + separator;
        v = String.valueOf(v) + PARAM_COMMENT + "=" + this.storeCharacters(this.getComment());
        return v;
    }

    private void parseHeaderCSV(String key, String value) {
        if (GenericParameters.isCSVHeaderKey(key)) {
            String v = this.restoreCharacters(value);
            if (key.equals(PARAM_NAME)) {
                this.setName(v);
            } else if (key.equals(PARAM_COMMENT)) {
                this.setComment(v);
            }
        }
    }

    private String restoreCharacters(String value) {
        String v = StringUtils.replace((String)value, (String)"\\n", (String)"\n");
        v = StringUtils.replace((String)v, (String)"%2C", (String)",");
        return v;
    }

    private String storeCharacters(String value) {
        String v = StringUtils.replace((String)value, (String)"\n", (String)"\\n");
        v = StringUtils.replace((String)v, (String)"\r", (String)"");
        v = StringUtils.replace((String)v, (String)",", (String)"%2C");
        return v;
    }

    private static boolean isCSVHeaderKey(String key) {
        return key.startsWith("#");
    }

    public String getComment() {
        String value = this.parameters.get(PARAM_COMMENT);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void setComment(String comment) {
        this.parameters.put(PARAM_COMMENT, comment);
    }

    public String getName() {
        String value = this.parameters.get(PARAM_NAME);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void setName(String name) {
        this.parameters.put(PARAM_NAME, name);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }
}

