/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.textinsert;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.dropsomething.DirectoryBasedDropSomething;
import jp.sourceforge.akjrcp.dropsomething.IDropSomething;
import jp.sourceforge.akjrcp.textinsert.TextInsertInputStream;
import jp.sourceforge.akjrcp.ui.FileDirChoicer;
import jp.sourceforge.akjrcp.ui.FileOverwriteControler;
import jp.sourceforge.akjrcp.util.PathnameUtils;
import jp.sourceforge.akjrcp.util.StatusBarUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class TextInsertTabBuilder
implements IDropSomething {
    public static Log log = LogFactory.getLog(TextInsertTabBuilder.class);

    public void createTab(ViewPart part, CTabFolder tab) {
        CTabItem tabItem1 = new CTabItem(tab, 0);
        tabItem1.setText(Messages.getString("dropandsomething.textinsert"));
        TextInsertTab dtab = new TextInsertTab((Composite)tab, 0);
        dtab.setViewPart(part);
        tabItem1.setControl((Control)dtab);
    }

    public class TextInsertTab
    extends DirectoryBasedDropSomething {
        private Button ignore;
        private Button before;
        private Button after;
        private Button replace;
        private Text insertText;
        private Text targetText;
        private TextInsertSetting setting;
        private Label dragHere;
        private String[] extensions;
        private CCombo charcode;
        private FileOverwriteControler overwriteControl;
        private Button keeptime;

        public TextInsertTab(Composite parent, int style) {
            super(parent, style);
            this.extensions = new String[]{"htm", "html", "shtml", "txt"};
        }

        public Composite createControls(Composite parent) {
            log.trace((Object)"createControl");
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, true));
            Composite targetComposite = new Composite(composite, 0);
            targetComposite.setLayoutData((Object)new GridData(768));
            targetComposite.setLayout((Layout)new GridLayout(3, false));
            Label label = new Label(targetComposite, 0);
            label.setText(Messages.getString("textinsert.target"));
            this.ignore = new Button(targetComposite, 32);
            this.ignore.setSelection(true);
            this.ignore.setText(Messages.getString("textinsert.ignore"));
            this.targetText = new Text(targetComposite, 4);
            this.targetText.setLayoutData((Object)new GridData(768));
            this.targetText.setText("</body>");
            Composite beforeafter = new Composite(composite, 0);
            beforeafter.setLayout((Layout)new GridLayout(3, true));
            this.before = new Button(beforeafter, 16);
            this.before.setSelection(true);
            this.before.setText(Messages.getString("textinsert.before"));
            this.after = new Button(beforeafter, 16);
            this.after.setText(Messages.getString("textinsert.after"));
            this.replace = new Button(beforeafter, 16);
            this.replace.setText(Messages.getString("textinsert.replace"));
            this.createDirectoryInfo(composite);
            Label inserttextLabel = new Label(composite, 0);
            inserttextLabel.setText(Messages.getString("textinsert.inserttext"));
            this.insertText = new Text(composite, 2);
            this.insertText.setLayoutData((Object)new GridData(1808));
            this.insertText.setText("<!--put your code-->");
            Composite textandchar = new Composite(composite, 0);
            textandchar.setLayout((Layout)new GridLayout(3, false));
            Label charcodelabel = new Label(textandchar, 0);
            charcodelabel.setText(Messages.getString("textinsert.charcode"));
            this.charcode = new CCombo(textandchar, 0);
            this.charcode.add("SJIS");
            this.charcode.add("iso-8859-1");
            this.charcode.add("MS932");
            this.charcode.add("EUC-JP");
            this.charcode.add("JIS");
            this.charcode.add("UTF-8");
            this.charcode.add("UTF-16");
            this.charcode.select(0);
            this.keeptime = new Button(textandchar, 32);
            this.keeptime.setText(Messages.getString("textinsert.keeptime"));
            this.dragHere = new Label(composite, 0);
            GridData data = new GridData(1808);
            this.dragHere.setLayoutData((Object)data);
            this.updateStatus();
            return composite;
        }

        public void setMessage(String text) {
            if (this.dragHere != null) {
                this.dragHere.setForeground(new Color((Device)Display.getCurrent(), 64, 255, 64));
                this.dragHere.setText(text);
            }
        }

        public void setErrorMessage(String text) {
            if (this.dragHere != null) {
                this.dragHere.setForeground(new Color(null, 255, 0, 0));
                this.dragHere.setText(text);
            }
        }

        private void insertText(File input, File output) {
            boolean equalsPath = input.equals(output);
            File tmpOutput = null;
            if (equalsPath) {
                if (!output.canWrite()) {
                    log.info((Object)"read only file");
                    this.printConsole(output, false);
                    return;
                }
                log.info((Object)("same file:" + input));
                if (!this.setting.isBackup()) {
                    FileOverwriteControler.AskOverwrite ask = new FileOverwriteControler.AskOverwrite(this.overwriteControl, output);
                    PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)ask);
                    if (!ask.isOverwrite()) {
                        log.info((Object)"don't over write");
                        return;
                    }
                }
                try {
                    log.info((Object)"make tmp");
                    tmpOutput = File.createTempFile("tmpinsert", ".html");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                tmpOutput = output;
            }
            try {
                int b;
                output.getParentFile().mkdirs();
                FileInputStream finput = new FileInputStream(input);
                TextInsertInputStream tinput = new TextInsertInputStream(finput, this.setting.getTargetText(), this.setting.getInsertText(), this.setting.getMode(), this.setting.getCharCode());
                BufferedInputStream binput = new BufferedInputStream(tinput);
                BufferedOutputStream boutput = new BufferedOutputStream(new FileOutputStream(tmpOutput));
                while ((b = binput.read()) != -1) {
                    boutput.write(b);
                }
                boutput.close();
                binput.close();
                if (this.setting.isBackup()) {
                    boolean bk;
                    String outputPath = output.getAbsolutePath();
                    File backupFile = new File(output.getParent(), String.valueOf(output.getName()) + ".bkp");
                    if (backupFile.exists() && !(bk = backupFile.delete())) {
                        log.info((Object)("delete faild:" + backupFile));
                    }
                    boolean result = output.renameTo(backupFile);
                    File newOutput = new File(outputPath);
                    boolean result2 = tmpOutput.renameTo(newOutput);
                    if (this.setting.isKeeptime()) {
                        long time = output.lastModified();
                        tmpOutput.setLastModified(time);
                    }
                    log.info((Object)("make backup:" + result + "," + backupFile));
                    log.info((Object)("make insert:" + result2 + "," + tmpOutput));
                    if (!result2) {
                        tmpOutput.delete();
                    }
                    this.printConsole(newOutput, result2);
                } else {
                    if (this.setting.isKeeptime()) {
                        long time = output.lastModified();
                        tmpOutput.setLastModified(time);
                    }
                    boolean result2 = output.delete();
                    log.info((Object)("make insert:" + result2 + "," + output));
                    boolean result = tmpOutput.renameTo(output);
                    log.info((Object)("make insert:" + result + "," + tmpOutput));
                    if (!result) {
                        tmpOutput.delete();
                    }
                    this.printConsole(output, result);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void printConsole(File file, boolean success) {
            String message = "";
            message = success ? "[success]," + file.getAbsolutePath() + "\n" : "[faild]," + file.getAbsolutePath() + "\n";
            Akj_betasPlugin.getDefault().getProcessPrinter().printOutput(message);
        }

        public void inconvert(File file) {
            if (this.setting.isSameFolder()) {
                this.convert(file, file.getParent(), file.getParent());
            } else {
                this.convert(file, file.getParent(), this.setting.getExportDir());
            }
        }

        private void convert(File file, String baseDir, String exportDir) {
            if (file.isFile()) {
                if (PathnameUtils.isContainExtension(file.getName(), this.extensions)) {
                    String remain = PathnameUtils.getRemainPath(baseDir, file.getAbsolutePath());
                    String newPath = PathnameUtils.createPath(String.valueOf(exportDir) + "\\", remain);
                    this.insertText(file, new File(newPath));
                } else {
                    StatusBarUtils.showStatusBar("not supported file " + file.getName());
                }
            } else {
                String[] lists = file.list();
                if (lists == null) {
                    return;
                }
                int i = 0;
                while (i < lists.length) {
                    this.convert(new File(file, lists[i]), baseDir, exportDir);
                    ++i;
                }
            }
        }

        public void beforeConvert() {
            this.setting = new TextInsertSetting();
            this.setting.setIgnore(this.ignore.getSelection());
            this.setting.setInsertText(this.insertText.getText());
            int mode = 0;
            if (this.after.getSelection()) {
                mode = 1;
            } else if (this.replace.getSelection()) {
                mode = 2;
            }
            this.setting.setMode(mode);
            this.setting.setTargetText(this.targetText.getText());
            this.setting.setExportDir(this.directoryChooser.getAbsoluteFilePath());
            this.setting.setCharCode(this.charcode.getText());
            this.setting.setBackup(this.backup.getSelection());
            this.setting.setSameFolder(this.samefolder.getSelection());
            this.setting.setKeeptime(this.keeptime.getSelection());
        }

        public void afterConvert() {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public boolean setFocus() {
            return false;
        }

        public void updateStatus() {
            if (this.samefolder == null || this.directoryChooser == null) {
                log.warn((Object)"you must createDirectoryInfo(composite); in createControls");
                return;
            }
            if (!this.samefolder.getSelection() && this.directoryChooser.getAbsoluteFilePath().equals("")) {
                this.setErrorMessage(Messages.getString("dropsomething.choose_folder"));
                this.setCanConvert(false);
            } else {
                this.setMessage(Messages.getString("dropsomething.drag_folder"));
                this.setCanConvert(true);
            }
        }

        public void cancelConvert() {
        }

        public IPreferenceStore getPreferenceStore() {
            return Akj_betasPlugin.getDefault().getPreferenceStore();
        }

        public class FolderChoosed
        implements FileDirChoicer.FileStatusChangeListener {
            public void removeList(FileDirChoicer.FileStatusChangeEvent event) {
            }

            public void addList(FileDirChoicer.FileStatusChangeEvent event) {
                TextInsertTab.this.updateStatus();
            }
        }

        public class TextInsertSetting {
            private String insertText;
            private String targetText;
            private int mode;
            private boolean ignore;
            private boolean all;
            private String exportDir;
            private String charCode;
            private boolean backup;
            private int overwritemode;
            private boolean sameFolder;
            private boolean keeptime;

            public boolean isKeeptime() {
                return this.keeptime;
            }

            public void setKeeptime(boolean keeptime) {
                this.keeptime = keeptime;
            }

            public boolean isSameFolder() {
                return this.sameFolder;
            }

            public void setSameFolder(boolean sameFolder) {
                this.sameFolder = sameFolder;
            }

            public String getCharCode() {
                return this.charCode;
            }

            public void setCharCode(String charCode) {
                this.charCode = charCode;
            }

            public boolean isAll() {
                return this.all;
            }

            public void setAll(boolean all) {
                this.all = all;
            }

            public boolean isIgnore() {
                return this.ignore;
            }

            public void setIgnore(boolean ignore) {
                this.ignore = ignore;
            }

            public String getInsertText() {
                return this.insertText;
            }

            public void setInsertText(String insertText) {
                this.insertText = insertText;
            }

            public int getMode() {
                return this.mode;
            }

            public void setMode(int mode) {
                this.mode = mode;
            }

            public String getTargetText() {
                return this.targetText;
            }

            public void setTargetText(String targetText) {
                this.targetText = targetText;
            }

            public String getExportDir() {
                return this.exportDir;
            }

            public void setExportDir(String exportDir) {
                this.exportDir = exportDir;
            }

            public boolean isBackup() {
                return this.backup;
            }

            public void setBackup(boolean backup) {
                this.backup = backup;
            }

            public int getOverwritemode() {
                return this.overwritemode;
            }

            public void setOverwritemode(int overwritemode) {
                this.overwritemode = overwritemode;
            }
        }
    }
}

