/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.snack;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import jp.sourceforge.akjrcp.snack.ESPS;
import jp.sourceforge.akjrcp.subtitle.StandardSubObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PitchToMIDI {
    public static Log log = LogFactory.getLog(PitchToMIDI.class);
    private int instrument = 55;
    private int shiftNote = 12;
    public static String[] names = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};
    private boolean setVelocity = true;
    private int defaultVelocity = 64;
    private boolean pitchNoVoice = true;
    private int volumeMin = 500;
    private boolean ignoreOffset = false;
    private boolean forceInsert = true;
    private int[] scaleFilter = null;
    public static double[] note_pitchs = new double[]{27.5, 29.135235559269688, 30.867706810042687, 32.7031961616527, 34.6478293891135, 36.708096524974316, 38.890873519199936, 41.20344518701423, 43.65352952129351, 46.24930345064996, 48.999430129170484, 51.913087848887784, 55.0, 58.27047088140453, 61.73541336884975, 65.40639205713052, 69.29565849622452, 73.41619275117742, 77.7817467218628, 82.40689003866913, 87.30705868728619, 92.4986065248718, 97.99885985952928, 103.8261752752493, 110.0, 116.54094128853936, 123.47082623522826, 130.8127835819113, 138.59131642844417, 146.8323849048125, 155.56349281065155, 164.81377940661966, 174.61411666397075, 184.99721229688743, 195.99771892143522, 207.6523497054461, 220.0, 233.08188162853938, 246.9416514655141, 261.6255660991232, 277.1826317288786, 293.6647686145403, 311.126984355155, 329.6275574718021, 349.2282319067383, 369.9944230880625, 391.99543624762373, 415.3046977207872, 440.0, 466.16376136, 493.8833009211433, 523.2511300688476, 554.3652612017378, 587.3295348389113, 622.2539661780138, 659.2551122607299, 698.4564609710702, 739.9888431647004, 783.9908693047543, 830.6093920613646, 880.0, 932.3275189258428, 987.766597822517, 1046.5022558788976, 1108.7305178914366, 1174.6590648974839, 1244.5079272914352, 1318.510219155711, 1396.9129162573277, 1479.9776803065513, 1567.9817322285219, 1661.2187773623093, 1760.0, 1864.6550302633707, 1975.5331876054945, 2093.0045032402, 2217.4610267587955, 2349.3181202342903, 2489.0158444536855, 2637.0204275799247, 2793.82582114503, 2959.9553485674046, 3135.963451695071, 3322.4375412037793, 3520.0, 3729.3100453501124, 3951.0663591319108, 4186.008989445209};
    public static final double under_0_note = note_pitchs[0] + (note_pitchs[1] - note_pitchs[0]) / 2.0;
    public static final double over_last_note = note_pitchs[note_pitchs.length - 1] - (note_pitchs[note_pitchs.length - 1] - note_pitchs[note_pitchs.length - 1 - 1]) / 2.0;
    public static final int MIDI_OFFSET = 21;
    static double per = 78.125;
    private List<NoteData> noVoices;
    private int lastNote;
    private int pertick = 128;
    private int tempo = 240;
    private int defaultNote = 40;
    private double cal_1000 = 1000.0 / (double)(this.pertick * 4);
    public static final int JAVA_NOTE_OFFSET = 12;

    public static int pitchToNoteNumber(double pitch) {
        return PitchToMIDI.pitchToNoteNumber(pitch, null);
    }

    public static int pitchToNoteNumber(double pitch, int[] scaleFilters) {
        if (pitch < under_0_note) {
            return PitchToMIDI.filterdNote(21, true, scaleFilters);
        }
        if (pitch > over_last_note) {
            return PitchToMIDI.filterdNote(note_pitchs.length - 1 + 21, true, scaleFilters);
        }
        int i = 0;
        while (i < note_pitchs.length - 1) {
            double base = PitchToMIDI.noteNumberToPitch(i + 21);
            double base_plus = PitchToMIDI.noteNumberToPitch(i + 1 + 21);
            if (pitch < base) {
                return PitchToMIDI.filterdNote(i + 21, false, scaleFilters);
            }
            if (pitch < base_plus) {
                double half = (base_plus - base) / 2.0;
                if (pitch > base + half) {
                    return PitchToMIDI.filterdNote(i + 1 + 21, false, scaleFilters);
                }
                return PitchToMIDI.filterdNote(i + 21, true, scaleFilters);
            }
            ++i;
        }
        return PitchToMIDI.filterdNote(note_pitchs.length - 1 + 21, false, scaleFilters);
    }

    public static int noteToScale(int note) {
        return (note - 21 + 9) % 12;
    }

    public static int filterdNote(int note, boolean isUpper, int[] scaleFilters) {
        if (scaleFilters == null) {
            return note;
        }
        Arrays.sort(scaleFilters);
        int myScale = PitchToMIDI.noteToScale(note);
        log.info((Object)("note=" + note + ",scale=" + myScale));
        int i = 0;
        while (i < scaleFilters.length) {
            if (scaleFilters[i] == myScale) {
                return note;
            }
            ++i;
        }
        int nearDown = 256;
        int nearUp = 256;
        int i2 = 0;
        while (i2 < note_pitchs.length) {
            int tmpS = PitchToMIDI.noteToScale(i2 + 21);
            int j = 0;
            while (j < scaleFilters.length) {
                if (scaleFilters[j] == tmpS && i2 + 21 != note) {
                    if (i2 + 21 < note) {
                        nearDown = Math.min(nearDown, note - (i2 + 21));
                        break;
                    }
                    nearUp = Math.min(nearUp, i2 + 21 - note);
                    break;
                }
                ++j;
            }
            ++i2;
        }
        if (nearDown == nearUp) {
            if (nearDown == 256) {
                return note;
            }
            if (isUpper) {
                return note + nearUp;
            }
            return note - nearDown;
        }
        if (nearUp > nearDown) {
            return note - nearDown;
        }
        return note + nearUp;
    }

    public static void main(String[] argv) {
        int i = 0;
        while (i < 128) {
            ++i;
        }
    }

    public static int toVelocity(double value) {
        if (value <= 0.0) {
            return 0;
        }
        int v = (int)(value / per);
        return Math.min(v, 127);
    }

    public void makeMIDI(ESPS[] espses, File file) throws IOException {
        log.info((Object)("makeMIDI:" + espses.length + " espses,file=" + file.getAbsolutePath()));
        Sequence seq = null;
        try {
            seq = new Sequence(0.0f, this.pertick);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
        Track track = this.initializeTrack(seq);
        Note[] notes = this.espsesToNote(espses);
        int i = 0;
        while (i < notes.length) {
            System.out.println("note:" + notes[i].getNote() + ",pitch=" + espses[i].getPitch());
            ++i;
        }
        i = 0;
        while (i < notes.length) {
            PitchToMIDI.addNote(track, notes[i]);
            ++i;
        }
        if (track.size() == 0) {
            throw new IOException("empty midi");
        }
        MidiSystem.write(seq, 0, file);
    }

    private Note[] espsesToNote(ESPS[] espses) {
        ArrayList noteList = new ArrayList();
        int tick = this.pertick / 16;
        int current = 0;
        if (!this.ignoreOffset) {
            current = (int)((double)(this.pertick * 4) * 0.0075);
        }
        log.info((Object)("offset:" + current));
        int i = 0;
        while (i < espses.length) {
            if (espses[i].getPitch() > 0.0) {
                log.trace((Object)(String.valueOf(PitchToMIDI.pitchToNoteNumber(espses[i].getPitch(), this.scaleFilter) + this.shiftNote) + " " + espses[i].getMeasurements()));
                int note = PitchToMIDI.pitchToNoteNumber(espses[i].getPitch(), this.scaleFilter);
                int velocity = this.defaultVelocity;
                if (this.setVelocity) {
                    velocity = PitchToMIDI.toVelocity(espses[i].getMeasurements());
                }
                if (this.noVoices != null) {
                    NoteData[] datas = this.noVoices.toArray(new NoteData[this.noVoices.size()]);
                    int j = 0;
                    while (j < datas.length) {
                        log.trace((Object)"start novoice");
                        this.addNote(noteList, datas[j].getStart(), datas[j].getEnd(), note + this.shiftNote, datas[j].getVelocity());
                        ++j;
                    }
                    this.noVoices = null;
                }
                log.info((Object)("addNote:" + this.noteToMillisecond(current) + "," + this.noteToMillisecond(current + tick) + "," + (note + this.shiftNote) + "," + velocity));
                this.addNote(noteList, current, current + tick, note + this.shiftNote, velocity);
                this.lastNote = note;
            } else {
                long startms = this.noteToMillisecond(current);
                long endms = this.noteToMillisecond(current + tick);
                log.trace((Object)("no pitch:" + startms + "," + endms));
                if (espses[i].getMeasurements() > (double)this.volumeMin) {
                    log.trace((Object)("*0:" + espses[i].getMeasurements()));
                    int velocity = this.defaultVelocity;
                    if (this.setVelocity) {
                        velocity = PitchToMIDI.toVelocity(espses[i].getMeasurements());
                    }
                    if (this.lastNote == 0) {
                        if (this.noVoices == null) {
                            this.noVoices = new ArrayList<NoteData>();
                        }
                        NoteData data = new NoteData(current, current + tick, 0, velocity);
                        this.noVoices.add(data);
                    } else {
                        log.trace((Object)"end novoice");
                        this.addNote(noteList, current, current + tick, this.lastNote + this.shiftNote, velocity);
                    }
                } else {
                    log.trace((Object)("0:" + espses[i].getMeasurements()));
                    if (this.noVoices != null) {
                        log.info((Object)"no voice sounds");
                        NoteData[] datas = this.noVoices.toArray(new NoteData[this.noVoices.size()]);
                        int j = 0;
                        while (j < datas.length) {
                            log.trace((Object)"start novoice");
                            log.info((Object)("addNoVoice:" + datas[j].getVelocity() + "," + this.noteToMillisecond(datas[j].getStart()) + "," + this.noteToMillisecond(datas[j].getEnd())));
                            this.addNote(noteList, datas[j].getStart(), datas[j].getEnd(), this.defaultNote + this.shiftNote, datas[j].getVelocity());
                            ++j;
                        }
                        this.noVoices = null;
                    }
                    this.noVoices = null;
                    this.lastNote = 0;
                }
            }
            current += tick;
            ++i;
        }
        if (this.noVoices != null) {
            log.info((Object)"no voice sounds");
            NoteData[] datas = this.noVoices.toArray(new NoteData[this.noVoices.size()]);
            int j = 0;
            while (j < datas.length) {
                log.trace((Object)"start novoice");
                log.info((Object)("addNoVoice:" + datas[j].getVelocity() + "," + this.noteToMillisecond(datas[j].getStart()) + "," + this.noteToMillisecond(datas[j].getEnd())));
                this.addNote(noteList, datas[j].getStart(), datas[j].getEnd(), this.defaultNote + this.shiftNote, datas[j].getVelocity());
                ++j;
            }
            this.noVoices = null;
        }
        log.info((Object)(String.valueOf(current) + " tick, " + this.toSec((double)current / (double)(this.pertick * 4)) + " sec"));
        return noteList.toArray(new Note[noteList.size()]);
    }

    private Track initializeTrack(Sequence seq) {
        Track track = null;
        try {
            track = seq.createTrack();
            MetaMessage tempoMessage = new MetaMessage();
            int l = 60000000 / this.tempo;
            tempoMessage.setMessage(81, new byte[]{(byte)(l / 65536), (byte)(l % 65536 / 256), (byte)(l % 256)}, 3);
            track.add(new MidiEvent(tempoMessage, 0L));
            ShortMessage message = new ShortMessage();
            message.setMessage(192, this.instrument, 0);
            track.add(new MidiEvent(message, 0L));
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
        return track;
    }

    public void makeMIDI(ESPS[] espses, StandardSubObject[] subtitles, File file) throws IOException {
        int i;
        log.info((Object)("makeMIDI:" + espses.length + " espses,file=" + file.getAbsolutePath()));
        Sequence seq = null;
        try {
            seq = new Sequence(0.0f, this.pertick);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
        Track track = this.initializeTrack(seq);
        Note[] notes = this.espsesToNote(espses);
        List[] subNotes = new List[subtitles.length];
        if (subtitles.length > 0) {
            i = 0;
            while (i < notes.length) {
                int j = 0;
                while (j < subtitles.length) {
                    if (this.inTime(notes[i], subtitles[j])) {
                        log.info((Object)("intime:" + this.noteToMillisecond(notes[i].getStart()) + "-" + this.noteToMillisecond(notes[i].getEnd())));
                        if (subNotes[j] == null) {
                            subNotes[j] = new ArrayList();
                        }
                        subNotes[j].add(notes[i]);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        i = 0;
        while (i < subNotes.length) {
            if (subNotes[i] != null) {
                this.addAverageNote(track, subNotes[i]);
            } else if (this.forceInsert) {
                int minTick = this.pertick / 16;
                int startTick = this.timeToTick(subtitles[i].getStartTime());
                int endTick = this.timeToTick(subtitles[i].getEndTime());
                int stick = startTick + (endTick - startTick - minTick) / 2;
                log.info((Object)("add empty note:s=" + stick));
                PitchToMIDI.addNote(track, stick, stick + minTick, PitchToMIDI.filterdNote(this.defaultNote, true, this.scaleFilter), this.defaultVelocity);
            }
            ++i;
        }
        if (track.size() == 0) {
            throw new IOException("empty midi");
        }
        MidiSystem.write(seq, 0, file);
    }

    public double toSec(double v) {
        return new BigDecimal(v).setScale(2, 4).doubleValue();
    }

    private void addAverageNote(Track track, List list) {
        Note[] notes = list.toArray(new Note[list.size()]);
        int start = 0;
        int end = 0;
        long totalNote = 0L;
        long totalVelocity = 0L;
        int i = 0;
        while (i < notes.length) {
            if (i == 0) {
                start = notes[i].start;
                end = notes[i].end;
            } else {
                start = Math.min(notes[i].getStart(), start);
                end = Math.max(notes[i].getEnd(), end);
            }
            totalNote += (long)notes[i].getNote();
            totalVelocity += (long)notes[i].getVelocity();
            ++i;
        }
        int note = (int)(totalNote / (long)notes.length);
        int velocity = (int)(totalVelocity / (long)notes.length);
        int filterd = PitchToMIDI.filterdNote(note, true, this.scaleFilter);
        int scale = PitchToMIDI.noteToScale(filterd);
        if (scale == 0 || scale != 4) {
            // empty if block
        }
        PitchToMIDI.addNote(track, start, end, filterd, velocity);
    }

    public boolean inTime(Note note, StandardSubObject sub) {
        long start = (long)((double)note.getStart() * this.cal_1000);
        long end = (long)((double)note.getEnd() * this.cal_1000);
        return sub.intersect(start, end);
    }

    public int timeToTick(long time) {
        int tick = (int)((double)time / this.cal_1000);
        return tick;
    }

    public void addNote(List list, int start, int end, int note, int velocity) {
        note = PitchToMIDI.filterdNote(note, true, this.scaleFilter);
        list.add(new Note(start, end, note, velocity));
    }

    public long noteToMillisecond(int value) {
        return (long)(this.cal_1000 * (double)value);
    }

    public static void addNote(Track track, Note noteData) {
        ShortMessage noteOn1 = new ShortMessage();
        try {
            noteOn1.setMessage(144, noteData.getNote() + 12, noteData.getVelocity());
            track.add(new MidiEvent(noteOn1, noteData.getStart()));
            ShortMessage noteOn2 = new ShortMessage();
            noteOn2.setMessage(128, noteData.getNote() + 12, 0);
            track.add(new MidiEvent(noteOn2, noteData.getEnd()));
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    public static void addNote(Track track, int start, int end, int note, int velocity) {
        ShortMessage noteOn1 = new ShortMessage();
        try {
            noteOn1.setMessage(144, note + 12, velocity);
            track.add(new MidiEvent(noteOn1, start));
            ShortMessage noteOn2 = new ShortMessage();
            noteOn2.setMessage(128, note + 12, 0);
            track.add(new MidiEvent(noteOn2, end));
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    public void makeMIDI(Double[] pitchs, File file) throws IOException {
        ESPS[] esps = new ESPS[pitchs.length];
        int i = 0;
        while (i < pitchs.length) {
            esps[i].setPitch(pitchs[i]);
            ++i;
        }
        this.makeMIDI(esps, file);
    }

    public void makeMIDI(double[] pitchs, File file) throws IOException {
        ESPS[] esps = new ESPS[pitchs.length];
        int i = 0;
        while (i < pitchs.length) {
            esps[i].setPitch(pitchs[i]);
            ++i;
        }
        this.makeMIDI(esps, file);
    }

    public static double noteNumberToPitch(int note) {
        if ((note -= 21) >= 0 && note < note_pitchs.length) {
            return note_pitchs[note];
        }
        return 0.0;
    }

    public int getShiftNote() {
        return this.shiftNote;
    }

    public void setShiftNote(int shiftNote) {
        this.shiftNote = shiftNote;
    }

    public int getVolumeMin() {
        return this.volumeMin;
    }

    public void setVolumeMin(int volumeMin) {
        this.volumeMin = volumeMin;
    }

    public int getTempo() {
        return this.tempo;
    }

    public void setTempo(int tempo) {
        this.tempo = tempo;
    }

    public boolean isIgnoreOffset() {
        return this.ignoreOffset;
    }

    public void setIgnoreOffset(boolean ignoreOffset) {
        this.ignoreOffset = ignoreOffset;
    }

    public boolean isForceInsert() {
        return this.forceInsert;
    }

    public void setForceInsert(boolean allowEmptySubtitleNote) {
        this.forceInsert = allowEmptySubtitleNote;
    }

    public class NoteData {
        private int start;
        private int end;
        private int note;
        private int velocity;

        public NoteData(int start, int end, int note, int velocity) {
            this.start = start;
            this.end = end;
            this.note = note;
            this.velocity = velocity;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public int getNote() {
            return this.note;
        }

        public void setNote(int note) {
            this.note = note;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getVelocity() {
            return this.velocity;
        }

        public void setVelocity(int velocity) {
            this.velocity = velocity;
        }
    }

    public static class Note {
        private int start;
        private int end;
        private int note;
        private int velocity;

        public Note(int start, int end, int note, int velocity) {
            this.start = start;
            this.end = end;
            this.note = note;
            this.velocity = velocity;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public int getNote() {
            return this.note;
        }

        public void setNote(int note) {
            this.note = note;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getVelocity() {
            return this.velocity;
        }

        public void setVelocity(int velocity) {
            this.velocity = velocity;
        }
    }
}

