/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.psp.imageconvert;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import jp.sourceforge.akjrcp.psp.imageconvert.AbstractImageChanger;
import jp.sourceforge.akjrcp.util.image.ImageUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImageResizer
extends AbstractImageChanger {
    public static Log log = LogFactory.getLog(ImageResizer.class);
    public static final int TURN_RIGHT = 0;

    public ImageResizer() {
        this.time = System.currentTimeMillis();
    }

    public void changeImage(String imageFileName, InputStream imageInput, File exportDir) throws IOException {
        double ratio;
        if (this.cancel) {
            return;
        }
        BufferedImage baseImage = this.imageLoader.loadImage(imageFileName, imageInput);
        BufferedImage argb = this.toARGB(baseImage);
        baseImage.getGraphics().dispose();
        int resizeW = this.width;
        int resizeH = this.height;
        if (this.width == 0 && this.height == 0) {
            log.warn((Object)"set width or height");
            return;
        }
        if (this.width == 0) {
            ratio = (double)baseImage.getHeight() / (double)this.height;
            resizeW = (int)((double)baseImage.getWidth() / ratio);
            resizeH = this.height;
        } else if (this.height == 0) {
            ratio = (double)baseImage.getWidth() / (double)this.width;
            resizeH = (int)((double)baseImage.getHeight() / ratio);
            resizeW = this.width;
        }
        log.trace((Object)("resize:" + resizeW + "x" + resizeH));
        BufferedImage fit = ImageUtils.fitImage(argb, resizeW, resizeH);
        argb.getGraphics().dispose();
        BufferedImage rgb = this.toRGB(fit);
        fit.getGraphics().dispose();
        this.saveImage(rgb, imageFileName, exportDir);
        rgb.getGraphics().dispose();
        System.gc();
    }
}

