/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ffmpeg;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegPreference;
import jp.sourceforge.akjrcp.ui.DirectryBasedExecuterListener;
import jp.sourceforge.akjrcp.util.ProcessMonitor;
import jp.sourceforge.akjrcp.util.ProcessPrinter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InputStreamFFMpegExecuter {
    public static Log log = LogFactory.getLog(InputStreamFFMpegExecuter.class);
    private FFMpegPreference ffmpegPreference = new FFMpegPreference();
    private Process process;
    private boolean cancelling;
    private DirectryBasedExecuterListener executeListener;
    private List inputFiles = new ArrayList();
    private File outputFile;

    public int getGuessSize() {
        return this.ffmpegPreference.getGuessSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        log.info((Object)"called cancel");
        InputStreamFFMpegExecuter inputStreamFFMpegExecuter = this;
        synchronized (inputStreamFFMpegExecuter) {
            log.info((Object)("cancell:" + System.currentTimeMillis()));
            this.cancelling = true;
        }
        if (this.process != null) {
            this.process.destroy();
            log.info((Object)("maybe destroyed:" + this.process));
        }
    }

    public static File makeBackupFile(File file, String addextension) {
        int count = 1;
        File bkfile = new File(file.getParentFile(), String.valueOf(file.getName()) + "." + addextension);
        while (bkfile.exists()) {
            bkfile = new File(file.getParentFile(), String.valueOf(file.getName()) + "." + "(" + count + ")." + addextension);
            ++count;
        }
        return bkfile;
    }

    private void inExecute() {
        block14: {
            File tmpOutput = this.outputFile;
            if (tmpOutput == null) {
                return;
            }
            if (this.process != null) {
                this.process.destroy();
            }
            this.process = null;
            try {
                if (!this.ffmpegPreference.isTwoPassEncode()) {
                    String[] commands = this.ffmpegPreference.toCommand("-", null, tmpOutput.getAbsolutePath());
                    if (commands == null) {
                        log.warn((Object)"null command");
                        return;
                    }
                    if (this.executeListener != null) {
                        this.executeListener.startConvert(null);
                    }
                    Runtime runtime = Runtime.getRuntime();
                    ErrorCatchProcessPrinter printer = new ErrorCatchProcessPrinter();
                    try {
                        printer.printOutput(InputStreamFFMpegExecuter.toDebugArray(commands));
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    log.info((Object)("start process:" + this.process + "," + ArrayUtils.toString((Object)commands)));
                    this.process = runtime.exec(commands);
                    log.info((Object)("process:" + System.currentTimeMillis() + "," + this.cancelling));
                    ProcessMonitor monitor = new ProcessMonitor(this.process, printer);
                    monitor.startMonitor();
                    this.writeInFiles(this.process);
                    try {
                        if (this.cancelling) {
                            log.info((Object)"finally cancel ");
                            return;
                        }
                        this.process.waitFor();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    break block14;
                }
                throw new RuntimeException("2pass not supported");
            }
            catch (IOException e1) {
                e1.printStackTrace();
                this.process.destroy();
                if (this.executeListener != null) {
                    this.executeListener.faildConvert(null, e1.getMessage());
                }
                return;
            }
        }
        if (this.executeListener != null) {
            this.executeListener.endConvert(null);
        }
        this.process = null;
    }

    public void writeInFiles(Process process) {
    }

    public static String toDebugArray(String[] array) {
        String v = "";
        int i = 0;
        while (i < array.length) {
            v = String.valueOf(v) + "\"" + array[i] + "\"" + " ";
            ++i;
        }
        return String.valueOf(v) + "\n";
    }

    public DirectryBasedExecuterListener getExecuteListener() {
        return this.executeListener;
    }

    public void setExecuteListener(DirectryBasedExecuterListener executeListener) {
        this.executeListener = executeListener;
    }

    public FFMpegPreference getFfmpegPreference() {
        return this.ffmpegPreference;
    }

    public void setFfmpegPreference(FFMpegPreference ffmpegPreference) {
        this.ffmpegPreference = ffmpegPreference;
    }

    public void addFile(File file) {
        this.inputFiles.add(file);
    }

    public class TestMonitor
    implements DirectryBasedExecuterListener {
        public void beforeConvert() {
        }

        public void afterConvert() {
        }

        public void startConvert(File file) {
        }

        public void endConvert(File file) {
        }

        public void faildConvert(File file, String message) {
            log.info((Object)("faild:" + file));
        }

        public void printProcess(String line) {
        }

        public boolean askOverwrite(File output) {
            return false;
        }
    }

    public class ErrorCatchProcessPrinter
    implements ProcessPrinter {
        public void printOutput(String output) throws IOException {
            this.print(output);
        }

        public void printError(String error) throws IOException {
            this.print(error);
        }

        private void print(String line) throws IOException {
            if (InputStreamFFMpegExecuter.this.executeListener != null) {
                InputStreamFFMpegExecuter.this.executeListener.printProcess(line);
            }
            log.debug((Object)line);
            if (line.indexOf("Unsupported video codec") != -1) {
                throw new IOException("Unsupported video codec");
            }
        }
    }
}

