/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.dropsomething;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.dropsomething.DirectoryBasedDropSomething;
import jp.sourceforge.akjrcp.dropsomething.IDropSomething;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegExecuter;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFLVParser;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegPreference;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUI;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUtils;
import jp.sourceforge.akjrcp.ffmpeg.FLVInfomation;
import jp.sourceforge.akjrcp.flvtools.explorer.ThumbnailManager;
import jp.sourceforge.akjrcp.ui.DirectryBasedExecuterListener;
import jp.sourceforge.akjrcp.ui.FileOverwriteControler;
import jp.sourceforge.akjrcp.ui.GenericParameters;
import jp.sourceforge.akjrcp.ui.GenericParametersEditor;
import jp.sourceforge.akjrcp.ui.GenericParametersFFMpegPreference;
import jp.sourceforge.akjrcp.ui.GenericParametersSaveDialog;
import jp.sourceforge.akjrcp.ui.GenericParametersTableViewer;
import jp.sourceforge.akjrcp.ui.param.ParamBoolean;
import jp.sourceforge.akjrcp.ui.param.ParamCheckGroup;
import jp.sourceforge.akjrcp.ui.param.ParamCombo;
import jp.sourceforge.akjrcp.ui.param.ParamItem;
import jp.sourceforge.akjrcp.ui.param.ParamItemActionListener;
import jp.sourceforge.akjrcp.ui.param.ParamText;
import jp.sourceforge.akjrcp.util.FileNameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class H264ConvertTabBuilder
implements IDropSomething {
    public static Log log = LogFactory.getLog(H264ConvertTabBuilder.class);
    private FileOverwriteControler fileOverwriteControler;
    public static final String TYPE_SELECT = "type_select";
    public static final String AVISYNTH = "avisynth";
    public static final String H264CONVERT = "h264convert";

    public void createTab(ViewPart part, CTabFolder tab) {
        CTabItem tabItem1 = new CTabItem(tab, 0);
        tabItem1.setText(Messages.getString("h264convert.tab"));
        H264ConvertTab dtab = new H264ConvertTab((Composite)tab, 0);
        dtab.setViewPart(part);
        tabItem1.setControl((Control)dtab);
        this.fileOverwriteControler = new FileOverwriteControler(tab.getShell());
    }

    public class H264ConvertTab
    extends DirectoryBasedDropSomething {
        private FFMpegExecuter ffmpegExecuter;
        private Label dragHere;
        private String currentTarget;
        private Button avisynth;
        private List settingList;
        private GenericParametersTableViewer tableViewer;
        private List<ParamItem> paramList;
        private Button saveSetting;
        ItemModifyCheck itemModifyCheck;

        public H264ConvertTab(Composite parent, int style) {
            super(parent, style);
        }

        public void addParamList(ParamItem item) {
            this.paramList.add(item);
            item.setParamItemActionListener(this.itemModifyCheck);
        }

        public Map toNewParameterMap() {
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            int i = 0;
            while (i < this.paramList.size()) {
                ParamItem item = this.paramList.get(i);
                if (item.getValue().length() > 0) {
                    parameterMap.put(item.getKey(), item.getValue());
                }
                ++i;
            }
            return parameterMap;
        }

        public void tableSelectionChanged() {
            this.saveSetting.setEnabled(false);
            int selection = this.tableViewer.getTable().getSelectionIndex();
            if (selection >= 0) {
                log.info((Object)("table item changed:" + selection));
                GenericParameters parameters = (GenericParameters)this.tableViewer.getTable().getItem(this.tableViewer.getTable().getSelectionIndex()).getData();
                log.info((Object)("size:" + this.paramList.size()));
                Map<String, String> map = parameters.getParameters();
                int i = 0;
                while (i < this.paramList.size()) {
                    ParamItem item = this.paramList.get(i);
                    String value = map.get(item.getKey());
                    if (value != null) {
                        log.info((Object)(String.valueOf(item.getKey()) + "," + value));
                        item.setValue(value);
                    } else {
                        item.setValue("");
                    }
                    ++i;
                }
            }
        }

        public Composite createControls(Composite parent) {
            this.itemModifyCheck = new ItemModifyCheck();
            this.paramList = new ArrayList<ParamItem>();
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, true));
            Composite listComposite = new Composite(composite, 0);
            listComposite.setLayoutData((Object)new GridData(768));
            listComposite.setLayout((Layout)new GridLayout(2, false));
            List list = GenericParametersTableViewer.loadList(this.getPreferenceStore().getString("h264setting.h264_settings"));
            GridData gd = new GridData(768);
            gd.heightHint = 40;
            this.tableViewer = new GenericParametersTableViewer(listComposite);
            this.tableViewer.getTable().setLayoutData((Object)gd);
            this.tableViewer.setGenericParametersList(list);
            this.tableViewer.addSelectionChangedListener(new SelectChanged());
            this.saveSetting = new Button(listComposite, 0);
            this.saveSetting.setText(Messages.getString("h264converter.save"));
            this.saveSetting.setEnabled(false);
            this.saveSetting.addSelectionListener((SelectionListener)new GenericSave());
            this.settingList = new ArrayList();
            this.setPreferenceKey(H264ConvertTabBuilder.H264CONVERT);
            SavePreferenceStore savePreference = new SavePreferenceStore();
            CTabFolder tab = new CTabFolder(composite, 0x800400);
            tab.setLayoutData((Object)new GridData(1808));
            Composite basicComposite = new Composite((Composite)tab, 0);
            basicComposite.setLayout((Layout)new GridLayout(1, true));
            CTabItem tabItem1 = new CTabItem(tab, 0);
            tabItem1.setText("Basic");
            tabItem1.setControl((Control)basicComposite);
            this.createDirectoryInfo(basicComposite);
            this.avisynth = new Button(basicComposite, 32);
            this.avisynth.setText(Messages.getString("pspconvert.use_avisynth"));
            this.avisynth.setToolTipText(Messages.getString("pspconvert.use_avisynth_tooltip"));
            this.avisynth.addSelectionListener((SelectionListener)savePreference);
            this.dragHere = new Label(basicComposite, 0);
            this.dragHere.setLayoutData((Object)new GridData(768));
            this.restoreControl((Control)this.avisynth);
            Group formatGroup = new Group(basicComposite, 0);
            formatGroup.setText("Format");
            formatGroup.setLayout((Layout)new GridLayout(2, true));
            ParamCombo extension = new ParamCombo((Composite)formatGroup, 0, "EXTENSION", "[Exteision]", new String[]{"mp4", "3gp", "3g2", "mov", "avi", "m4v"});
            this.addParamList(extension);
            ParamCombo f = new ParamCombo((Composite)formatGroup, 0, "f", "Format(f)", new String[]{"mp4", "3gp", "3g2", "psp", "mov"});
            this.addParamList(f);
            Group vgroup = new Group(basicComposite, 0);
            vgroup.setLayout((Layout)new GridLayout(6, false));
            vgroup.setText("Video");
            GridData vdata = new GridData();
            vdata.minimumHeight = 120;
            vdata.grabExcessVerticalSpace = false;
            vgroup.setLayoutData((Object)vdata);
            ParamCombo vcodec = new ParamCombo((Composite)vgroup, 0, "vcodec", "vcodec", new String[]{"h264", "mpeg4", "xvid"});
            this.addParamList(vcodec);
            ParamCombo r = new ParamCombo((Composite)vgroup, 0, "r", "rate", new String[]{"12", "14.895", "15", "25", "29.97", "30", "ntsc", "pal", "30000/1001"});
            this.addParamList(r);
            ParamCombo s = new ParamCombo((Composite)vgroup, 0, "s", "size", new String[]{"", "176x144", "176x144", "208x176", "416x352", "208x208", "320x240", "640x480", "720x480"});
            this.addParamList(s);
            ParamCombo b = new ParamCombo((Composite)vgroup, 0, "b", "bitrate(b)", new String[]{"384k", "700k", "768k", "1536k", "3072k"});
            this.addParamList(b);
            ParamCombo bt = new ParamCombo((Composite)vgroup, 0, "bt", "bt", new String[]{"384k", "700k", "768k", "1536k", "3072k"});
            this.addParamList(bt);
            ParamCombo bufsize = new ParamCombo((Composite)vgroup, 0, "bufsize", "bufsize", new String[]{"224k", "384k", "700k", "768k", "1536k", "3072k", "4096k"});
            this.addParamList(bufsize);
            ParamCombo maxrate = new ParamCombo((Composite)vgroup, 0, "maxrate", "maxrate", new String[]{"384k", "768k", "1000k", "1536k", "3072k", "4000k", "10000k"});
            this.addParamList(maxrate);
            ParamCombo vtag = new ParamCombo((Composite)vgroup, 0, "vtag", "vtag", new String[]{"XVID", "mp4v", "DX50"});
            this.addParamList(vtag);
            ParamCombo crf = new ParamCombo((Composite)vgroup, 0, "crf", "crf", new String[]{"15", "20", "26", "32", "34"});
            this.addParamList(crf);
            ParamCombo level = new ParamCombo((Composite)vgroup, 0, "level", "level", new String[]{"13", "21", "30"});
            this.addParamList(level);
            ParamCombo aspect = new ParamCombo((Composite)vgroup, 0, "aspect", "aspect", new String[]{"", "4:3", "16:9"});
            this.addParamList(aspect);
            ParamBoolean sameq = new ParamBoolean((Composite)vgroup, 0, "sameq", "sameq");
            this.addParamList(sameq);
            ParamBoolean vn = new ParamBoolean((Composite)vgroup, 0, "vn", "vn");
            this.addParamList(vn);
            ParamBoolean deinterlace = new ParamBoolean((Composite)vgroup, 0, "deinterlace", "deinterlace");
            this.addParamList(deinterlace);
            Group agroup = new Group(basicComposite, 0);
            agroup.setText("Audio");
            agroup.setLayout((Layout)new GridLayout(6, false));
            GridData adata = new GridData();
            adata.minimumHeight = 120;
            adata.grabExcessVerticalSpace = false;
            agroup.setLayoutData((Object)adata);
            ParamCombo acodec = new ParamCombo((Composite)agroup, 0, "acodec", "acodec", new String[]{"aac", "mp3"});
            this.addParamList(acodec);
            ParamCombo ab = new ParamCombo((Composite)agroup, 0, "ab", "ab", new String[]{"32k", "64k", "96k", "128k", "160k"});
            this.addParamList(ab);
            ParamCombo ar = new ParamCombo((Composite)agroup, 0, "ar", "ar", new String[]{"", "8000", "16000", "22050", "24000", "32000", "44100", "48000"});
            this.addParamList(ar);
            ParamCombo ac = new ParamCombo((Composite)agroup, 0, "ac", "ac", new String[]{"", "2", "1"});
            this.addParamList(ac);
            ParamCombo vol = new ParamCombo((Composite)agroup, 0, "vol", "vol", new String[]{"", "224", "256", "288", "320", "352", "384"});
            this.addParamList(vol);
            ParamBoolean an = new ParamBoolean((Composite)agroup, 0, "an", "an");
            this.addParamList(an);
            Composite advancedComposite = new Composite((Composite)tab, 0);
            advancedComposite.setLayout((Layout)new GridLayout(1, true));
            CTabItem tabItem2 = new CTabItem(tab, 0);
            tabItem2.setText("Advanced");
            tabItem2.setControl((Control)advancedComposite);
            ParamCheckGroup flags = new ParamCheckGroup(advancedComposite, 0, "flags", "flags", new String[]{"mv4", "obmc", "qpel", "loop", "gmc", "mv0", "part", "gray", "psnr", "naq", "ildct", "low_delay", "alt", "trell", "bitexact", "aic", "umv", "cbp", "qprd", "aiv", "slice", "ilme", "scan_offset", "cgop"}, 12);
            this.addParamList(flags);
            String text = "";
            text = String.valueOf(text) + "-flags             <flags> EDVA.\n";
            text = String.valueOf(text) + "   mv4                     E.V.. use four motion vector by macroblock (mpeg4)\n";
            text = String.valueOf(text) + "   obmc                    E.V.. use overlapped block motion compensation (h263+)\n";
            text = String.valueOf(text) + "   qpel                    E.V.. use 1/4 pel motion compensation\n";
            text = String.valueOf(text) + "   loop                    E.V.. use loop filter\n";
            text = String.valueOf(text) + "   gmc                     E.V.. use gmc\n";
            text = String.valueOf(text) + "   mv0                     E.V.. always try a mb with mv=<0,0>\n";
            text = String.valueOf(text) + "   part                    E.V.. use data partitioning\n";
            text = String.valueOf(text) + "   gray                    EDV.. only decode/encode grayscale\n";
            text = String.valueOf(text) + "   psnr                    E.V.. error[?] variables will be set during encoding\n";
            text = String.valueOf(text) + "   naq                     E.V.. normalize adaptive quantization\n";
            text = String.valueOf(text) + "   ildct                   E.V.. use interlaced dct\n";
            text = String.valueOf(text) + "   low_delay               EDV.. force low delay\n";
            text = String.valueOf(text) + "   alt                     E.V.. enable alternate scantable (mpeg2/mpeg4)\n";
            text = String.valueOf(text) + "   trell                   E.V.. use trellis quantization\n";
            text = String.valueOf(text) + "   bitexact                EDVAS use only bitexact stuff (except (i)dct)\n";
            text = String.valueOf(text) + "   aic                     E.V.. h263 advanced intra coding / mpeg4 ac prediction\n";
            text = String.valueOf(text) + "   umv                     E.V.. use unlimited motion vectors\n";
            text = String.valueOf(text) + "   cbp                     E.V.. use rate distortion optimization for cbp\n";
            text = String.valueOf(text) + "   qprd                    E.V.. use rate distortion optimization for qp selection\n";
            text = String.valueOf(text) + "   aiv                     E.V.. h263 alternative inter vlc\n";
            text = String.valueOf(text) + "   slice                   E.V..\n";
            text = String.valueOf(text) + "   ilme                    E.V.. interlaced motion estimation\n";
            text = String.valueOf(text) + "   scan_offset             E.V.. will reserve space for svcd scan offset user data\n";
            text = String.valueOf(text) + "   cgop                    E.V.. closed gop\n";
            flags.setToolTipText(text);
            Group group1 = new Group(advancedComposite, 0);
            group1.setLayout((Layout)new GridLayout(7, false));
            ParamCombo b_strategy = new ParamCombo((Composite)group1, 0, "b_strategy", "b_strategy", new String[]{"", "0", "1"});
            this.addParamList(b_strategy);
            ParamCombo trellis = new ParamCombo((Composite)group1, 0, "trellis", "trellis", new String[]{"", "0", "1", "2"});
            this.addParamList(trellis);
            ParamCombo refs = new ParamCombo((Composite)group1, 0, "refs", "refs", new String[]{"", "0", "1"});
            this.addParamList(refs);
            ParamCombo bf = new ParamCombo((Composite)group1, 0, "bf", "bf", new String[]{"", "0", "1", "2", "3", "4", "5"});
            this.addParamList(bf);
            ParamCombo coder = new ParamCombo((Composite)group1, 0, "coder", "coder", new String[]{"", "0", "1"});
            this.addParamList(coder);
            ParamCombo g = new ParamCombo((Composite)group1, 0, "g", "g", new String[]{"", "12", "18", "32", "50", "100", "200", "250", "300"});
            this.addParamList(g);
            ParamCombo deblockalpha = new ParamCombo((Composite)group1, 0, "deblockalpha", "deblockalpha", new String[]{"", "0", "1"});
            this.addParamList(deblockalpha);
            ParamCombo deblockbeta = new ParamCombo((Composite)group1, 0, "deblockbeta", "deblockbeta", new String[]{"", "0", "1"});
            this.addParamList(deblockbeta);
            ParamCombo mbd = new ParamCombo((Composite)group1, 0, "mbd", "mbd", new String[]{"", "0", "1", "rd"});
            this.addParamList(mbd);
            ParamCombo chroma = new ParamCombo((Composite)group1, 0, "chroma", "chroma", new String[]{"", "0", "1"});
            this.addParamList(chroma);
            ParamCombo brdo = new ParamCombo((Composite)group1, 0, "brdo", "brdo", new String[]{"", "0", "1"});
            this.addParamList(brdo);
            ParamCombo slice = new ParamCombo((Composite)group1, 0, "slice", "slice", new String[]{"", "0", "1", "2"});
            this.addParamList(slice);
            ParamCombo subq = new ParamCombo((Composite)group1, 0, "subq", "subq", new String[]{"", "0", "1", "6"});
            this.addParamList(subq);
            ParamCombo sc_threshold = new ParamCombo((Composite)group1, 0, "sc_threshold", "sc_threshold", new String[]{"", "0", "1", "40"});
            this.addParamList(sc_threshold);
            ParamCombo i_qfactor = new ParamCombo((Composite)group1, 0, "i_qfactor", "i_qfactor", new String[]{"", "0", "0.71", "0.71428572"});
            this.addParamList(i_qfactor);
            ParamCombo qmin = new ParamCombo((Composite)group1, 0, "qmin", "qmin", new String[]{"", "0", "1", "3", "7", "10", "23"});
            this.addParamList(qmin);
            ParamCombo qmax = new ParamCombo((Composite)group1, 0, "qmax", "qmax", new String[]{"", "1", "5", "25", "35", "40", "51"});
            this.addParamList(qmax);
            ParamCombo qdiff = new ParamCombo((Composite)group1, 0, "qdiff", "qdiff", new String[]{"", "0", "1", "2", "3", "4"});
            this.addParamList(qdiff);
            ParamCombo loop = new ParamCombo((Composite)group1, 0, "loop", "loop", new String[]{"", "0", "1"});
            this.addParamList(loop);
            ParamCombo qscale = new ParamCombo((Composite)group1, 0, "qscale", "qscale", new String[]{"", "1", "5"});
            this.addParamList(qscale);
            ParamCombo target = new ParamCombo((Composite)group1, 0, "target", "target", new String[]{"", "ntsc-dvd", "dvd", "vcd", "dv"});
            this.addParamList(target);
            ParamCombo profile = new ParamCombo((Composite)group1, 0, "profile", "profile", new String[]{"", "aac_main", "aac_low", "aac_ssr", "aac_ltp"});
            this.addParamList(profile);
            ParamCombo qcomp = new ParamCombo((Composite)group1, 0, "qcomp", "qcomp", new String[]{"", "0", "0.6"});
            this.addParamList(qcomp);
            ParamCombo keyint_min = new ParamCombo((Composite)group1, 0, "keyint_min", "keyint_min", new String[]{"", "0", "1", "25"});
            this.addParamList(keyint_min);
            Group group2 = new Group(advancedComposite, 0);
            group2.setLayout((Layout)new GridLayout(6, false));
            ParamCombo cmp = new ParamCombo((Composite)group2, 0, "cmp", "cmp", new String[]{"", "sad", "sse", "satd", "dct", "psnr", "bit", "rd", "zero", "vsad", "vsse", "sad", "w53", "w97", "dctmax", "chroma"});
            this.addParamList(cmp);
            ParamCombo subcmp = new ParamCombo((Composite)group2, 0, "subcmp", "subcmp", new String[]{"", "sad", "sse", "satd", "dct", "psnr", "bit", "rd", "zero", "vsad", "vsse", "sad", "w53", "w97", "dctmax", "chroma"});
            this.addParamList(subcmp);
            ParamCombo rc_eq = new ParamCombo((Composite)group2, 0, "rc_eq", "rc_eq", new String[]{"", "\"blurCplx^(1-qComp)\""});
            this.addParamList(rc_eq);
            ParamCombo me = new ParamCombo((Composite)group2, 0, "me", "me", new String[]{"", "zero", "full", "log", "phods", "epzs", "x1", "hex", "umh", "iter"});
            this.addParamList(me);
            ParamCombo me_method = new ParamCombo((Composite)group2, 0, "me_method", "me_method", new String[]{"", "0", "1", "8"});
            this.addParamList(me_method);
            ParamCombo me_range = new ParamCombo((Composite)group2, 0, "me_range", "me_range", new String[]{"", "16", "21"});
            this.addParamList(me_range);
            ParamCheckGroup partisions = new ParamCheckGroup(advancedComposite, 0, "partitions", "partitions", new String[]{"parti4x4", "parti8x8", "partp4x4", "partp8x8", "partb8x8"}, 5);
            partisions.setToolTipText("-partitions        <flags> E.V.. macroblock subpartition sizes to consider");
            this.addParamList(partisions);
            Composite advancedComposite2 = new Composite((Composite)tab, 0);
            advancedComposite2.setLayout((Layout)new GridLayout(1, true));
            CTabItem tabItem3 = new CTabItem(tab, 0);
            tabItem3.setText("Advanced2");
            tabItem3.setControl((Control)advancedComposite2);
            ParamCheckGroup flags2 = new ParamCheckGroup(advancedComposite2, 0, "flags2", "flags2", new String[]{"fast", "sgop", "noout", "local_header", "bpyramid", "wpred", "mixed_refs", "dct8x8", "fastpskip", "aud", "brdo", "skiprd", "ivlc", "drop_frame_timecode", "non_linear_q"}, 8);
            this.addParamList(flags2);
            String text2 = "";
            text2 = String.valueOf(text2) + "-flags2            <flags> EDVA.\n";
            text2 = String.valueOf(text2) + "   fast                    E.V.. allow non spec compliant speedup tricks\n";
            text2 = String.valueOf(text2) + "   sgop                    E.V.. strictly enforce gop size\n";
            text2 = String.valueOf(text2) + "   noout                   E.V.. skip bitstream encoding\n";
            text2 = String.valueOf(text2) + "   local_header            E.V.. place global headers at every keyframe instead of in extradata\n";
            text2 = String.valueOf(text2) + "   bpyramid                E.V.. allows B-frames to be used as references for predicting\n";
            text2 = String.valueOf(text2) + "   wpred                   E.V.. weighted biprediction for b-frames (H.264)\n";
            text2 = String.valueOf(text2) + "   mixed_refs              E.V.. one reference per partition, as opposed to one reference per macroblock\n";
            text2 = String.valueOf(text2) + "   dct8x8                  E.V.. high profile 8x8 transform (H.264)\n";
            text2 = String.valueOf(text2) + "   fastpskip               E.V.. fast pskip (H.264)\n";
            text2 = String.valueOf(text2) + "   aud                     E.V.. access unit delimiters (H.264)\n";
            text2 = String.valueOf(text2) + "   brdo                    E.V.. b-frame rate-distortion optimization\n";
            text2 = String.valueOf(text2) + "   skiprd                  E.V.. RD optimal MB level residual skipping\n";
            text2 = String.valueOf(text2) + "   ivlc                    E.V.. intra vlc table\n";
            text2 = String.valueOf(text2) + "   drop_frame_timecode         E.V..\n";
            text2 = String.valueOf(text2) + "   non_linear_q            E.V.. use non linear quantizer\n";
            flags2.setToolTipText(text2);
            Group group_time = new Group(advancedComposite2, 0);
            group_time.setText("Time");
            group_time.setLayout((Layout)new GridLayout(7, false));
            ParamText ss = new ParamText((Composite)group_time, 0, "ss", "start");
            this.addParamList(ss);
            ParamText t = new ParamText((Composite)group_time, 0, "t", "duration");
            this.addParamList(t);
            Group group_crop = new Group(advancedComposite2, 0);
            group_crop.setText("Crop");
            group_crop.setLayout((Layout)new GridLayout(7, false));
            ParamText croptop = new ParamText((Composite)group_crop, 0, "croptop", "croptop");
            this.addParamList(croptop);
            ParamText cropbottom = new ParamText((Composite)group_crop, 0, "cropbottom", "cropbottom");
            this.addParamList(cropbottom);
            ParamText cropleft = new ParamText((Composite)group_crop, 0, "cropleft", "cropleft");
            this.addParamList(cropleft);
            ParamText cropright = new ParamText((Composite)group_crop, 0, "cropright", "cropright");
            this.addParamList(cropright);
            Group group_pad = new Group(advancedComposite2, 0);
            group_pad.setText("Padding");
            group_pad.setLayout((Layout)new GridLayout(7, false));
            ParamText padtop = new ParamText((Composite)group_pad, 0, "padtop", "padtop");
            this.addParamList(padtop);
            ParamText padbottom = new ParamText((Composite)group_pad, 0, "padbottom", "padbottom");
            this.addParamList(padbottom);
            ParamText padleft = new ParamText((Composite)group_pad, 0, "padleft", "padleft");
            this.addParamList(padleft);
            ParamText padright = new ParamText((Composite)group_pad, 0, "padright", "padright");
            this.addParamList(padright);
            ParamCombo padcolor = new ParamCombo((Composite)group_pad, 0, "padcolor", "padcolor", new String[]{"", "000000", "ffffff"});
            this.addParamList(padcolor);
            ParamCheckGroup debug = new ParamCheckGroup(advancedComposite2, 0, "debug", "debug", new String[]{"pict", "rc", "bitstream", "qp", "mv", "dct_coeff", "skip", "startcode", "pts", "er", "mmco", "bugs", "vis_qp", "vis_mb_type"}, 8);
            this.addParamList(debug);
            advancedComposite.setFocus();
            tab.setSelection(0);
            tab.forceFocus();
            this.updateStatus();
            Akj_betasPlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)new PreferenceStoreMonitor());
            int defaultSelect = this.getPreferenceStore().getInt("h264setting.h264_settings_index");
            log.info((Object)("defaultSelect:" + defaultSelect));
            if (this.tableViewer.getTable().getItemCount() > defaultSelect) {
                this.tableViewer.getTable().setSelection(Math.max(0, defaultSelect));
            } else if (this.tableViewer.getTable().getItemCount() > 0) {
                this.tableViewer.getTable().setSelection(0);
            } else {
                log.info((Object)"item is empty");
            }
            this.tableSelectionChanged();
            this.tableViewer.addSelectionChangedListener(new StoreSelect());
            return composite;
        }

        public void updateSettingTable() {
            List list = GenericParametersTableViewer.loadList(Akj_betasPlugin.getDefault().getPreferenceStore().getString("h264setting.h264_settings"));
            this.tableViewer.setGenericParametersList(list);
            if (this.tableViewer.getTable().getItemCount() > 0) {
                this.tableViewer.getTable().setSelection(0);
            }
        }

        public void restoreControl(Control control) {
            IPreferenceStore store = this.getPreferenceStore();
            if (control == this.avisynth) {
                this.avisynth.setSelection(store.getBoolean(String.valueOf(this.getPreferenceKey()) + "." + H264ConvertTabBuilder.AVISYNTH));
            }
        }

        public void selectCombo(CCombo combo, String value) {
            int s = combo.getItemCount();
            int i = 0;
            while (i < s) {
                if (combo.getItem(i).equals(value)) {
                    combo.select(i);
                    break;
                }
                ++i;
            }
        }

        public void storeControl(Control control) {
            IPreferenceStore store = this.getPreferenceStore();
            if (control == this.avisynth) {
                store.setValue(String.valueOf(this.getPreferenceKey()) + "." + H264ConvertTabBuilder.AVISYNTH, this.avisynth.getSelection());
            }
        }

        public String toTime(long bps, long maxMega) {
            String sstring;
            String mstring;
            long bytes = bps / 8L;
            long second = maxMega * 1024L * 1024L / bytes;
            long hour = second / 3600L;
            long min = (second %= 3600L) / 60L;
            long sec = second % 60L;
            String hstring = "" + hour;
            if (hstring.length() < 2) {
                hstring = "0" + hstring;
            }
            if ((mstring = "" + min).length() < 2) {
                mstring = "0" + mstring;
            }
            if ((sstring = "" + sec).length() < 2) {
                sstring = "0" + sstring;
            }
            return String.valueOf(hstring) + ":" + mstring + ":" + sstring;
        }

        public void inconvert(File file) {
            this.ffmpegExecuter.execute(new File[]{file});
        }

        public void beforeConvert() {
            this.ffmpegExecuter = new FFMpegExecuter();
            this.ffmpegExecuter.setExecuteListener(new FFMpegMonitor());
            Map newMap = this.toNewParameterMap();
            GenericParameters setting = new GenericParameters(newMap);
            GenericParametersFFMpegPreference preference = new GenericParametersFFMpegPreference(setting);
            String ffmpegPath = FFMpegUI.getFFmpeg();
            preference.setFfmpegPath(ffmpegPath);
            log.info((Object)preference);
            boolean threads = FFMpegUI.isUseThread();
            if (threads && "h264".equals(preference.getVideoCodec())) {
                preference.setThreads(2);
            }
            this.ffmpegExecuter.setFfmpegPreference(preference);
            this.ffmpegExecuter.setUseAvisynth(this.avisynth.getSelection());
            this.ffmpegExecuter.setIgnoreAvisynthExtensions(new String[0]);
            this.ffmpegExecuter.setSameDirectory(this.samefolder.getSelection());
            this.ffmpegExecuter.setBackup(this.backup.getSelection());
            if (!this.samefolder.getSelection()) {
                this.ffmpegExecuter.setExportDir(this.directoryChooser.getAbsoluteFilePath());
            }
        }

        public void afterConvert() {
        }

        public boolean isCanConvert() {
            String ffmpegPath = FFMpegUI.getFFmpeg();
            if (!FFMpegUtils.isFFMpegAvailable(ffmpegPath)) {
                return false;
            }
            return super.isCanConvert();
        }

        public void cancelConvert() {
            this.ffmpegExecuter.cancel();
        }

        public void updateStatus() {
            if (this.samefolder.getSelection() || this.directoryChooser.getFile() != null) {
                this.setMessage(Messages.getString("dropsomething.drag_folder"));
                this.setCanConvert(true);
            } else {
                this.setErrorMessage(Messages.getString("dropsomething.choose_folder"));
                this.setCanConvert(false);
            }
        }

        public void setMessage(String text) {
            if (this.dragHere != null) {
                this.dragHere.setForeground(new Color(null, 64, 255, 64));
                this.dragHere.setText(text);
            }
        }

        public void setErrorMessage(String text) {
            if (this.dragHere != null) {
                this.dragHere.setForeground(new Color(null, 255, 0, 0));
                this.dragHere.setText(text);
            }
        }

        public IPreferenceStore getPreferenceStore() {
            return Akj_betasPlugin.getDefault().getPreferenceStore();
        }

        public boolean setFocus() {
            return this.tableViewer.getTable().setFocus();
        }

        public class ItemModifyCheck
        implements ParamItemActionListener {
            public void paramItemModified(ParamItem source) {
                boolean modified = false;
                int i = 0;
                while (i < H264ConvertTab.this.paramList.size()) {
                    ParamItem item = (ParamItem)H264ConvertTab.this.paramList.get(i);
                    if (item.isModified()) {
                        modified = true;
                        break;
                    }
                    ++i;
                }
                H264ConvertTab.this.saveSetting.setEnabled(modified);
            }
        }

        public class SelectChanged
        implements ISelectionChangedListener {
            public void selectionChanged(SelectionChangedEvent event) {
                H264ConvertTab.this.tableSelectionChanged();
            }
        }

        public class GenericSave
        implements SelectionListener {
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GenericParameters parameter = H264ConvertTab.this.tableViewer.getCurrentSelection();
                String newName = H264ConvertTab.this.tableViewer.copiedName(parameter);
                GenericParametersSaveDialog dialog = new GenericParametersSaveDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                dialog.setName(newName);
                dialog.setComment(parameter.getComment());
                int ret = dialog.open();
                if (ret == 0) {
                    log.info((Object)("Save:" + dialog.isSaveOverwrite()));
                    Map newMap = H264ConvertTab.this.toNewParameterMap();
                    if (dialog.isSaveOverwrite()) {
                        parameter.setParameters(newMap);
                        parameter.setComment(dialog.getComment());
                    } else {
                        GenericParameters newParam = new GenericParameters(newMap);
                        newParam.setName(dialog.getName());
                        newParam.setComment(dialog.getComment());
                        H264ConvertTab.this.tableViewer.getGenericParameters().add(newParam);
                        H264ConvertTab.this.tableViewer.refresh();
                    }
                    int selection = H264ConvertTab.this.tableViewer.getTable().getSelectionIndex();
                    GenericParameters[] infos = H264ConvertTab.this.tableViewer.getGenericParameters().toArray(new GenericParameters[0]);
                    String newValue = GenericParametersEditor.toStoreString(infos);
                    H264ConvertTab.this.getPreferenceStore().setValue("h264setting.h264_settings", newValue);
                    H264ConvertTab.this.tableViewer.getTable().setSelection(selection);
                    H264ConvertTab.this.tableSelectionChanged();
                }
            }
        }

        public class StoreSelect
        implements ISelectionChangedListener {
            public void selectionChanged(SelectionChangedEvent event) {
                H264ConvertTab.this.getPreferenceStore().setValue("h264setting.h264_settings_index", H264ConvertTab.this.tableViewer.getTable().getSelectionIndex());
            }
        }

        public class PreferenceStoreMonitor
        implements Preferences.IPropertyChangeListener {
            public void propertyChange(Preferences.PropertyChangeEvent event) {
                log.info((Object)event.getProperty());
                if (event.getProperty().equals("h264setting.h264_settings")) {
                    H264ConvertTab.this.updateSettingTable();
                }
            }
        }

        public class SetPSPDir
        implements SelectionListener {
            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent e) {
                File[] roots = File.listRoots();
                int i = roots.length - 1;
                while (i > 0) {
                    File videoFolder;
                    File tmp = new File(roots[i], "PSP");
                    if (tmp.exists() && (videoFolder = new File(roots[i], "VIDEO")).exists()) {
                        H264ConvertTab.this.directoryChooser.setEnabled(true);
                        H264ConvertTab.this.samefolder.setSelection(false);
                        H264ConvertTab.this.directoryChooser.setFile(videoFolder);
                        H264ConvertTab.this.updateStatus();
                    }
                    --i;
                }
            }
        }

        public class SavePreferenceStore
        implements SelectionListener {
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                H264ConvertTab.this.storeControl((Control)e.getSource());
            }
        }

        public class FFMpegMonitor
        implements DirectryBasedExecuterListener {
            public void beforeConvert() {
            }

            public void afterConvert() {
                H264ConvertTab.this.setProgress(0);
            }

            public void startConvert(File file) {
                H264ConvertTab.this.setProgress(0);
                FFMpegFLVParser parser = new FFMpegFLVParser(H264ConvertTab.this.ffmpegExecuter.getFfmpegPreference().getFfmpegPath());
                FLVInfomation info = parser.parseFile(file);
                int guessSize = FFMpegPreference.toKBytes(info.getDuration(), H264ConvertTab.this.ffmpegExecuter.getFfmpegPreference().getVideoBitrate() + H264ConvertTab.this.ffmpegExecuter.getFfmpegPreference().getAudioBitrate());
                log.info((Object)("guessSize:" + guessSize));
                guessSize = (int)((double)guessSize * 1.1);
                H264ConvertTab.this.setProgressMaxBytes(guessSize);
            }

            public void endConvert(File file) {
                H264ConvertTab.this.setProgress(100);
                Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("[complete:h264]" + file.getAbsolutePath() + "\n\n");
                String name = FileNameUtils.getChangedExtensionName(H264ConvertTab.this.ffmpegExecuter.getCurrentOutputFile(), "jpg", true);
                File jpegFile = new File(name);
                ThumbnailManager.makeThumbnail(file, 3, jpegFile);
            }

            public void faildConvert(File file, String message) {
                Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("[faild:h264]" + message + "," + file.getAbsolutePath() + "\n\n");
            }

            public void printProcess(String line) {
                Akj_betasPlugin.getDefault().getProcessPrinter().printError(line);
                if (FFMpegUtils.isProgressString(line)) {
                    H264ConvertTab.this.progressBytes(FFMpegUtils.getProgressSize(line));
                }
            }

            public boolean askOverwrite(File output) {
                return FileOverwriteControler.askOverwrite(H264ConvertTabBuilder.this.fileOverwriteControler, output);
            }
        }
    }
}

