/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.audiotools.spectrogram;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import jp.sourceforge.akjrcp.snack.Spectrogram;
import jp.sourceforge.akjrcp.ui.ProgressMonitor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class SpectrogramPainter {
    private Color[] grays = new Color[256];
    private Display display;
    private ProgressMonitor monitor;
    private int perProgress = 100;

    public ProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public SpectrogramPainter(Display display) {
        this.display = display;
        int i = 0;
        while (i < this.grays.length) {
            this.grays[i] = new Color(null, i, i, i);
            ++i;
        }
    }

    public Image createImage(Spectrogram spectrogram) {
        Image bimage = new Image((Device)this.display, spectrogram.getWidth(), spectrogram.getHeight());
        GC gc = new GC((Drawable)bimage);
        int[] values = spectrogram.getRawInt();
        int sampleVLength = spectrogram.getHeight();
        int i = 0;
        while (i < values.length) {
            if (values[i] > 0) {
                gc.setForeground(this.grays[values[i]]);
                int x = i / sampleVLength;
                int y = sampleVLength - i % sampleVLength;
                gc.drawLine(x, y, x, y);
            }
            if (this.monitor != null && i % (spectrogram.getHeight() * this.perProgress) == 0) {
                if (this.monitor.isCanceled()) {
                    gc.dispose();
                    bimage.dispose();
                    return null;
                }
                this.monitor.worked(this.perProgress);
            }
            ++i;
        }
        return bimage;
    }

    public static int getSampleRate(File file) {
        AudioFormat format = null;
        try {
            format = AudioSystem.getAudioInputStream(file).getFormat();
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (int)format.getSampleRate();
    }

    public static double getDurationSecond(File file) {
        AudioFormat format = null;
        try {
            AudioInputStream input = AudioSystem.getAudioInputStream(file);
            format = input.getFormat();
            return (float)input.getFrameLength() / format.getFrameRate();
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0.0;
    }
}

