/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.registry.EditorRegistry;

class MockMapping
implements IFileEditorMapping {
    private IContentType contentType;
    private String extension;
    private String filename;

    MockMapping(IContentType type, String name, String ext) {
        this.contentType = type;
        this.filename = name;
        this.extension = ext;
    }

    public IEditorDescriptor getDefaultEditor() {
        IEditorDescriptor[] candidates = ((EditorRegistry)PlatformUI.getWorkbench().getEditorRegistry()).getEditorsForContentType(this.contentType);
        if (candidates.length == 0) {
            return null;
        }
        return candidates[0];
    }

    public IEditorDescriptor[] getEditors() {
        return ((EditorRegistry)PlatformUI.getWorkbench().getEditorRegistry()).getEditorsForContentType(this.contentType);
    }

    public IEditorDescriptor[] getDeletedEditors() {
        return new IEditorDescriptor[0];
    }

    public String getExtension() {
        return this.extension;
    }

    public ImageDescriptor getImageDescriptor() {
        IEditorDescriptor editor = this.getDefaultEditor();
        if (editor == null) {
            return WorkbenchImages.getImageDescriptor("IMG_OBJ_FILE");
        }
        return editor.getImageDescriptor();
    }

    public String getLabel() {
        return String.valueOf(this.filename) + '.' + this.extension;
    }

    public String getName() {
        return this.filename;
    }
}

