/* -*- c++ -*- */
#ifndef CDOM_ALL_HANDLER_H__
#define CDOM_ALL_HANDLER_H__

#include <akaxiso/parser/handler.h>
#include <akaxiso/classes/membertype.h>

namespace aka2 {

  class all_handler : public handler {
  public:
    all_handler(const qname& tagname, void *seq, int depth,
		const all_op& sop, 
		parser_context &context);
    
    virtual ~all_handler(){}
    virtual parse_result query_element(const qname &tagname, const attribute_values &attrs, 
				       const global_attributes &gattrs);
    virtual parse_result end_element(const qname &tagname);
    virtual bool parse_entity(const std::string &entity, const global_attributes &gattrs);

    virtual memberpair get_element();
    virtual void receive_child(const memberpair &e);
    virtual bool can_skip();
    virtual void abort();
    
  private:
    parse_result parse_element(const member_type &mtype, const attribute_values &attrs, 
			       const global_attributes &gattrs);
    void *all_;
    const all_op &aop_;
    member_map mmap_;
    member_map::const_iterator current_;
  };

}


#endif
