/* -*- c++ -*- */
#ifndef AKAXISO_PARSER_H__
#define AKAXISO_PARSER_H__

#include <akaxiso/classes/document.h>

namespace aka2 {

  class parser {
    public:
    virtual ~parser(){};
    virtual document parse(std::istream &istm) = 0;  
    virtual document parse(const char *document) = 0;
    virtual document parse(const std::string &document) = 0;
    virtual document parse_stdin() = 0;
    virtual document parse_file(const std::string &filename) = 0; 
    virtual void set_gattrs(global_attributes &gattrs) = 0;
  };


#ifdef USE_XERCESC
  class xerces_parser;
  typedef xerces_parser xml_parser;
#else
  class yggxml_parser;
  typedef yggxml_parser xml_parser;
#endif
}

#endif
