/* -*- c++ -*- */
#ifndef AKAXISO_BASE_IMPL_H__
#define AKAXISO_BASE_IMPL_H__

#include <akaxiso/classes/qname.h>
#include <akaxiso/classes/namespaces.h>
#include <akaxiso/classes/typeinfo.h>
#include <akaxiso/classes/member.h>
#include <akaxiso/classes/traits.h>
#include <akaxiso/classes/membertype.h>

namespace aka2 {
  // For any attributes.
  typedef std::map<qname, std::string, qname_less> attribute_values;


  // For typed attributes.
  template<class L, class T>
  class  attributes {
  public:
    struct attribute {
      template<class P, class V>
      attribute(const char *tagname, V P::*member) {
      	new_attribute(tagname, member, xiso::leaf<V>());
      }
      template<class P, class V, class VL>  
      attribute(const char *tagname, V P::* member, const VL&) {
	      new_attribute(tagname, member, VL());
      }

      void set_default(const char *defval) {
      	// Don't have to think of value types other than simpletype,
      	attr_.set_default(defval);
      };
      void set_use(attribute_use use) {	attr_.set_use(use); }
    private:
      template<class P, class V, class VL>
      void new_attribute(const char *tagname, V P::*member, const VL&) {
      	VL::initialize();

      	qname name(tagname);
	
    	  member_getter *op = 
	        create_c_style_attribute_getter(&VL::dispatcher_, 
						   reinterpret_cast<T*>(0), member);
	      attr_ = aka2::attribute_type(op); 
	      attr_.set_name(tagname);
	
      	default_op *defop = VL::create_default_op();
      	if (defop != 0)
	        attr_.set_default_op(defop);
      	L::attribute_types_.insert(attribute_types::value_type(name, attr_));
      }

      attribute_type attr_;
    };

    static attribute_types attribute_types_;
  };
  
  template<class L, class T>
  attribute_types attributes<L, T>::attribute_types_;


}


#endif


