// -*- c++ -*-
#ifndef AKAXISO_ALL_H__
#define AKAXISO_ALL_H__

#include <akaxiso/classes/simpletype.h>
#include <akaxiso/classes/attribute.h>
#include <akaxiso/classes/closure.h>
#include <akaxiso/classes/type_registory.h>
#include <akaxiso/classes/ptrmember.h>

#include <vector>

namespace aka2 {


  template<class L>
  class all_op_dispatcher : public all_op {
  public:
    virtual schematype_id get_schematype() const { return all_id; }
    virtual const typeinfo& get_typeinfo() const { return L::typeinfo_; }
    /** creatable */
    virtual void* create() const { return L::create(); }
    virtual void destroy(void *elm) const { L::destroy(elm); }
    virtual bool equals(const void *lhs, const void *rhs) const {
      return L::equals(lhs, rhs);
    }
    virtual void copy(void *dest, const void *src) const {
      L::copy(dest, src);
    }

    /** attribute_info getter. */
    virtual const attribute_types *get_attribute_types() const { 
      return &L::attribute_types_; 
    }
    /** all_info getter. */
    virtual const member_map &get_member_map() const {
      return L::member_map_;
    }
  };


  template<class T, class L=xiso::leaf<T> >
  class all : public attributes<L, T>  {
  public:
    typedef T value_type;

    virtual ~all(){}

    static member_type* register_membertype(const member_type &mtype) { 
      std::pair<member_map::iterator, bool> res = 
    	member_map_.insert(member_map::value_type(mtype.get_name(), mtype)); 
      if (!res.second)
	      throw internal_error();
      return &res.first->second;
    } 

    static void initialize() {
      if (!system_type_registory().add(L()))
      	return;
      member_map_.clear();
      attribute_types_.clear();
      L l; l.model(); // VC6 does not accept L().model();
    }

    static void uninitialize() {
      member_map_.clear();
      attribute_types_.clear();
    }

    static T* create() { 
      T* t = new T;
      all_construct(t, dispatcher_);
      return t;
    }
    static void destroy(void *elm) { 
      all_destruct(elm, dispatcher_);
      delete static_cast<T*>(elm); 
    }
    static bool equals(const void *lhs, const void *rhs) {
      return all_equals(lhs, rhs, dispatcher_);
    }
    static void copy(void *dest, const void *src) {
      all_copy(dest, src, dispatcher_);
    }

    static element_op* get_attribute_dispatcher() { return &dispatcher_; } 
    static default_op* create_default_op() { return 0; }

    static member_map member_map_;
    static typeinfo typeinfo_;
    static all_op_dispatcher<L> dispatcher_;

    // Helper class to define serializable member.
    struct _member {
      template<class P, class V> 
      _member(const char *tagname, V P::* m) {
      	new_member(tagname, m, xiso::leaf<V>());
      }
      template<class P, class V, class VL> 
      _member(const char *tagname, V P::* m, const VL&) {
      	new_member(tagname, m, VL());
      }
      void set_default(const char *defval) {
	      if (mtype_->get_schematype() != simpletype_id)
	        throw internal_error();
      	mtype_->set_default(defval);
      }
      member_type *mtype_;

    private:
      template<class P, class V, class VL> 
      void new_member(const char *tagname, V P::* m, const VL&) {
      	VL::initialize();
	      member_getter *op = 
	        create_c_style_getter(&VL::dispatcher_, reinterpret_cast<T*>(0), m);	  
	      member_type mtype(op);
	      mtype.set_name(tagname);
	      mtype_ = L::register_membertype(mtype);

        default_op *defop = VL::create_default_op();
      	if (defop != 0)
	        mtype_->set_default_op(defop);
      }
    };

    typedef _member member;

    struct _ptrmember {
      template<class P, class V> 
      _ptrmember(const char *tagname, V* P::* m) {
	      new_ptr_member(tagname, m, xiso::leaf<V>());
      }
      template<class P, class V, class VL>
      _ptrmember(const char *tagname, V* P::* m, const VL&) {
      	new_ptr_member(tagname, m, VL());
      }
      void required(bool val) {
      	if (val)
	        mtype_->set_occurence(aka2::occurence(1, 1));
      	else
	        mtype_->set_occurence(aka2::occurence(0, 1));
      }
      member_type *mtype_;

    private:
      template<class P, class V, class VL> 
      void new_ptr_member(const char *tagname, V* P::* m, const VL&) {
	      VL::initialize();
	      member_getter *op = 
          create_c_style_getter(&aka2::ptrmember<V, VL>::dispatcher_, reinterpret_cast<T*>(0), m);	  
	      member_type mtype(op);
	      mtype.set_name(tagname);
	      mtype_ = L::register_membertype(mtype);

        default_op *defop = VL::create_default_op();
      	if (defop != 0)
	        mtype_->set_default_op(defop);
      }
    };

    typedef _ptrmember ptrmember; // VC6 workadound.

    static void xmltype(const char *name) {
      typeinfo_.set_name(qname(name));
    }
  };
  
  template<class T, class L>
  member_map all<T, L>::member_map_;

  template<class T, class L>
   typeinfo all<T, L>::typeinfo_;

  template<class T, class L>
  all_op_dispatcher<L> all<T, L>::dispatcher_;

}

#endif
