/*
 * AJD4JP
 * Copyright (c) 2011-2012  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に
 * 同意できる場合にのみ利用可能です。
 */
package ajd4jp.orrery;

import ajd4jp.orrery.tool.*;
import java.math.*;


/**
 * 惑星。ただし便宜上、太陽等もここに含みます。
 */
public enum Planet {
	/** 太陽系の重力中心点 */
	SOLAR_SYSTEM_BARYCENTER( null, "太陽系の重力中心点", false ),
	/** 太陽 */
	SUN( JPLItem.SUN, "太陽", true ),
	/** 水星 */
	MERCURY( JPLItem.MERCURY, "水星", true ),
	/** 金星 */
	VENUS( JPLItem.VENUS, "金星", true ),
	/** 地球 */
	EARTH( null, "地球", true ),
	/** 地球と月の重力中心点。 */
	EARTH_MOON_BARYCENTER( JPLItem.EARTH_MOON_BARYCENTER, "地球と月の重力中心点", false ),
	/** 月 */
	MOON( JPLItem.MOON, "月", true ),
	/** 火星 */
	MARS( JPLItem.MARS, "火星", true ),
	/** 木星 */
	JUPITER( JPLItem.JUPITER, "木星", true ),
	/** 土星 */
	SATURN( JPLItem.SATURN, "土星", true ),
	/** 天王星 */
	URANUS( JPLItem.URANUS, "天王星", true ),
	/** 海王星 */
	NEPTUNE( JPLItem.NEPTUNE, "海王星", true ),
	/** 冥王星 */
	PLUTO( JPLItem.PLUTO, "冥王星", true );

	JPLItem	item;
	private String	jp_name;
	private boolean body_f;
	private Planet( JPLItem p, String jp, boolean b_f ) {
		item = p;
		jp_name = jp;
		body_f = b_f;
	}
	/**
	 * 惑星の日本語名を返します。
	 * @return 惑星名。
	 */
	public String getJpName() {
		return jp_name;
	}
	/**
	 * 天体であるか？<br>
	 * これが false のものは重力中心点です。
	 * @return true:天体、false:天体ではない。
	 */
	public boolean isBody() {
		return body_f;
	}
}

