#!/bin/sh

#///////////////////////////////////////////////
#  設定に必要な変数をセット
#///////////////////////////////////////////////
aipo_version="6.0.0.0"

#ユーザ確認
current_user=`whoami`
if [ "${current_user}" != "root" ]; then
    echo "Aipo$aipo_versionのインストールはroot権限で行ってください。"
    exit 0
fi

#カレントディレクトリ
echo ${enc_str}
len=`expr match $0 \\\/.*`
#echo $len
if [ $len -gt 0 ]; then
	script_path=$0
else
	script_path=`pwd`/$0
fi
echo ${script_path} | sed "s/\/bin\/${enc_str}//g" >> temp.txt
script_path=`cat temp.txt`
rm -rf temp.txt
len=`expr match ${script_path} .*\\\/ - 1`
script_path=`expr substr ${script_path} 1 $len`
echo "install directory is ${script_path}"

. ${script_path}/bin/install.conf

addr=""
if [ -e /etc/sysconfig/network-scripts/ifcfg-${netitf} ]; then
	. /etc/sysconfig/network-scripts/ifcfg-${netitf}
	addr=$IPADDR
fi

if [ "$addr" = "" ]; then
	addr=`ifconfig ${netitf} | grep "inet addr" | cut -f 2 -d :| cut -f 1 -d " "`
fi

if [ "$addr" = "" ]; then
	addr=`ifconfig eth0 | grep "inet addr" | cut -f 2 -d :| cut -f 1 -d " "`
fi

if [ "$addr" = "" ]; then
	addr=${def_addr}
fi

# 最大ループ回数
Max_Loop="100"
# インストールフォルダ
aipo_dir=${script_path}
# PostgreSQL用ユーザのセット
postgres_user="aipo_postgres"
# ポート番号の初期値
port_num="5432"
# PostgreSQLバージョンをセット
postgres_ver="postgresql-8.4.7"
# PostgreSQLファイル名をセット
postgres_file=$postgres_ver".tar.gz"
# PostgreSQLのドライバファイル名
postgres_driver_file="postgresql-8.4-702.jdbc4.jar"
# ソースディレクトリ
src_dir=$aipo_dir"/src"

#///////////////////////////////////////////////
# prevent duplicate install 
#///////////////////////////////////////////////

tomcat_install_evidence="${script_path}/tomcat/lib/${postgres_driver_file}"
postgres_install_evidence="${script_path}/postgres/data/postmaster.opts"

if [ -f $tomcat_install_evidence -a -f $postgres_install_evidence ]; then
        echo "aipoは既にインストールされています。" 
        exit
fi

#///////////////////////////////////////////////
# すでにPosgreSQL用のユーザが存在するか
#///////////////////////////////////////////////
unset tmp_str
tmp_str=`grep ${postgres_user} /etc/passwd`
tmp_user=${postgres_user}
count=0
# すでにPosgreSQL用のユーザが作成されていた場合
tmp_user=${postgres_user}
while [ 1 ]; do
	# すでにPosgreSQL用のユーザが作成されていた場合の処理を記述
	tmp_str=`grep $tmp_user /etc/passwd`
	if [ "$tmp_str" != "" ];
	then
		tmp_user=${postgres_user}$count
		unset tmp_str
	else
		break
	fi
	count=`expr $count + 1`
	# ループ回数が指定回数を上回ったら強制ブレーク（テスト用）
	if [ $count -ge $Max_Loop ]; then
		echo "ユーザー名生成中にエラーが発生しました"
		exit 0
	fi
done
postgres_user=$tmp_user
echo $tmp_user

#///////////////////////////////////////////////
#乱数でPostgreSQLパスワード生成
#///////////////////////////////////////////////

str_seed1="abcdefghijklmnopqrstuvwxyz"
str_seed2="ABCDEFGHIJKLMNOPQRSTUVWXYZ"
str_seed3="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"
str_seed4="0123456789"
str_seed5="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"

pass=""
count=0
while [ $count -lt 1 ]; do
	ran=`expr $RANDOM % 26 + 1`
	char=`expr substr $str_seed1 $ran 1`
	pass=$pass$char
	count=`expr $count + 1`
done
count=0
while [ $count -lt 2 ]; do
	ran=`expr $RANDOM % 10 + 1`
	char=`expr substr $str_seed4 $ran 1`
	pass=$pass$char
	count=`expr $count + 1`
done
count=0
while [ $count -lt 4 ]; do
	ran=`expr $RANDOM % 62 + 1`
	char=`expr substr $str_seed5 $ran 1`
	pass=$pass$char
	count=`expr $count + 1`
done
count=0
while [ $count -lt 3 ]; do
	ran=`expr $RANDOM % 26 + 1`
	char=`expr substr $str_seed2 $ran 1`
	pass=$pass$char
	count=`expr $count + 1`
done
count=0
while [ $count -lt 2 ]; do
	ran=`expr $RANDOM % 52 + 1`
	char=`expr substr $str_seed3 $ran 1`
	pass=$pass$char
	count=`expr $count + 1`
done

#///////////////////////////////////////////////
#PostgreSQL用アカウント追加
#///////////////////////////////////////////////
unset tmp_str
tmp_str=`grep ${postgres_user} /etc/group`
if [ "${tmp_str}" != "" ]; then
		echo "group ${postgres_user} exists."
	else
		groupadd ${postgres_user}
fi

useradd ${postgres_user} -g ${postgres_user}

echo ${postgres_user}:$pass | chpasswd
if [ -d /home/${postgres_user} ]; then
	echo "home directory exists"
else
	mkdir -p /home/${postgres_user}
	if [ -s  /etc/skel/.bashrc ]; then
		cp /etc/skel/.bashrc /home/${postgres_user}/
	else
		touch /home/${postgres_user}/.bashrc
	fi
	if [ -s /etc/skel/.bash_profile ]; then
		cp /etc/skel/.bash_profile /home/${postgres_user}/
	else
		touch /home/${postgres_user}/.bash_profile
	fi

	chown ${postgres_user}:${postgres_user} /home/${postgres_user}/.bashrc
	chown ${postgres_user}:${postgres_user} /home/${postgres_user}/.bash_profile
fi
chown ${postgres_user}:${postgres_user} /home/${postgres_user}

#///////////////////////////////////////////////
#簡易チェック
#///////////////////////////////////////////////
check_str="AIPO_INSTALL_OK"

if [ -s ~/.bashrc ]; then
	echo "checking bashrc... file exists"
else
	if [ -s  /etc/skel/.bashrc ]; then
		echo "copying .bashrc from /etc/skel diectory"
		cp /etc/skel/.bashrc ~/
	else
		echo "checking bashrc...  file does not exists"
		touch ~/.bashrc
		#check_str="ERROR"
	fi
fi

if [ -s ~/.bash_profile ]; then
	echo "checking bash_profile... file exists"
else
	if [ -s  /etc/skel/.bash_profile ]; then
		echo "copying .bash_profile from /etc/skel diectory"
		cp /etc/skel/.bash_profile ~/
	else
		echo "checking .bash_profile...  file does not exists"
		touch ~/.bash_profile
		#check_str="ERROR"
	fi
fi

sudo -u ${postgres_user} ls ${script_path}
tmp_str=$?

if [ "$tmp_str" = "0" ]; then
	echo "checking permissions... ok"
else
	echo "checking permissions... ERROR invalid permissions"
	echo "${postgres_user} は ${script_path} にアクセスできません。"
	check_str="ERROR"
fi

gcc --version
tmp_str="$?"
if [ "$tmp_str" != "1" ]; then
	if [ "$tmp_str" != "0" ]; then
		echo "checking gcc... error"
		echo "gccが見つかりませんでした。"
		echo "gccをインストールしてください。"
		check_str="ERROR"
	else
		echo "checking gcc... ok"
	fi
else
	echo "checking gcc... "
fi

rpm -qa --qf "%{GROUP},%{NAME}\n" > ${script_path}/bin/rpmlist

tmp_str=`cat ${script_path}/bin/rpmlist | grep readline-devel`

if [ "$tmp_str" != "" ]; then
	echo "checking readline... ok"
else
	echo "checking readline... error"
	echo "readline-develが見つかりませんでした。"
	echo "readline-develをインストールしてください。"
	check_str="ERROR"
fi

tmp_str=`cat ${script_path}/bin/rpmlist | grep zlib-devel`
if [ "$tmp_str" != "" ]; then
        echo "checking zlib... ok"
else
        echo "checking zlib... error"
	echo "zlib-develが見つかりませんでした。"
	echo "zlib-develをインストールしてください。"
        check_str="ERROR"
fi

tmp_str=`cat ${script_path}/bin/rpmlist | grep nmap`
if [ "$tmp_str" != "" ]; then
        echo "checking nmap... ok"
else
        echo "checking nmap... error"
	echo "nmapが見つかりませんでした。"
	echo "nmapをインストールしてください。"
        check_str="ERROR"
fi


if [ "$check_str" != "AIPO_INSTALL_OK" ]; then
	if [ "${check_pass}" != "true" ]; then
		echo "Aipo$aipo_versionのインストールに失敗しました"
		userdel -r ${postgres_user}
		groupdel ${postgres_user}
		exit 0
	fi
fi

#///////////////////////////////////////////////
#環境変数の追加
#///////////////////////////////////////////////
cp -f "$HOME/.bash_profile" "$HOME/.bash_profile~"
tmp_str=`grep '$JAVA_HOME' $HOME/.bash_profile`
if [ `expr length "$tmp_str"` -eq 0 ]; then
	`echo 'export JAVA_HOME='$aipo_dir'/jre' >> "$HOME/.bash_profile"`
	`echo 'export PATH="$PATH":$JAVA_HOME/bin' >> "$HOME/.bash_profile"`
else
	echo $tmp_str
fi

#///////////////////////////////////////////////
#  他のPostgreSQLが使用していないポート番号を取得
#///////////////////////////////////////////////
echo "Checking other SQL settings..."

unset tmp_str
flag_1="0"
count="0"
while [ 1 ]; do
	unset tmp_str
	nmap -p $port_num localhost | grep open > /dev/null
	if [ $? = 0 ]; then
		flag_2="0"
	else
		unset tmp_str
		tmp_str=`grep -x "$port_num" $aipo_dir/bin/servlist`
			if [ "$tmp_str" != "$port_num" ]; then
			break
		fi
	fi

	# カウンタを更新
	count=`expr $count + 1`
	port_num=`expr $port_num + $count`

	if [ $count -ge $Max_Loop ]; then
		echo "ポート番号検出中にエラーが発生しました"
		exit 0
	fi
done

#///////////////////////////////////////////////
#PostgreSQL のディレクトリ設定
#///////////////////////////////////////////////
instl_dir=$aipo_dir"/postgres"
# データベース用ディレクトリ設定
db_dir_data=$instl_dir"/data"
db_dir_initdb=$instl_dir"/bin/initdb"

# ディレクトリ設定
test -d $instl_dir
tmp_str=$?
if [ $tmp_str = 0 ]; then
	# 既にディレクトリがある場合
	echo "directory exist"
else
	# ディレクトリがない場合
	#mkdir $aipo_dir
	mkdir -p $instl_dir
fi

#//////////////////////////////////////////////////
# delete PostgreSQL tmp file, lock file if exsists
#//////////////////////////////////////////////////

tmp_file=/tmp/.s.PGSQL.$port_num
lock_file=/tmp/.s.PGSQL.$port_num.lock

if [ -e $tmp_file ]; then 
  rm -f $tmp_file
fi

if [ -f $lock_file ]; then 
  rm -f $lock_file
fi

#///////////////////////////////////////////////
#PostgreSQLのインストール
#///////////////////////////////////////////////

# ディレクトリ指定
cd $src_dir
tar zxvf $src_dir/$postgres_file

cd $src_dir/$postgres_ver
chown -R ${postgres_user}:${postgres_user} $instl_dir

# PostgreSQL用のユーザ権限でコンパイル
sudo -u ${postgres_user} ./configure --prefix=$instl_dir --enable-multibyte=UTF8 --with-pgport=$port_num

failure=$?
if [ "$failure" != "0" ]; then
	echo "Aipo$aipo_versionのインストールに失敗しました"
	userdel -r ${postgres_user}
	exit 0
fi

sudo -u ${postgres_user} make all

# インストール
make install

#///////////////////////////////////////////////
#  PostgreSQL の initdb
#///////////////////////////////////////////////
mkdir -p $db_dir_data
chown ${postgres_user}:${postgres_user} $db_dir_data
rm -rf $db_dir_data/*
sudo -u ${postgres_user} $db_dir_initdb --encoding=UTF8 --no-locale --pgdata=$db_dir_data

#confファイル書き換え
tmp_str=`grep "#port =" $db_dir_data/postgresql.conf`
echo $tmp_str

chown ${postgres_user}:${postgres_user} $db_dir_data/postgresql.conf
sudo -u ${postgres_user} sed -i "s/$tmp_str/port = $port_num/g" $db_dir_data/postgresql.conf

ls -la $db_dir_data

#///////////////////////////////////////////////
#  環境変数の設定
#///////////////////////////////////////////////
path_str1='export PATH='$instl_dir'/bin:"$PATH"'
path_str2='export POSTGRES_HOME='$instl_dir''
path_str3='export PGLIB=$POSTGRES_HOME/lib'
path_str4='export PGDATA=$POSTGRES_HOME/data'
path_str5='export MANPATH="$MANPATH":$POSTGRES_HOME/man'
path_str6='export LD_LIBRARY_PATH=/usr/local/lib:"$LD_LIBRARY_PATH":"$PGLIB"'
# .bash_profileのバックアップ
sudo -u ${postgres_user} cp /home/${postgres_user}/.bash_profile /home/${postgres_user}/.bash_profile~
# 各環境変数の設定
sudo -u ${postgres_user} echo $path_str1 >> /home/${postgres_user}/.bash_profile
sudo -u ${postgres_user} echo $path_str2 >> /home/${postgres_user}/.bash_profile
sudo -u ${postgres_user} echo $path_str3 >> /home/${postgres_user}/.bash_profile
sudo -u ${postgres_user} echo $path_str4 >> /home/${postgres_user}/.bash_profile
sudo -u ${postgres_user} echo $path_str5 >> /home/${postgres_user}/.bash_profile
sudo -u ${postgres_user} echo $path_str6 >> /home/${postgres_user}/.bash_profile
# .bash_profileを再読み込み
#sudo -u ${postgres_user} source /home/${postgres_user}/.bash_profile

#PostgreSQLの起動
sudo -u ${postgres_user} $aipo_dir/postgres/bin/postmaster -D $aipo_dir/postgres/data -i &
prc_name="$aipo_dir/postgres/bin/postmaster"
count=0
while [ $count -lt $Max_Loop ]; do
	tmp_str=`ps auxww | grep $prc_name`
	tmp_str=`echo $tmp_str`
	pid_str=`echo "$tmp_str" | cut -f 2 -d " "`
	tmp_str=`netstat -nap | grep "ESTABLISHED $pid_str"`
	if [ "$tmp_str" != "" ]; then
		echo $tmp_str
		break
	fi
	count=`expr $count + 1`
done

#///////////////////////////////////////////////
#jre ファイル解凍
#///////////////////////////////////////////////
unset tmp_str
tmp_str=`test -d $aipo_dir/jre`
if [ !tmp_str = 0 ]; then
	rm -rf $aipo_dir/jre
fi

cd  $aipo_dir
tar zxvf $src_dir"/jre.tar.gz"

#///////////////////////////////////////////////
#Tomcat のインストール
#///////////////////////////////////////////////
unset tmp_str
tmp_str=`test -d $aipo_dir/tomcat`
if [ !tmp_str = 0 ]; then
	rm -rf $aipo_dir/tomcat
fi

cd  $aipo_dir
tar zxvf $src_dir"/apache-tomcat-6.0.32.tar.gz"
mv -f apache-tomcat-6.0.32 tomcat

#///////////////////////////////////////////////
#Tomcatの設定
#///////////////////////////////////////////////

#///////////////////////////////////////////////
# OverWritte some files
#///////////////////////////////////////////////

tomcat_diff_dir="$src_dir/tomcat_diff"

cp -rf $tomcat_diff_dir/* $aipo_dir/tomcat/

#///////////////////////////////////////////////
# ポート検出
#///////////////////////////////////////////////
unset tmp_str
s_port_num=80
flag_1="0"
count="0"
while [ 1 ]; do
	unset tmp_str
	nmap -p $s_port_num localhost | grep open > /dev/null
	if [ $? = 0 ]; then
		flag_2="0"
	else
		unset tmp_str
		tmp_str=`grep -x "$s_port_num" $aipo_dir/bin/servlist`
			if [ "$tmp_str" != "$s_port_num" ]; then
			break
		fi
	fi

	# カウンタを更新
	count=`expr $count + 1`
	s_port_num=`expr $s_port_num + $count`

	if [ $count -ge $Max_Loop ]; then
		echo "ポート番号検出中にエラーが発生しました"
		exit 0
	fi
done
sed -i "s/port=\"8080\"/port=\"$s_port_num\"/g" $aipo_dir/tomcat/conf/server.xml
Apr_Str='<Listener className="org.apache.catalina.core.AprLifecycleListener" \/>'
sed -i "s/$Apr_Str/<!--$Apr_Str-->/g" $aipo_dir/tomcat/conf/server.xml

#///////////////////////////////////////////////

unset tmp_str
sd_port_num=8005
flag_1="0"
count="0"
while [ 1 ]; do
	unset tmp_str
	nmap -p $sd_port_num localhost | grep open > /dev/null
	if [ $? = 0 ]; then
		flag_2="0"
	else
		unset tmp_str
		tmp_str=`grep -x "$sd_port_num" $aipo_dir/bin/servlist`
			if [ "$tmp_str" != "$sd_port_num" ]; then
			break
		fi
	fi

	# カウンタを更新
	count=`expr $count + 1`
	sd_port_num=`expr $sd_port_num + $count`

	if [ $count -ge $Max_Loop ]; then
		echo "ポート番号検出中にエラーが発生しました"
		exit 0
	fi
done
sed -i "s/port=\"8005\"/port=\"$sd_port_num\"/g" $aipo_dir/tomcat/conf/server.xml
#///////////////////////////////////////////////

echo 'CATALINA_OPTS="-server -Xmx512M -Xms64M -Xss256k -Djava.awt.headless=true"' >> $aipo_dir/tomcat/bin/catalina.sh

#最後の行にタイムゾーン設定を追加する
echo 'user.timezone=Asia/Tokyo' >> $aipo_dir"/tomcat/conf/catalina.properties"

#///////////////////////////////////////////////
# Aipoのインストール
#///////////////////////////////////////////////

rm -rf "$aipo_dir"/tomcat/webapps/*
cp -rf "$aipo_dir"/src/webapps/* "$aipo_dir"/tomcat/webapps/
cp -rf "$aipo_dir"/src/"$postgres_driver_file" "$aipo_dir"/tomcat/lib
cp -rf "$aipo_dir"/src/tools.jar "$aipo_dir"/tomcat/lib

#ファイル書き換え
sed -i "s/localhost:5432/localhost:$port_num/g" $aipo_dir/tomcat/webapps/aipo/WEB-INF/datasource/dbcp-org001.properties
sed -i "s/cayenne.dbcp.password=aipo/cayenne.dbcp.password=$pass/g" $aipo_dir/tomcat/webapps/aipo/WEB-INF/datasource/dbcp-org001.properties
sed -i "s/cayenne.dbcp.username=postgres/cayenne.dbcp.username=${postgres_user}/g" $aipo_dir/tomcat/webapps/aipo/WEB-INF/datasource/dbcp-org001.properties

sed -i "s/localhost:5432/localhost:$port_num/g" $aipo_dir/tomcat/webapps/ROOT/WEB-INF/datasource/dbcp-org001.properties
sed -i "s/cayenne.dbcp.password=aipo/cayenne.dbcp.password=$pass/g" $aipo_dir/tomcat/webapps/ROOT/WEB-INF/datasource/dbcp-org001.properties
sed -i "s/cayenne.dbcp.username=postgres/cayenne.dbcp.username=${postgres_user}/g" $aipo_dir/tomcat/webapps/ROOT/WEB-INF/datasource/dbcp-org001.properties

sed -i "s/aipo.webappserver.port=8080/aipo.webappserver.port=${s_port_num}/g" $aipo_dir/tomcat/webapps/aipo/WEB-INF/conf/AipoResources.properties

#データベース初期化とデータ登録
cp -rf $aipo_dir/src/initdata/psml $aipo_dir/tomcat/webapps/aipo/WEB-INF
cp -rf $aipo_dir/src/initdata/files $aipo_dir/tomcat/webapps/aipo/WEB-INF
cp -rf $aipo_dir/src/initdata/mail $aipo_dir/tomcat/webapps/aipo/WEB-INF

sed -i "s/aipo_postgres/${postgres_user}/g" $aipo_dir/src/initdata/sql/org001.sql
sed -i "s/aipo_postgres/${postgres_user}/g" $aipo_dir/src/initdata/sql/sample.sql

#db作成
sudo -u ${postgres_user} $aipo_dir/postgres/bin/createdb org001 -O ${postgres_user} -U ${postgres_user}
#db初期化
sudo -u ${postgres_user} $aipo_dir/postgres/bin/psql -U ${postgres_user} -d org001 -p $port_num -f $aipo_dir/src/initdata/sql/org001.sql
#サンプルデータ挿入
sudo -u ${postgres_user} $aipo_dir/postgres/bin/psql -U ${postgres_user} -d org001 -p $port_num -f $aipo_dir/src/initdata/sql/sample.sql
#port番号挿入
sudo -u ${postgres_user} $aipo_dir/postgres/bin/psql -U ${postgres_user} -d org001 -p $port_num -c "UPDATE EIP_M_COMPANY SET PORT_INTERNAL=${s_port_num}"
#ユーザー無制限
sudo -u ${postgres_user} $aipo_dir/postgres/bin/psql -U ${postgres_user} -d org001 -p $port_num -c "UPDATE AIPO_LICENSE SET LIMIT_USERS=0"


#pg_hba.conf書き換え
cp $db_dir_data/pg_hba.conf $db_dir_data/pg_hba.conf~
sudo -u ${postgres_user} echo "alter user ${postgres_user} with password '$pass';" | $aipo_dir/postgres/bin/psql -U ${postgres_user} -d org001 -p $port_num

chown ${postgres_user}:${postgres_user} $db_dir_data/pg_hba.conf
sudo -u ${postgres_user} sed -i "s/ trust/ password/g" $db_dir_data/pg_hba.conf

sudo -u ${postgres_user} echo "localhost:$port_num:org001:${postgres_user}:$pass" > /home/${postgres_user}/.pgpass
chown ${postgres_user}:${postgres_user} /home/${postgres_user}/.pgpass
sudo -u ${postgres_user} chmod 0600 /home/${postgres_user}/.pgpass


#securityTokenKey作成
seed="0123456789abcdefghijklmnopqrstuvwxyz"
key=""
count=0
while [ $count -lt 128 ]; do
        ran=`expr $RANDOM % 36 + 1`
        char=`expr substr $seed $ran 1`
        key=$key$char
        count=`expr $count + 1`
done
echo -n $key > $aipo_dir/tomcat/webapps/aipo/WEB-INF/conf/securityTokenKey.txt
echo -n $key > $aipo_dir/tomcat/webapps/ROOT/WEB-INF/classes/aipo/securityTokenKey.txt


#///////////////////////////////////////////////
#システム設定
#///////////////////////////////////////////////
# タイムゾーンの設定
export TZ=JST-9
#再起動後にUTCに戻ってしまうので以下を実行する
date=`date '+%Y%m%d'`
mv /etc/localtime /etc/localtime."2011/4/12".bak
cp /usr/share/zoneinfo/Japan /etc/localtime

#///////////////////////////////////////////////
#xregファイルのバックアップ
cp -f $aipo_dir/tomcat/webapps/aipo/WEB-INF/conf/*.xreg  $aipo_dir/backup/xreg

#///////////////////////////////////////////////
#実行用スクリプト生成
#///////////////////////////////////////////////
echo "$aipo_dir" | sed s/'\/'/'\\\/'/g > temp.txt
tmp_str=`cat temp.txt`
rm -rf temp.txt
echo $tmp_str

cd $src_dir/bin/$enc_str
for FILE in *.sh; do
	sed "s/default_folder/$tmp_str/g" $FILE | sed "s/default_user/${postgres_user}/g" | sed "s/default_server_port/$s_port_num/g" | sed "s/default_db_port/$port_num/g" | sed "s/postgres_pass/$pass/g" | sed "s/Aipo_Version/$aipo_version/g" > $aipo_dir/bin/$FILE
done

chmod +x $aipo_dir/bin/*.sh

#///////////////////////////////////////////////
#終了処理
#///////////////////////////////////////////////
rm -rf "$aipo_dir/tomcat/conf/Catalina/localhost/balancer.xml"

#wait
sudo -u ${postgres_user} $aipo_dir/postgres/bin/pg_ctl -D $aipo_dir/postgres/data -o "-i -p $port_num" stop
#wait

#///////////////////////////////////////////////
#結果表示
#///////////////////////////////////////////////

echo ==Aipo"$aipo_version"インストール終了==
echo user:${postgres_user}
echo pass:$pass
echo directory:$instl_dir
echo port:$port_num
echo "Aipo URL: http://$addr:$s_port_num/aipo/"