/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2008 Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.workflow;

import java.util.ArrayList;
import java.util.List;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.util.ALEipUtils;

/**
 * ワークフローのResultDataです。 <BR>
 * 
 */
public class WorkflowDetailResultData extends WorkflowResultData {

  /** Parent ID */
  private ALNumberField parent_id;

  /** ユーザーID */
  private ALNumberField user_id;

  /** メモ */
  private ALStringField note;

  /** 更新日 */
  private ALStringField update_date;

  /** 決裁情報 */
  private List drlist;

  /** 過去の申請内容のリンク一覧 */
  private List oldrequestLinks;

  /**
   * 
   * @see com.aimluck.eip.common.ALData#initField()
   */
  public void initField() {
    super.initField();
    parent_id = new ALNumberField();
    user_id = new ALNumberField();
    note = new ALStringField();
    note.setTrim(false);
    update_date = new ALStringField();
    drlist = new ArrayList();
    oldrequestLinks = new ArrayList();
  }

  /**
   * @return
   */
  public ALNumberField getParentId() {
    return parent_id;
  }

  /**
   * @return
   */
  public ALNumberField getUserId() {
    return user_id;
  }

  /**
   * @return
   */
  public String getNote() {
    return ALEipUtils.getMessageList(note.getValue());
  }

  public List getDecisionRecords() {
    return drlist;
  }

  public List getOldRequestLinks() {
    return oldrequestLinks;
  }

  /**
   * @param i
   */
  public void setParentId(long i) {
    parent_id.setValue(i);
  }

  /**
   * @param i
   */
  public void setUserId(long i) {
    user_id.setValue(i);
  }

  /**
   * @param string
   */
  public void setNote(String string) {
    note.setValue(string);
  }

  /**
   * @return
   */
  public ALStringField getUpdateDate() {
    return update_date;
  }

  /**
   * @param string
   */
  public void setUpdateDate(String string) {
    update_date.setValue(string);
  }

  public void setDecisionRecords(List list) {
    drlist.addAll(list);
  }

  public void setOldRequestLinks(List links) {
    oldrequestLinks.addAll(links);
  }

}
