/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2008 Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.webmail;

import java.util.List;
import java.util.jar.Attributes;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.util.ALMailUtils;

/**
 * 管理者メール通知設定の検索データを管理するためのクラスです。 <br />
 */
public class WebMailAdminSettingsSelectData extends ALAbstractSelectData {
  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(WebMailAdminSettingsSelectData.class.getName());

  protected List selectList(RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    return null;
  }

  /**
   * ResultDataを取得する抽象メソッドです。（一覧データ）
   * 
   * @param obj
   * @return
   */
  protected Object getResultData(Object obj) throws ALPageNotFoundException,
      ALDBErrorException {
    return null;
  }

  /**
   * 詳細データを取得する抽象メソッドです。
   * 
   * @param rundata
   * @param context
   * @return
   */
  protected Object selectDetail(RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    WebMailAdminSettingsResultData rd = new WebMailAdminSettingsResultData();
    rd.initField();
    rd
        .setMsgTypeBlog(ALMailUtils
            .getSendDestType(ALMailUtils.KEY_MSGTYPE_BLOG));
    rd
        .setMsgTypeNote(ALMailUtils
            .getSendDestType(ALMailUtils.KEY_MSGTYPE_NOTE));
    rd.setMsgTypeSchedule(ALMailUtils
        .getSendDestType(ALMailUtils.KEY_MSGTYPE_SCHEDULE));
    rd.setMsgTypeWorkflow(ALMailUtils
        .getSendDestType(ALMailUtils.KEY_MSGTYPE_WORKFLOW));

    return rd;
  }

  /**
   * ResultDataを取得する抽象メソッドです。（詳細データ）
   * 
   * @param obj
   * @return
   */
  protected Object getResultDataDetail(Object obj)
      throws ALPageNotFoundException, ALDBErrorException {
    return obj;
  }

  /**
   * 
   * @return
   */
  protected Attributes getColumnMap() {
    return null;
  }

}
