/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2008 Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.system;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.jar.Attributes;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.cayenne.om.account.EipMCompany;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.system.util.SystemUtils;

/**
 */
public class SystemNetworkSelectData extends ALAbstractSelectData {
  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(SystemNetworkSelectData.class.getName());

  private String realpath;

  private String servername;

  private String endword;

  /**
   * @see com.aimluck.eip.common.ALAbstractSelectData#selectList(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context)
   */
  protected List selectList(RunData rundata, Context context) {
    return null;
  }

  /**
   * @see com.aimluck.eip.common.ALAbstractSelectData#selectDetail(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context)
   */
  protected Object selectDetail(RunData rundata, Context context) {
    servername = rundata.getServletConfig().getServletName();
    realpath = rundata.getServletContext().getRealPath("/");

    String company_id = rundata.getParameters().getString(
        DatabaseOrmService.ORG_PRE, "");
    if (company_id == null || "".equals(company_id)) {
      endword = "";
    } else {
      endword = "portal/org/" + company_id + "/";
    }
    return SystemUtils.getEipMCompany(rundata, context);
  }

  /**
   * @see com.aimluck.eip.common.ALAbstractSelectData#getResultData(java.lang.Object)
   */
  protected Object getResultData(Object obj) {
    return null;
  }

  /**
   * @see com.aimluck.eip.common.ALAbstractSelectData#getResultDataDetail(java.lang.Object)
   */
  protected Object getResultDataDetail(Object obj) {
    // オブジェクトモデルを取得
    EipMCompany record = (EipMCompany) obj;

    // Aipoサイト情報の取得
    String localurl = "";
    try {
      localurl = SystemUtils.getUrl(
          InetAddress.getLocalHost().getHostAddress(), SystemUtils
              .getServerPort(), servername)
          + endword;
    } catch (UnknownHostException e) {
    }

    String globalurl = SystemUtils.getUrl(record.getIpaddress(), record
        .getPort().intValue(), servername)
        + endword;

    SystemNetworkResultData rd = new SystemNetworkResultData();
    rd.initField();
    rd.setLocalUrl(localurl);
    rd.setGlobalUrl(globalurl);
    return rd;
  }

  /**
   * @see com.aimluck.eip.common.ALAbstractSelectData#getColumnMap()
   */
  protected Attributes getColumnMap() {
    // TODO 自動生成されたメソッド・スタブ
    return null;
  }

}
