/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2008 Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.news;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.jar.Attributes;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.cayenne.om.account.AipoLicense;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.license.util.LicenseUtils;
import com.aimluck.eip.util.ALEipUtils;

/**
 */
public class NewsSelectData extends ALAbstractSelectData {
  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(NewsSelectData.class.getName());

  private String realpath;

  private String servername;

  private String endword;

  /**
   * @see com.aimluck.eip.common.ALAbstractSelectData#selectList(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context)
   */
  protected List selectList(RunData rundata, Context context) {
    return null;
  }

  /**
   * @see com.aimluck.eip.common.ALAbstractSelectData#selectDetail(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context)
   */
  protected Object selectDetail(RunData rundata, Context context) {

    String news_url = ALEipUtils.getPortlet(rundata, context)
        .getPortletConfig().getInitParameter("aipo_newsurl");
    if (news_url == null || "".equals(news_url)) {
      return null;
    }

    AipoLicense license = LicenseUtils.getAipoLicense(rundata, context);
    if (license == null) {
      return news_url;
    }
    return news_url + "?id=" + license.getLicense();
  }

  /**
   * @see com.aimluck.eip.common.ALAbstractSelectData#getResultData(java.lang.Object)
   */
  protected Object getResultData(Object obj) {
    return null;
  }

  /**
   * @see com.aimluck.eip.common.ALAbstractSelectData#getResultDataDetail(java.lang.Object)
   */
  protected Object getResultDataDetail(Object obj) {
    HttpURLConnection conn = null;
    BufferedReader reader = null;

    String body = null;
    try {
      String news_url = (String) obj;

      URL url = new URL(news_url);

      conn = (HttpURLConnection) url.openConnection();
      conn.setRequestMethod("GET");

      reader = new BufferedReader(new InputStreamReader(conn.getInputStream(),
          ALEipConstants.DEF_CONTENT_ENCODING));

      StringBuffer sb = new StringBuffer();
      String line = null;
      while ((line = reader.readLine()) != null) {
        sb.append(line).append("\r\n");
      }

      body = sb.toString();

    } catch (Exception ex) {
      logger.error("Exception", ex);
    } finally {
      try {
        if (reader != null) {
          reader.close();
        }
        if (conn != null) {
          conn.disconnect();
        }
      } catch (IOException e) {
        logger.error("Exception", e);
        return null;
      }
    }

    return body;
  }

  /**
   * @see com.aimluck.eip.common.ALAbstractSelectData#getColumnMap()
   */
  protected Attributes getColumnMap() {
    // TODO 自動生成されたメソッド・スタブ
    return null;
  }

}
