/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2008 Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.account;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.account.EipMUserPosition;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;

/**
 * ユーザーアカウントの順番情報のフォームデータを管理するためのクラスです。 <br />
 */
public class AccountChangeTurnFormData extends ALAbstractFormData {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(AccountChangeTurnFormData.class.getName());

  // ユーザ名のリスト
  private ALStringField positions;

  private String[] userNames = null;

  /** ユーザ情報のリスト */
  private List userList = null;

  /**
   * 初期化します。
   * 
   * @param action
   * @param rundata
   * @param context
   * @see com.aimluck.eip.common.ALAbstractFormData#init(com.aimluck.eip.modules.actions.common.ALAction,
   *      org.apache.turbine.util.RunData, org.apache.velocity.context.Context)
   */
  public void init(ALAction action, RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    super.init(action, rundata, context);

    userList = new ArrayList();
  }

  /**
   * 各フィールドを初期化します。 <BR>
   * 
   * @see com.aimluck.eip.common.ALData#initField()
   */
  public void initField() {
    // ユーザ名のリスト
    positions = new ALStringField();
    positions.setFieldName("ユーザ名リスト");
    positions.setTrim(true);
  }

  /**
   * 
   * @param rundata
   * @param context
   * @param msgList
   * @return
   * @see com.aimluck.eip.common.ALAbstractFormData#setFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  protected boolean setFormData(RunData rundata, Context context,
      ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
    boolean res = true;
    try {
      res = super.setFormData(rundata, context, msgList);
      if (res) {
        if (positions.getValue() == null || positions.getValue().equals("")) {
          userList = ALEipUtils.getUsers("LoginUser");
        } else {
          StringTokenizer st = new StringTokenizer(positions.getValue(), ",");
          userNames = new String[st.countTokens()];
          int count = 0;
          while (st.hasMoreTokens()) {
            userNames[count] = st.nextToken();
            count++;
          }

          DataContext dataContext = DatabaseOrmService.getInstance()
              .getDataContext();
          SelectQuery query = new SelectQuery(TurbineUser.class);
          Expression exp1 = ExpressionFactory.inExp(
              TurbineUser.LOGIN_NAME_PROPERTY, userNames);
          Expression exp2 = ExpressionFactory.matchExp(
              TurbineUser.DISABLED_PROPERTY, "F");
          query.setQualifier(exp1);
          query.andQualifier(exp2);

          List list = dataContext.performQuery(query);

          TurbineUser turbineUser = null;
          int length = userNames.length;
          for (int i = 0; i < length; i++) {
            turbineUser = getEipUserRecord(list, userNames[i]);
            ALEipUser user = new ALEipUser();
            user.initField();
            user.setName(turbineUser.getLoginName());
            user.setAliasName(turbineUser.getFirstName(), turbineUser
                .getLastName());
            userList.add(user);
          }
        }
      }
    } catch (Exception ex) {
      logger.error("Exception", ex);
      return false;
    }
    return res;
  }

  /**
   * 各フィールドに対する制約条件を設定します。 <BR>
   * 
   * @see com.aimluck.eip.common.ALAbstractFormData#setValidator()
   */
  protected void setValidator() {
  }

  /**
   * フォームに入力されたデータの妥当性検証を行います。 <BR>
   * 
   * @param msgList
   * @return
   * @see com.aimluck.eip.common.ALAbstractFormData#validate(java.util.ArrayList)
   */
  protected boolean validate(ArrayList msgList) {
    if (positions.getValue() != null && (!positions.getValue().equals(""))) {
      // 受信したユーザ ID の検証
      StringTokenizer st = new StringTokenizer(positions.getValue(), ",");
      ALStringField field = null;
      while (st.hasMoreTokens()) {
        field = new ALStringField();
        field.setTrim(true);
        field.setValue(st.nextToken());
        field.limitMaxLength(16); // ユーザ名の最大文字数が 16 文字．クラス AccountFormData を参照．
        field.setCharacterType(ALStringField.TYPE_ALPHABET_NUMBER);
        field.validate(msgList);
      }
    }
    return (msgList.size() == 0);
  }

  /**
   * 『ユーザー』を読み込みます。 <BR>
   * 
   * @param rundata
   * @param context
   * @param msgList
   * @return
   * @see com.aimluck.eip.common.ALAbstractFormData#loadFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  protected boolean loadFormData(RunData rundata, Context context,
      ArrayList msgList) {
    try {
      return true;
    } catch (Exception e) {
      logger.error("Exception", e);
      return false;
    }
  }

  /**
   * 『ユーザー』を追加します。 <BR>
   * 
   * @param rundata
   * @param context
   * @param msgList
   * @return
   * @see com.aimluck.eip.common.ALAbstractFormData#insertFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  protected boolean insertFormData(RunData rundata, Context context,
      ArrayList msgList) {
    return false;
  }

  /**
   * 『ユーザー』を更新します。 <BR>
   * 
   * @param rundata
   * @param context
   * @param msgList
   * @return
   * @see com.aimluck.eip.common.ALAbstractFormData#updateFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  protected boolean updateFormData(RunData rundata, Context context,
      ArrayList msgList) {
    boolean res = true;
    try {
      DataContext dataContext = DatabaseOrmService.getInstance()
          .getDataContext();
      Expression exp1 = ExpressionFactory.inExp(
          TurbineUser.LOGIN_NAME_PROPERTY, userNames);
      SelectQuery query = new SelectQuery(TurbineUser.class, exp1);
      Expression exp2 = ExpressionFactory.matchExp(
          TurbineUser.DISABLED_PROPERTY, "F");
      query.addOrdering(TurbineUser.EIP_MUSER_POSITION_PROPERTY + "."
          + EipMUserPosition.POSITION_PROPERTY, true);
      query.andQualifier(exp2);
      List list = dataContext.performQuery(query);

      // 場所を入れ替えたユーザの ID と移動先のインデックスを保持する．
      // (ユーザ ID，移動先インデックス)
      LinkedHashMap map = new LinkedHashMap();
      TurbineUser currentUser = null;
      int length = userNames.length;
      for (int i = 0; i < length; i++) {
        currentUser = (TurbineUser) list.get(i);

        if (!currentUser.getLoginName().equals(userNames[i])) {
          map.put(getEipUserRecord(list, userNames[i]), Integer.valueOf(i + 1));
        }
      }

      TurbineUser key = null;
      Integer value = null;
      Map.Entry entry = null;
      for (Iterator i = map.entrySet().iterator(); i.hasNext();) {
        entry = (Map.Entry) i.next();
        key = (TurbineUser) entry.getKey();
        value = (Integer) entry.getValue();
        EipMUserPosition userPosition = key.getEipMUserPosition();
        userPosition.setPosition(value);
      }

      dataContext.commitChanges();
    } catch (Exception e) {
      logger.error("Exception", e);
      res = false;
    }
    return res;
  }

  /**
   * 『ユーザー』を削除します。 <BR>
   * 
   * @param rundata
   * @param context
   * @param msgList
   * @return
   * @see com.aimluck.eip.common.ALAbstractFormData#deleteFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  protected boolean deleteFormData(RunData rundata, Context context,
      ArrayList msgList) {
    return false;
  }

  /**
   * 指定したユーザ名のオブジェクトを取得する．
   * 
   * @param userList
   * @param userName
   * @return
   */
  private TurbineUser getEipUserRecord(List userList, String userName) {
    int size = userList.size();
    for (int i = 0; i < size; i++) {
      TurbineUser record = (TurbineUser) userList.get(i);
      if (record.getLoginName().equals(userName)) {
        return record;
      }
    }
    return null;
  }

  /**
   * ユーザ情報のリストを取得する．
   * 
   * @return
   */
  public List getUserList() {
    return userList;
  }

}
