/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2008 Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.mail.util;

import java.util.ArrayList;

/**
 * メール受信時のアカウント後の排他制御用のクラスです。 <br />
 * 
 */
public class ALStaticObject {

  private ArrayList flagList;

  private static ALStaticObject so = new ALStaticObject();

  public static ALStaticObject getInstance() {
    return so;
  }

  private ALStaticObject() {
    flagList = new ArrayList();
  }

  public void addAccountId(int accountId) {
    flagList.add(Integer.valueOf(accountId));
  }

  public void removeId(int accountId) {
    int size = flagList.size();
    for (int i = 0; i < size; i++) {
      if (accountId == ((Integer) flagList.get(i)).intValue()) {
        flagList.remove(i);
        break;
      }
    }
  }

  public boolean receivable(int accountId) {
    int size = flagList.size();
    for (int i = 0; i < size; i++) {
      if (accountId == ((Integer) flagList.get(i)).intValue()) {
        return false;
      }
    }
    return true;
  }

}
