package com.jlindamood;

import javax.media.j3d.Behavior;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;
import java.util.Enumeration;

/**
 * Created by IntelliJ IDEA.
 * Programmed by Jack Lindamood
 * Started Date: Apr 29, 2004
 */
public class FPSCounter extends Behavior{
    WakeupCondition whenWake=new WakeupOnElapsedFrames(0);
    int frames;
    private long startTime;

    public FPSCounter(){

    }
    public void initialize() {
        startTime=System.currentTimeMillis();
        frames=0;
        wakeupOn(whenWake);
    }

    public float getFPS(){
        return 1000*( (float) frames /(System.currentTimeMillis()-startTime));
    }
    public void resetCounter(){
        frames=0;
        startTime=System.currentTimeMillis();
    }
    public void processStimulus(Enumeration enumeration) {
        frames++;
        wakeupOn(whenWake);
    }
}