/*
 * $RCSfile: VrmlTokenMgrError.java,v $
 *
 *      @(#)VrmlTokenMgrError.java 1.4 98/11/05 20:35:33
 *
 * Copyright (c) 1996-1998 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 *
 * $Revision: 1.2 $
 * $Date: 2005/02/03 23:07:04 $
 * $State: Exp $
 */
// Search for _Node to see start of nodes

package org.jdesktop.j3d.loaders.vrml97.impl;

/**
 * Generated by JavaCC, but renamed to VrmlTokenMgrError for use with
 * VrmlTokenManager
 */
public class VrmlTokenMgrError extends Error {
    /*
    * Ordinals for various reasons why an Error of this type can be thrown.
    */
    /** Lexical error occured. */
    final static int LEXICAL_ERROR = 0;

    /**
     * An attempt wass made to create a second instance of a static token manager.
     */
    final static int STATIC_LEXER_ERROR = 1;

    /** Tried to change to an invalid lexical state. */
    final static int INVALID_LEXICAL_STATE = 2;

    /**
     * Detected (and bailed out of) an infinite loop in the token manager.
     */
    final static int LOOP_DETECTED = 3;

    /**
     * Indicates the reason why the exception is thrown. It will have
     * one of the above 4 values.
     */
    int errorCode;

    /**
     * Replaces unprintable characters by their espaced (or unicode escaped)
     * equivalents in the given string
     *
     *@param  str The feature to be added to the Escapes attribute
     *@return  Description of the Return Value
     */
    protected final static String addEscapes(String str) {
        StringBuffer retval = new StringBuffer();
        char ch;
        for (int i = 0; i < str.length(); i++) {
            switch (str.charAt(i)) {
                case 0:
                    continue;
                case '\b':
                    retval.append("\\b");
                    continue;
                case '\t':
                    retval.append("\\t");
                    continue;
                case '\n':
                    retval.append("\\n");
                    continue;
                case '\f':
                    retval.append("\\f");
                    continue;
                case '\r':
                    retval.append("\\r");
                    continue;
                case '\"':
                    retval.append("\\\"");
                    continue;
                case '\'':
                    retval.append("\\\'");
                    continue;
                case '\\':
                    retval.append("\\\\");
                    continue;
                default:
                    if ((ch = str.charAt(i)) < 0x20 || ch > 0x7e) {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                    }
                    else {
                        retval.append(ch);
                    }
                    continue;
            }
        }
        return retval.toString();
    }

    /**
     * Returns a detailed message for the Error when it is thrown by the
     * token manager to indicate a lexical error.
     * Parameters :
     *    EOFSeen     : indicates if EOF caused the lexicl error
     *    curLexState : lexical state in which this error occured
     *    errorLine   : line number when the error occured
     *    errorColumn : column number when the error occured
     *    errorAfter  : prefix that was seen before this error occured
     *    curchar     : the offending character
     * Note: You can customize the lexical error message by modifying this method.
     *
     *@param  EOFSeen Description of the Parameter
     *@param  lexState Description of the Parameter
     *@param  errorLine Description of the Parameter
     *@param  errorColumn Description of the Parameter
     *@param  errorAfter Description of the Parameter
     *@param  curChar Description of the Parameter
     *@return  Description of the Return Value
     */
    private final static String LexicalError(boolean EOFSeen, int lexState, int errorLine, int errorColumn, String errorAfter, char curChar) {
        return ("Lexical error at line " +
                errorLine + ", column " +
                errorColumn + ".  Encountered: " +
                (EOFSeen ? "<EOF> " : ("\"" + addEscapes(String.valueOf(curChar)) + "\"") + " (" + (int) curChar + "), ") +
                "after : \"" + addEscapes(errorAfter) + "\"");
    }

    /**
     * You can also modify the body of this method to customize your error messages.
     * For example, cases like LOOP_DETECTED and INVALID_LEXICAL_STATE are not
     * of end-users concern, so you can return something like :
     *
     *     "Internal Error : Please file a bug report .... "
     *
     * from this method for such cases in the release version of your parser.
     *
     *@return  The message value
     */
    public String getMessage() {
        return super.getMessage();
    }

    /*
    * Constructors of various flavors follow.
    */
    /**Constructor for the VrmlTokenMgrError object */
    public VrmlTokenMgrError() { }

    /**
     *Constructor for the VrmlTokenMgrError object
     *
     *@param  message Description of the Parameter
     *@param  reason Description of the Parameter
     */
    public VrmlTokenMgrError(String message, int reason) {
        super(message);
        errorCode = reason;
    }

    /**
     *Constructor for the VrmlTokenMgrError object
     *
     *@param  EOFSeen Description of the Parameter
     *@param  lexState Description of the Parameter
     *@param  errorLine Description of the Parameter
     *@param  errorColumn Description of the Parameter
     *@param  errorAfter Description of the Parameter
     *@param  curChar Description of the Parameter
     *@param  reason Description of the Parameter
     */
    public VrmlTokenMgrError(boolean EOFSeen, int lexState, int errorLine, int errorColumn, String errorAfter, char curChar, int reason) {
        this(LexicalError(EOFSeen, lexState, errorLine, errorColumn, errorAfter, curChar), reason);
    }
}

