/* This file was generated by SableCC (http://www.sablecc.org/). */

package jp.sourceforge.acerola3d.a3.bvh.parser;

import jp.sourceforge.acerola3d.a3.bvh.lexer.*;
import jp.sourceforge.acerola3d.a3.bvh.node.*;
import jp.sourceforge.acerola3d.a3.bvh.analysis.*;
import java.util.*;

import java.io.DataInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;

public class Parser
{
    public final Analysis ignoredTokens = new AnalysisAdapter();

    protected Node node;

    private final Lexer lexer;
    private final ListIterator stack = new LinkedList().listIterator();
    private int last_shift;
    private int last_pos;
    private int last_line;
    private Token last_token;
    private final TokenIndex converter = new TokenIndex();
    private final int[] action = new int[2];

    private final static int SHIFT = 0;
    private final static int REDUCE = 1;
    private final static int ACCEPT = 2;
    private final static int ERROR = 3;

    protected void filter() throws ParserException, LexerException, IOException
    {
    }

    public Parser(Lexer lexer)
    {
        this.lexer = lexer;

        if(actionTable == null)
        {
            try
            {
                DataInputStream s = new DataInputStream(
                    new BufferedInputStream(
                    Parser.class.getResourceAsStream("parser.dat")));

                // read actionTable
                int length = s.readInt();
                actionTable = new int[length][][];
                for(int i = 0; i < actionTable.length; i++)
                {
                    length = s.readInt();
                    actionTable[i] = new int[length][3];
                    for(int j = 0; j < actionTable[i].length; j++)
                    {
                        for(int k = 0; k < 3; k++)
                        {
                            actionTable[i][j][k] = s.readInt();
                        }
                    }
                }

                // read gotoTable
                length = s.readInt();
                gotoTable = new int[length][][];
                for(int i = 0; i < gotoTable.length; i++)
                {
                    length = s.readInt();
                    gotoTable[i] = new int[length][2];
                    for(int j = 0; j < gotoTable[i].length; j++)
                    {
                        for(int k = 0; k < 2; k++)
                        {
                            gotoTable[i][j][k] = s.readInt();
                        }
                    }
                }

                // read errorMessages
                length = s.readInt();
                errorMessages = new String[length];
                for(int i = 0; i < errorMessages.length; i++)
                {
                    length = s.readInt();
                    StringBuffer buffer = new StringBuffer();

                    for(int j = 0; j < length; j++)
                    {
                        buffer.append(s.readChar());
                    }
                    errorMessages[i] = buffer.toString();
                }

                // read errors
                length = s.readInt();
                errors = new int[length];
                for(int i = 0; i < errors.length; i++)
                {
                    errors[i] = s.readInt();
                }

                s.close();
            }
            catch(Exception e)
            {
                throw new RuntimeException("The file \"parser.dat\" is either missing or corrupted.");
            }
        }
    }

    private int goTo(int index)
    {
        int state = state();
        int low = 1;
        int high = gotoTable[index].length - 1;
        int value = gotoTable[index][0][1];

        while(low <= high)
        {
            int middle = (low + high) / 2;

            if(state < gotoTable[index][middle][0])
            {
                high = middle - 1;
            }
            else if(state > gotoTable[index][middle][0])
            {
                low = middle + 1;
            }
            else
            {
                value = gotoTable[index][middle][1];
                break;
            }
        }

        return value;
    }

    private void push(int state, Node node, boolean filter) throws ParserException, LexerException, IOException
    {
        this.node = node;

        if(filter)
        {
            filter();
        }

        if(!stack.hasNext())
        {
            stack.add(new State(state, this.node));
            return;
        }

        State s = (State) stack.next();
        s.state = state;
        s.node = this.node;
    }

    private int state()
    {
        State s = (State) stack.previous();
        stack.next();
        return s.state;
    }

    private Node pop()
    {
        return (Node) ((State) stack.previous()).node;
    }

    private int index(Switchable token)
    {
        converter.index = -1;
        token.apply(converter);
        return converter.index;
    }

    public Start parse() throws ParserException, LexerException, IOException
    {
        push(0, null, false);

        List ign = null;
        while(true)
        {
            while(index(lexer.peek()) == -1)
            {
                if(ign == null)
                {
                    ign = new TypedLinkedList(NodeCast.instance);
                }

                ign.add(lexer.next());
            }

            if(ign != null)
            {
                ignoredTokens.setIn(lexer.peek(), ign);
                ign = null;
            }

            last_pos = lexer.peek().getPos();
            last_line = lexer.peek().getLine();
            last_token = lexer.peek();

            int index = index(lexer.peek());
            action[0] = actionTable[state()][0][1];
            action[1] = actionTable[state()][0][2];

            int low = 1;
            int high = actionTable[state()].length - 1;

            while(low <= high)
            {
                int middle = (low + high) / 2;

                if(index < actionTable[state()][middle][0])
                {
                    high = middle - 1;
                }
                else if(index > actionTable[state()][middle][0])
                {
                    low = middle + 1;
                }
                else
                {
                    action[0] = actionTable[state()][middle][1];
                    action[1] = actionTable[state()][middle][2];
                    break;
                }
            }

            switch(action[0])
            {
                case SHIFT:
                    push(action[1], lexer.next(), true);
                    last_shift = action[1];
                    break;
                case REDUCE:
                    switch(action[1])
                    {
                    case 0: { Node node = new0(); push(goTo(0), node, true); } break;
                    case 1: { Node node = new1(); push(goTo(1), node, true); } break;
                    case 2: { Node node = new2(); push(goTo(2), node, true); } break;
                    case 3: { Node node = new3(); push(goTo(13), node, false); } break;
                    case 4: { Node node = new4(); push(goTo(13), node, false); } break;
                    case 5: { Node node = new5(); push(goTo(3), node, true); } break;
                    case 6: { Node node = new6(); push(goTo(4), node, true); } break;
                    case 7: { Node node = new7(); push(goTo(4), node, true); } break;
                    case 8: { Node node = new8(); push(goTo(5), node, true); } break;
                    case 9: { Node node = new9(); push(goTo(5), node, true); } break;
                    case 10: { Node node = new10(); push(goTo(14), node, false); } break;
                    case 11: { Node node = new11(); push(goTo(14), node, false); } break;
                    case 12: { Node node = new12(); push(goTo(6), node, true); } break;
                    case 13: { Node node = new13(); push(goTo(6), node, true); } break;
                    case 14: { Node node = new14(); push(goTo(6), node, true); } break;
                    case 15: { Node node = new15(); push(goTo(6), node, true); } break;
                    case 16: { Node node = new16(); push(goTo(6), node, true); } break;
                    case 17: { Node node = new17(); push(goTo(6), node, true); } break;
                    case 18: { Node node = new18(); push(goTo(6), node, true); } break;
                    case 19: { Node node = new19(); push(goTo(6), node, true); } break;
                    case 20: { Node node = new20(); push(goTo(6), node, true); } break;
                    case 21: { Node node = new21(); push(goTo(7), node, true); } break;
                    case 22: { Node node = new22(); push(goTo(7), node, true); } break;
                    case 23: { Node node = new23(); push(goTo(8), node, true); } break;
                    case 24: { Node node = new24(); push(goTo(9), node, true); } break;
                    case 25: { Node node = new25(); push(goTo(10), node, true); } break;
                    case 26: { Node node = new26(); push(goTo(10), node, true); } break;
                    case 27: { Node node = new27(); push(goTo(15), node, false); } break;
                    case 28: { Node node = new28(); push(goTo(15), node, false); } break;
                    case 29: { Node node = new29(); push(goTo(11), node, true); } break;
                    case 30: { Node node = new30(); push(goTo(12), node, true); } break;
                    }
                    break;
                case ACCEPT:
                    {
                        EOF node2 = (EOF) lexer.next();
                        PBvh node1 = (PBvh) pop();
                        Start node = new Start(node1, node2);
                        return node;
                    }
                case ERROR:
                    throw new ParserException(last_token,
                        "[" + last_line + "," + last_pos + "] " +
                        errorMessages[errors[action[1]]]);
            }
        }
    }

    Node new0()
    {
        PMotionPart node2 = (PMotionPart) pop();
        PHierarchyPart node1 = (PHierarchyPart) pop();
        ABvh node = new ABvh(node1, node2);
        return node;
    }

    Node new1()
    {
        PRootBlock node2 = (PRootBlock) pop();
        THierarchy node1 = (THierarchy) pop();
        AHierarchyPart node = new AHierarchyPart(node1, node2);
        return node;
    }

    Node new2()
    {
        TRBrace node7 = (TRBrace) pop();
        XPSuperBlock node6 = (XPSuperBlock) pop();
        PChannelsLine node5 = (PChannelsLine) pop();
        POffsetLine node4 = (POffsetLine) pop();
        TLBrace node3 = (TLBrace) pop();
        TIdentifier node2 = (TIdentifier) pop();
        TRoot node1 = (TRoot) pop();
        ARootBlock node = new ARootBlock(node1, node2, node3, node4, node5, node6, node7);
        return node;
    }

    Node new3()
    {
        PSuperBlock node2 = (PSuperBlock) pop();
        XPSuperBlock node1 = (XPSuperBlock) pop();
        X1PSuperBlock node = new X1PSuperBlock(node1, node2);
        return node;
    }

    Node new4()
    {
        PSuperBlock node1 = (PSuperBlock) pop();
        X2PSuperBlock node = new X2PSuperBlock(node1);
        return node;
    }

    Node new5()
    {
        PNumber node4 = (PNumber) pop();
        PNumber node3 = (PNumber) pop();
        PNumber node2 = (PNumber) pop();
        TOffset node1 = (TOffset) pop();
        AOffsetLine node = new AOffsetLine(node1, node2, node3, node4);
        return node;
    }

    Node new6()
    {
        TInteger node1 = (TInteger) pop();
        AIntegerNumber node = new AIntegerNumber(node1);
        return node;
    }

    Node new7()
    {
        TRealNumber node1 = (TRealNumber) pop();
        ARealNumberNumber node = new ARealNumberNumber(node1);
        return node;
    }

    Node new8()
    {
        XPChannelType node3 = null;
        TInteger node2 = (TInteger) pop();
        TChannels node1 = (TChannels) pop();
        AChannelsLine node = new AChannelsLine(node1, node2, node3);
        return node;
    }

    Node new9()
    {
        XPChannelType node3 = (XPChannelType) pop();
        TInteger node2 = (TInteger) pop();
        TChannels node1 = (TChannels) pop();
        AChannelsLine node = new AChannelsLine(node1, node2, node3);
        return node;
    }

    Node new10()
    {
        PChannelType node2 = (PChannelType) pop();
        XPChannelType node1 = (XPChannelType) pop();
        X1PChannelType node = new X1PChannelType(node1, node2);
        return node;
    }

    Node new11()
    {
        PChannelType node1 = (PChannelType) pop();
        X2PChannelType node = new X2PChannelType(node1);
        return node;
    }

    Node new12()
    {
        TXPosition node1 = (TXPosition) pop();
        AXPositionChannelType node = new AXPositionChannelType(node1);
        return node;
    }

    Node new13()
    {
        TYPosition node1 = (TYPosition) pop();
        AYPositionChannelType node = new AYPositionChannelType(node1);
        return node;
    }

    Node new14()
    {
        TZPosition node1 = (TZPosition) pop();
        AZPositionChannelType node = new AZPositionChannelType(node1);
        return node;
    }

    Node new15()
    {
        TXRotation node1 = (TXRotation) pop();
        AXRotationChannelType node = new AXRotationChannelType(node1);
        return node;
    }

    Node new16()
    {
        TYRotation node1 = (TYRotation) pop();
        AYRotationChannelType node = new AYRotationChannelType(node1);
        return node;
    }

    Node new17()
    {
        TZRotation node1 = (TZRotation) pop();
        AZRotationChannelType node = new AZRotationChannelType(node1);
        return node;
    }

    Node new18()
    {
        TXScale node1 = (TXScale) pop();
        AXScaleChannelType node = new AXScaleChannelType(node1);
        return node;
    }

    Node new19()
    {
        TYScale node1 = (TYScale) pop();
        AYScaleChannelType node = new AYScaleChannelType(node1);
        return node;
    }

    Node new20()
    {
        TZScale node1 = (TZScale) pop();
        AZScaleChannelType node = new AZScaleChannelType(node1);
        return node;
    }

    Node new21()
    {
        PJointBlock node1 = (PJointBlock) pop();
        AJointSuperBlock node = new AJointSuperBlock(node1);
        return node;
    }

    Node new22()
    {
        PEndSiteBlock node1 = (PEndSiteBlock) pop();
        AEndSiteSuperBlock node = new AEndSiteSuperBlock(node1);
        return node;
    }

    Node new23()
    {
        TRBrace node7 = (TRBrace) pop();
        XPSuperBlock node6 = (XPSuperBlock) pop();
        PChannelsLine node5 = (PChannelsLine) pop();
        POffsetLine node4 = (POffsetLine) pop();
        TLBrace node3 = (TLBrace) pop();
        TIdentifier node2 = (TIdentifier) pop();
        TJoint node1 = (TJoint) pop();
        AJointBlock node = new AJointBlock(node1, node2, node3, node4, node5, node6, node7);
        return node;
    }

    Node new24()
    {
        TRBrace node4 = (TRBrace) pop();
        POffsetLine node3 = (POffsetLine) pop();
        TLBrace node2 = (TLBrace) pop();
        TEndSite node1 = (TEndSite) pop();
        AEndSiteBlock node = new AEndSiteBlock(node1, node2, node3, node4);
        return node;
    }

    Node new25()
    {
        XPNumber node4 = null;
        PFrameTimeLine node3 = (PFrameTimeLine) pop();
        PFramesLine node2 = (PFramesLine) pop();
        TMotion node1 = (TMotion) pop();
        AMotionPart node = new AMotionPart(node1, node2, node3, node4);
        return node;
    }

    Node new26()
    {
        XPNumber node4 = (XPNumber) pop();
        PFrameTimeLine node3 = (PFrameTimeLine) pop();
        PFramesLine node2 = (PFramesLine) pop();
        TMotion node1 = (TMotion) pop();
        AMotionPart node = new AMotionPart(node1, node2, node3, node4);
        return node;
    }

    Node new27()
    {
        PNumber node2 = (PNumber) pop();
        XPNumber node1 = (XPNumber) pop();
        X1PNumber node = new X1PNumber(node1, node2);
        return node;
    }

    Node new28()
    {
        PNumber node1 = (PNumber) pop();
        X2PNumber node = new X2PNumber(node1);
        return node;
    }

    Node new29()
    {
        TInteger node2 = (TInteger) pop();
        TFrames node1 = (TFrames) pop();
        AFramesLine node = new AFramesLine(node1, node2);
        return node;
    }

    Node new30()
    {
        PNumber node2 = (PNumber) pop();
        TFrameTime node1 = (TFrameTime) pop();
        AFrameTimeLine node = new AFrameTimeLine(node1, node2);
        return node;
    }

    private static int[][][] actionTable;
/*      {
			{{-1, ERROR, 0}, {0, SHIFT, 1}, },
			{{-1, ERROR, 1}, {1, SHIFT, 4}, },
			{{-1, ERROR, 2}, {23, ACCEPT, -1}, },
			{{-1, ERROR, 3}, {17, SHIFT, 6}, },
			{{-1, ERROR, 4}, {20, SHIFT, 8}, },
			{{-1, REDUCE, 1}, },
			{{-1, ERROR, 6}, {18, SHIFT, 9}, },
			{{-1, REDUCE, 0}, },
			{{-1, ERROR, 8}, {15, SHIFT, 11}, },
			{{-1, ERROR, 9}, {21, SHIFT, 12}, },
			{{-1, ERROR, 10}, {19, SHIFT, 13}, },
			{{-1, ERROR, 11}, {2, SHIFT, 15}, },
			{{-1, REDUCE, 29}, },
			{{-1, ERROR, 13}, {21, SHIFT, 17}, {22, SHIFT, 18}, },
			{{-1, REDUCE, 25}, {21, SHIFT, 17}, {22, SHIFT, 18}, },
			{{-1, ERROR, 15}, {21, SHIFT, 17}, {22, SHIFT, 18}, },
			{{-1, ERROR, 16}, {3, SHIFT, 23}, },
			{{-1, REDUCE, 6}, },
			{{-1, REDUCE, 7}, },
			{{-1, REDUCE, 30}, },
			{{-1, REDUCE, 28}, },
			{{-1, REDUCE, 26}, {21, SHIFT, 17}, {22, SHIFT, 18}, },
			{{-1, ERROR, 22}, {21, SHIFT, 17}, {22, SHIFT, 18}, },
			{{-1, ERROR, 23}, {21, SHIFT, 27}, },
			{{-1, ERROR, 24}, {4, SHIFT, 28}, {14, SHIFT, 29}, },
			{{-1, REDUCE, 27}, },
			{{-1, ERROR, 26}, {21, SHIFT, 17}, {22, SHIFT, 18}, },
			{{-1, REDUCE, 8}, {5, SHIFT, 35}, {6, SHIFT, 36}, {7, SHIFT, 37}, {8, SHIFT, 38}, {9, SHIFT, 39}, {10, SHIFT, 40}, {11, SHIFT, 41}, {12, SHIFT, 42}, {13, SHIFT, 43}, },
			{{-1, ERROR, 28}, {20, SHIFT, 46}, },
			{{-1, ERROR, 29}, {15, SHIFT, 47}, },
			{{-1, REDUCE, 4}, },
			{{-1, REDUCE, 21}, },
			{{-1, REDUCE, 22}, },
			{{-1, ERROR, 33}, {4, SHIFT, 28}, {14, SHIFT, 29}, {16, SHIFT, 48}, },
			{{-1, REDUCE, 5}, },
			{{-1, REDUCE, 12}, },
			{{-1, REDUCE, 13}, },
			{{-1, REDUCE, 14}, },
			{{-1, REDUCE, 15}, },
			{{-1, REDUCE, 16}, },
			{{-1, REDUCE, 17}, },
			{{-1, REDUCE, 18}, },
			{{-1, REDUCE, 19}, },
			{{-1, REDUCE, 20}, },
			{{-1, REDUCE, 11}, },
			{{-1, REDUCE, 9}, {5, SHIFT, 35}, {6, SHIFT, 36}, {7, SHIFT, 37}, {8, SHIFT, 38}, {9, SHIFT, 39}, {10, SHIFT, 40}, {11, SHIFT, 41}, {12, SHIFT, 42}, {13, SHIFT, 43}, },
			{{-1, ERROR, 46}, {15, SHIFT, 51}, },
			{{-1, ERROR, 47}, {2, SHIFT, 15}, },
			{{-1, REDUCE, 2}, },
			{{-1, REDUCE, 3}, },
			{{-1, REDUCE, 10}, },
			{{-1, ERROR, 51}, {2, SHIFT, 15}, },
			{{-1, ERROR, 52}, {16, SHIFT, 54}, },
			{{-1, ERROR, 53}, {3, SHIFT, 23}, },
			{{-1, REDUCE, 24}, },
			{{-1, ERROR, 55}, {4, SHIFT, 28}, {14, SHIFT, 29}, },
			{{-1, ERROR, 56}, {4, SHIFT, 28}, {14, SHIFT, 29}, {16, SHIFT, 57}, },
			{{-1, REDUCE, 23}, },
        };*/
    private static int[][][] gotoTable;
/*      {
			{{-1, 2}, },
			{{-1, 3}, },
			{{-1, 5}, },
			{{-1, 16}, {47, 52}, {51, 53}, },
			{{-1, 19}, {14, 20}, {15, 22}, {21, 25}, {22, 26}, {26, 34}, },
			{{-1, 24}, {53, 55}, },
			{{-1, 44}, {45, 50}, },
			{{-1, 30}, {33, 49}, {56, 49}, },
			{{-1, 31}, },
			{{-1, 32}, },
			{{-1, 7}, },
			{{-1, 10}, },
			{{-1, 14}, },
			{{-1, 33}, {55, 56}, },
			{{-1, 45}, },
			{{-1, 21}, },
        };*/
    private static String[] errorMessages;
/*      {
			"expecting: 'HIERARCHY'",
			"expecting: 'ROOT'",
			"expecting: EOF",
			"expecting: 'MOTION'",
			"expecting: identifier",
			"expecting: 'Frames:'",
			"expecting: '{'",
			"expecting: integer",
			"expecting: 'Frame Time:'",
			"expecting: 'OFFSET'",
			"expecting: integer, real number",
			"expecting: integer, real number, EOF",
			"expecting: 'CHANNELS'",
			"expecting: 'CHANNELS', '}', integer, real number, EOF",
			"expecting: 'JOINT', 'End Site'",
			"expecting: 'JOINT', 'Xposition', 'Yposition', 'Zposition', 'Xrotation', 'Yrotation', 'Zrotation', 'Xscale', 'Yscale', 'Zscale', 'End Site'",
			"expecting: 'JOINT', 'End Site', '}'",
			"expecting: 'CHANNELS', '}'",
			"expecting: '}'",
        };*/
    private static int[] errors;
/*      {
			0, 1, 2, 3, 4, 3, 5, 2, 6, 7, 8, 9, 8, 10, 11, 10, 12, 13, 13, 11, 11, 11, 10, 7, 14, 11, 10, 15, 4, 6, 16, 16, 16, 16, 17, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 6, 9, 3, 16, 15, 9, 18, 12, 16, 14, 16, 16, 
        };*/
}
