/* This file was generated by SableCC (http://www.sablecc.org/). */

package jp.sourceforge.acerola3d.a3.bvh.lexer;

import java.io.*;
import java.util.*;
import jp.sourceforge.acerola3d.a3.bvh.node.*;

public class Lexer
{
    protected Token token;
    protected State state = State.INITIAL;

    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();

    protected void filter() throws LexerException, IOException
    {
    }

    public Lexer(PushbackReader in)
    {
        this.in = in;

        if(gotoTable == null)
        {
            try
            {
                DataInputStream s = new DataInputStream(
                    new BufferedInputStream(
                    Lexer.class.getResourceAsStream("lexer.dat")));

                // read gotoTable
                int length = s.readInt();
                gotoTable = new int[length][][][];
                for(int i = 0; i < gotoTable.length; i++)
                {
                    length = s.readInt();
                    gotoTable[i] = new int[length][][];
                    for(int j = 0; j < gotoTable[i].length; j++)
                    {
                        length = s.readInt();
                        gotoTable[i][j] = new int[length][3];
                        for(int k = 0; k < gotoTable[i][j].length; k++)
                        {
                            for(int l = 0; l < 3; l++)
                            {
                                gotoTable[i][j][k][l] = s.readInt();
                            }
                        }
                    }
                }

                // read accept
                length = s.readInt();
                accept = new int[length][];
                for(int i = 0; i < accept.length; i++)
                {
                    length = s.readInt();
                    accept[i] = new int[length];
                    for(int j = 0; j < accept[i].length; j++)
                    {
                        accept[i][j] = s.readInt();
                    }
                }

                s.close();
            }
            catch(Exception e)
            {
                throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
            }
        }
    }

    public Token peek() throws LexerException, IOException
    {
        while(token == null)
        {
            token = getToken();
            filter();
        }

        return token;
    }

    public Token next() throws LexerException, IOException
    {
        while(token == null)
        {
            token = getToken();
            filter();
        }

        Token result = token;
        token = null;
        return result;
    }

    protected Token getToken() throws IOException, LexerException
    {
        int dfa_state = 0;

        int start_pos = pos;
        int start_line = line;

        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;

        int[][][] gotoTable = this.gotoTable[state.id()];
        int[] accept = this.accept[state.id()];
        text.setLength(0);

        while(true)
        {
            int c = getChar();

            if(c != -1)
            {
                switch(c)
                {
                case 10:
                    if(cr)
                    {
                        cr = false;
                    }
                    else
                    {
                        line++;
                        pos = 0;
                    }
                    break;
                case 13:
                    line++;
                    pos = 0;
                    cr = true;
                    break;
                default:
                    pos++;
                    cr = false;
                    break;
                };

                text.append((char) c);

                do
                {
                    int oldState = (dfa_state < -1) ? (-2 -dfa_state) : dfa_state;

                    dfa_state = -1;

                    int[][] tmp1 =  gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;

                    while(low <= high)
                    {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];

                        if(c < tmp2[0])
                        {
                            high = middle - 1;
                        }
                        else if(c > tmp2[1])
                        {
                            low = middle + 1;
                        }
                        else
                        {
                            dfa_state = tmp2[2];
                            break;
                        }
                    }
                }while(dfa_state < -1);
            }
            else
            {
                dfa_state = -1;
            }

            if(dfa_state >= 0)
            {
                if(accept[dfa_state] != -1)
                {
                    accept_state = dfa_state;
                    accept_token = accept[dfa_state];
                    accept_length = text.length();
                    accept_pos = pos;
                    accept_line = line;
                }
            }
            else
            {
                if(accept_state != -1)
                {
                    switch(accept_token)
                    {
                    case 0:
                        {
                            Token token = new0(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 1:
                        {
                            Token token = new1(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 2:
                        {
                            Token token = new2(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 3:
                        {
                            Token token = new3(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 4:
                        {
                            Token token = new4(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 5:
                        {
                            Token token = new5(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 6:
                        {
                            Token token = new6(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 7:
                        {
                            Token token = new7(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 8:
                        {
                            Token token = new8(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 9:
                        {
                            Token token = new9(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 10:
                        {
                            Token token = new10(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 11:
                        {
                            Token token = new11(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 12:
                        {
                            Token token = new12(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 13:
                        {
                            Token token = new13(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 14:
                        {
                            Token token = new14(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 15:
                        {
                            Token token = new15(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 16:
                        {
                            Token token = new16(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 17:
                        {
                            Token token = new17(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 18:
                        {
                            Token token = new18(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 19:
                        {
                            Token token = new19(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 20:
                        {
                            Token token = new20(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 21:
                        {
                            Token token = new21(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 22:
                        {
                            Token token = new22(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 23:
                        {
                            Token token = new23(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    }
                }
                else
                {
                    if(text.length() > 0)
                    {
                        throw new LexerException(
                            "[" + (start_line + 1) + "," + (start_pos + 1) + "]" +
                            " Unknown token: " + text);
                    }
                    else
                    {
                        EOF token = new EOF(
                            start_line + 1,
                            start_pos + 1);
                        return token;
                    }
                }
            }
        }
    }

    Token new0(int line, int pos) { return new THierarchy(line, pos); }
    Token new1(int line, int pos) { return new TRoot(line, pos); }
    Token new2(int line, int pos) { return new TOffset(line, pos); }
    Token new3(int line, int pos) { return new TChannels(line, pos); }
    Token new4(int line, int pos) { return new TJoint(line, pos); }
    Token new5(int line, int pos) { return new TXPosition(line, pos); }
    Token new6(int line, int pos) { return new TYPosition(line, pos); }
    Token new7(int line, int pos) { return new TZPosition(line, pos); }
    Token new8(int line, int pos) { return new TXRotation(line, pos); }
    Token new9(int line, int pos) { return new TYRotation(line, pos); }
    Token new10(int line, int pos) { return new TZRotation(line, pos); }
    Token new11(int line, int pos) { return new TXScale(line, pos); }
    Token new12(int line, int pos) { return new TYScale(line, pos); }
    Token new13(int line, int pos) { return new TZScale(line, pos); }
    Token new14(int line, int pos) { return new TEndSite(line, pos); }
    Token new15(int line, int pos) { return new TLBrace(line, pos); }
    Token new16(int line, int pos) { return new TRBrace(line, pos); }
    Token new17(int line, int pos) { return new TMotion(line, pos); }
    Token new18(int line, int pos) { return new TFrames(line, pos); }
    Token new19(int line, int pos) { return new TFrameTime(line, pos); }
    Token new20(String text, int line, int pos) { return new TIdentifier(text, line, pos); }
    Token new21(String text, int line, int pos) { return new TInteger(text, line, pos); }
    Token new22(String text, int line, int pos) { return new TRealNumber(text, line, pos); }
    Token new23(String text, int line, int pos) { return new TBlank(text, line, pos); }

    private int getChar() throws IOException
    {
        if(eof)
        {
            return -1;
        }

        int result = in.read();

        if(result == -1)
        {
            eof = true;
        }

        return result;
    }

    private void pushBack(int acceptLength) throws IOException
    {
        int length = text.length();
        for(int i = length - 1; i >= acceptLength; i--)
        {
            eof = false;

            in.unread(text.charAt(i));
        }
    }

    protected void unread(Token token) throws IOException
    {
        String text = token.getText();
        int length = text.length();

        for(int i = length - 1; i >= 0; i--)
        {
            eof = false;

            in.unread(text.charAt(i));
        }

        pos = token.getPos() - 1;
        line = token.getLine() - 1;
    }

    private String getText(int acceptLength)
    {
        StringBuffer s = new StringBuffer(acceptLength);
        for(int i = 0; i < acceptLength; i++)
        {
            s.append(text.charAt(i));
        }

        return s.toString();
    }

    private static int[][][][] gotoTable;
/*  {
        { // INITIAL
            {{9, 9, 1}, {10, 10, 2}, {13, 13, 3}, {32, 32, 4}, {43, 43, 5}, {45, 45, 6}, {46, 46, 7}, {48, 57, 8}, {65, 66, 9}, {67, 67, 10}, {68, 68, 9}, {69, 69, 11}, {70, 70, 12}, {71, 71, 9}, {72, 72, 13}, {73, 73, 9}, {74, 74, 14}, {75, 76, 9}, {77, 77, 15}, {78, 78, 9}, {79, 79, 16}, {80, 81, 9}, {82, 82, 17}, {83, 87, 9}, {88, 88, 18}, {89, 89, 19}, {90, 90, 20}, {95, 95, 21}, {97, 122, 22}, {123, 123, 23}, {125, 125, 24}, },
            {{9, 32, -2}, },
            {{9, 32, -2}, },
            {{9, 32, -2}, },
            {{9, 32, -2}, },
            {{46, 57, -2}, },
            {{46, 57, -2}, },
            {{48, 57, 25}, },
            {{46, 46, 26}, {48, 57, 8}, },
            {{46, 46, 27}, {48, 57, 28}, {65, 90, 29}, {95, 95, 30}, {97, 122, 31}, },
            {{46, 57, -11}, {65, 71, 29}, {72, 72, 32}, {73, 90, 29}, {95, 122, -11}, },
            {{46, 95, -11}, {97, 109, 31}, {110, 110, 33}, {111, 122, 31}, },
            {{46, 95, -11}, {97, 113, 31}, {114, 114, 34}, {115, 122, 31}, },
            {{46, 57, -11}, {65, 72, 29}, {73, 73, 35}, {74, 90, 29}, {95, 122, -11}, },
            {{46, 57, -11}, {65, 78, 29}, {79, 79, 36}, {80, 90, 29}, {95, 122, -11}, },
            {{46, 78, -16}, {79, 79, 37}, {80, 122, -16}, },
            {{46, 57, -11}, {65, 69, 29}, {70, 70, 38}, {71, 90, 29}, {95, 122, -11}, },
            {{46, 78, -16}, {79, 79, 39}, {80, 122, -16}, },
            {{46, 95, -11}, {97, 111, 31}, {112, 112, 40}, {113, 113, 31}, {114, 114, 41}, {115, 115, 42}, {116, 122, 31}, },
            {{46, 111, -20}, {112, 112, 43}, {113, 113, 31}, {114, 114, 44}, {115, 115, 45}, {116, 122, 31}, },
            {{46, 111, -20}, {112, 112, 46}, {113, 113, 31}, {114, 114, 47}, {115, 115, 48}, {116, 122, 31}, },
            {{46, 122, -11}, },
            {{46, 122, -11}, },
            {},
            {},
            {{48, 57, 25}, {69, 69, 49}, {101, 101, 50}, },
            {{48, 57, 51}, {69, 69, 52}, {101, 101, 53}, },
            {{46, 122, -11}, },
            {{46, 122, -11}, },
            {{46, 122, -11}, },
            {{46, 122, -11}, },
            {{46, 122, -11}, },
            {{46, 57, -11}, {65, 65, 54}, {66, 90, 29}, {95, 122, -11}, },
            {{46, 95, -11}, {97, 99, 31}, {100, 100, 55}, {101, 122, 31}, },
            {{46, 95, -11}, {97, 97, 56}, {98, 122, 31}, },
            {{46, 57, -11}, {65, 68, 29}, {69, 69, 57}, {70, 90, 29}, {95, 122, -11}, },
            {{46, 72, -15}, {73, 73, 58}, {74, 122, -15}, },
            {{46, 57, -11}, {65, 83, 29}, {84, 84, 59}, {85, 90, 29}, {95, 122, -11}, },
            {{46, 69, -18}, {70, 70, 60}, {71, 122, -18}, },
            {{46, 78, -16}, {79, 79, 61}, {80, 122, -16}, },
            {{46, 95, -11}, {97, 110, 31}, {111, 111, 62}, {112, 122, 31}, },
            {{46, 110, -42}, {111, 111, 63}, {112, 122, 31}, },
            {{46, 95, -11}, {97, 98, 31}, {99, 99, 64}, {100, 122, 31}, },
            {{46, 110, -42}, {111, 111, 65}, {112, 122, 31}, },
            {{46, 110, -42}, {111, 111, 66}, {112, 122, 31}, },
            {{46, 98, -44}, {99, 99, 67}, {100, 122, 31}, },
            {{46, 110, -42}, {111, 111, 68}, {112, 122, 31}, },
            {{46, 110, -42}, {111, 111, 69}, {112, 122, 31}, },
            {{46, 98, -44}, {99, 99, 70}, {100, 122, 31}, },
            {{43, 43, 71}, {45, 45, 72}, {48, 57, 73}, },
            {{43, 57, -51}, },
            {{48, 101, -28}, },
            {{43, 43, 74}, {45, 45, 75}, {48, 57, 76}, },
            {{43, 57, -54}, },
            {{46, 57, -11}, {65, 77, 29}, {78, 78, 77}, {79, 90, 29}, {95, 122, -11}, },
            {{32, 32, 78}, {46, 122, -11}, },
            {{46, 95, -11}, {97, 108, 31}, {109, 109, 79}, {110, 122, 31}, },
            {{46, 57, -11}, {65, 81, 29}, {82, 82, 80}, {83, 90, 29}, {95, 122, -11}, },
            {{46, 77, -56}, {78, 78, 81}, {79, 122, -56}, },
            {{46, 72, -15}, {73, 73, 82}, {74, 122, -15}, },
            {{46, 57, -11}, {65, 82, 29}, {83, 83, 83}, {84, 90, 29}, {95, 122, -11}, },
            {{46, 83, -39}, {84, 84, 84}, {85, 122, -39}, },
            {{46, 95, -11}, {97, 114, 31}, {115, 115, 85}, {116, 122, 31}, },
            {{46, 95, -11}, {97, 115, 31}, {116, 116, 86}, {117, 122, 31}, },
            {{46, 95, -11}, {97, 97, 87}, {98, 122, 31}, },
            {{46, 114, -64}, {115, 115, 88}, {116, 122, 31}, },
            {{46, 115, -65}, {116, 116, 89}, {117, 122, 31}, },
            {{46, 95, -11}, {97, 97, 90}, {98, 122, 31}, },
            {{46, 114, -64}, {115, 115, 91}, {116, 122, 31}, },
            {{46, 115, -65}, {116, 116, 92}, {117, 122, 31}, },
            {{46, 95, -11}, {97, 97, 93}, {98, 122, 31}, },
            {{48, 57, 73}, },
            {{48, 57, 73}, },
            {{48, 57, 73}, },
            {{48, 57, 76}, },
            {{48, 57, 76}, },
            {{48, 57, 76}, },
            {{46, 77, -56}, {78, 78, 94}, {79, 122, -56}, },
            {{83, 83, 95}, },
            {{46, 95, -11}, {97, 100, 31}, {101, 101, 96}, {102, 122, 31}, },
            {{46, 57, -11}, {65, 65, 97}, {66, 122, -34}, },
            {{46, 83, -39}, {84, 84, 98}, {85, 122, -39}, },
            {{46, 78, -16}, {79, 79, 99}, {80, 122, -16}, },
            {{46, 68, -37}, {69, 69, 100}, {70, 122, -37}, },
            {{46, 122, -11}, },
            {{46, 95, -11}, {97, 104, 31}, {105, 105, 101}, {106, 122, 31}, },
            {{46, 95, -11}, {97, 97, 102}, {98, 122, 31}, },
            {{46, 95, -11}, {97, 107, 31}, {108, 108, 103}, {109, 122, 31}, },
            {{46, 104, -87}, {105, 105, 104}, {106, 122, 31}, },
            {{46, 95, -11}, {97, 97, 105}, {98, 122, 31}, },
            {{46, 107, -89}, {108, 108, 106}, {109, 122, 31}, },
            {{46, 104, -87}, {105, 105, 107}, {106, 122, 31}, },
            {{46, 95, -11}, {97, 97, 108}, {98, 122, 31}, },
            {{46, 107, -89}, {108, 108, 109}, {109, 122, 31}, },
            {{46, 68, -37}, {69, 69, 110}, {70, 122, -37}, },
            {{105, 105, 111}, },
            {{32, 32, 112}, {46, 114, -64}, {115, 115, 113}, {116, 122, 31}, },
            {{46, 81, -59}, {82, 82, 114}, {83, 122, -59}, },
            {{46, 122, -11}, },
            {{46, 77, -56}, {78, 78, 115}, {79, 122, -56}, },
            {{46, 83, -39}, {84, 84, 116}, {85, 122, -39}, },
            {{46, 115, -65}, {116, 116, 117}, {117, 122, 31}, },
            {{46, 115, -65}, {116, 116, 118}, {117, 122, 31}, },
            {{46, 100, -81}, {101, 101, 119}, {102, 122, 31}, },
            {{46, 115, -65}, {116, 116, 120}, {117, 122, 31}, },
            {{46, 115, -65}, {116, 116, 121}, {117, 122, 31}, },
            {{46, 100, -81}, {101, 101, 122}, {102, 122, 31}, },
            {{46, 115, -65}, {116, 116, 123}, {117, 122, 31}, },
            {{46, 115, -65}, {116, 116, 124}, {117, 122, 31}, },
            {{46, 100, -81}, {101, 101, 125}, {102, 122, 31}, },
            {{46, 57, -11}, {65, 75, 29}, {76, 76, 126}, {77, 90, 29}, {95, 122, -11}, },
            {{116, 116, 127}, },
            {{84, 84, 128}, },
            {{46, 57, -11}, {58, 58, 129}, {65, 122, -11}, },
            {{46, 57, -11}, {65, 66, 29}, {67, 67, 130}, {68, 90, 29}, {95, 122, -11}, },
            {{46, 122, -11}, },
            {{46, 122, -11}, },
            {{46, 104, -87}, {105, 105, 131}, {106, 122, 31}, },
            {{46, 104, -87}, {105, 105, 132}, {106, 122, 31}, },
            {{46, 122, -11}, },
            {{46, 104, -87}, {105, 105, 133}, {106, 122, 31}, },
            {{46, 104, -87}, {105, 105, 134}, {106, 122, 31}, },
            {{46, 122, -11}, },
            {{46, 104, -87}, {105, 105, 135}, {106, 122, 31}, },
            {{46, 104, -87}, {105, 105, 136}, {106, 122, 31}, },
            {{46, 122, -11}, },
            {{46, 82, -62}, {83, 83, 137}, {84, 122, -62}, },
            {{101, 101, 138}, },
            {{105, 105, 139}, },
            {},
            {{46, 71, -12}, {72, 72, 140}, {73, 122, -12}, },
            {{46, 110, -42}, {111, 111, 141}, {112, 122, 31}, },
            {{46, 110, -42}, {111, 111, 142}, {112, 122, 31}, },
            {{46, 110, -42}, {111, 111, 143}, {112, 122, 31}, },
            {{46, 110, -42}, {111, 111, 144}, {112, 122, 31}, },
            {{46, 110, -42}, {111, 111, 145}, {112, 122, 31}, },
            {{46, 110, -42}, {111, 111, 146}, {112, 122, 31}, },
            {{46, 122, -11}, },
            {},
            {{109, 109, 147}, },
            {{46, 57, -11}, {65, 88, 29}, {89, 89, 148}, {90, 90, 29}, {95, 122, -11}, },
            {{46, 109, -13}, {110, 110, 149}, {111, 122, 31}, },
            {{46, 109, -13}, {110, 110, 150}, {111, 122, 31}, },
            {{46, 109, -13}, {110, 110, 151}, {111, 122, 31}, },
            {{46, 109, -13}, {110, 110, 152}, {111, 122, 31}, },
            {{46, 109, -13}, {110, 110, 153}, {111, 122, 31}, },
            {{46, 109, -13}, {110, 110, 154}, {111, 122, 31}, },
            {{101, 101, 155}, },
            {{46, 122, -11}, },
            {{46, 122, -11}, },
            {{46, 122, -11}, },
            {{46, 122, -11}, },
            {{46, 122, -11}, },
            {{46, 122, -11}, },
            {{46, 122, -11}, },
            {{58, 58, 156}, },
            {},
        }
    };*/

    private static int[][] accept;
/*  {
        // INITIAL
        {21, 23, 23, 23, 23, 21, 21, -1, 21, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 15, 16, 22, 22, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, -1, -1, 22, -1, -1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, -1, -1, 22, -1, -1, 22, 20, -1, 20, 20, 20, 20, 20, 1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, -1, 20, 20, 4, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, -1, -1, 20, 20, 17, 2, 20, 20, 11, 20, 20, 12, 20, 20, 13, 20, -1, -1, 18, 20, 20, 20, 20, 20, 20, 20, 3, 14, -1, 20, 20, 20, 20, 20, 20, 20, -1, 0, 5, 8, 6, 9, 7, 10, -1, 19, },

    };*/

    public static class State
    {
        public final static State INITIAL = new State(0);

        private int id;

        private State(int id)
        {
            this.id = id;
        }

        public int id()
        {
            return id;
        }
    }
}
