/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.media.j3d.AlternateAppearanceRetained;
import javax.media.j3d.AmbientLightRetained;
import javax.media.j3d.BackgroundRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.ClipRetained;
import javax.media.j3d.FogRetained;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.LightRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.ModelClipRetained;
import javax.media.j3d.MorphRetained;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.OrderedGroupRetained;
import javax.media.j3d.OrientedShape3DRetained;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.UnorderList;
import javax.media.j3d.UpdateTargets;
import javax.media.j3d.View;
import javax.media.j3d.ViewSpecificGroupRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Vector3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RenderingEnvironmentStructure
extends J3dStructure
implements ObjectUpdate {
    ArrayList<LightRetained> nonViewScopedLights = new ArrayList();
    HashMap<View, ArrayList<LightRetained>> viewScopedLights = new HashMap();
    int numberOfLights = 0;
    ArrayList<FogRetained> nonViewScopedFogs = new ArrayList();
    HashMap<View, ArrayList<FogRetained>> viewScopedFogs = new HashMap();
    int numberOfFogs = 0;
    ArrayList<AlternateAppearanceRetained> nonViewScopedAltAppearances = new ArrayList();
    HashMap<View, ArrayList<AlternateAppearanceRetained>> viewScopedAltAppearances = new HashMap();
    int numberOfAltApps = 0;
    ArrayList<ModelClipRetained> nonViewScopedModelClips = new ArrayList();
    HashMap<View, ArrayList<ModelClipRetained>> viewScopedModelClips = new HashMap();
    int numberOfModelClips = 0;
    ArrayList<BackgroundRetained> nonViewScopedBackgrounds = new ArrayList();
    HashMap<View, ArrayList<BackgroundRetained>> viewScopedBackgrounds = new HashMap();
    int numberOfBgs = 0;
    ArrayList<ClipRetained> nonViewScopedClips = new ArrayList();
    HashMap<View, ArrayList<ClipRetained>> viewScopedClips = new HashMap();
    int numberOfClips = 0;
    BackgroundRetained[] intersectedBacks = new BackgroundRetained[1];
    ClipRetained[] intersectedClips = new ClipRetained[1];
    Bounds[] intersectedBounds = new Bounds[1];
    Transform3D localeXform = new Transform3D();
    Vector3d localeTranslation = new Vector3d();
    Bounds localeBounds = null;
    FogRetained[] intersectedFogs = new FogRetained[1];
    AlternateAppearanceRetained[] intersectedAltApps = new AlternateAppearanceRetained[1];
    ModelClipRetained[] intersectedModelClips = new ModelClipRetained[1];
    double backClipDistance;
    ArrayList<Object[]> objList = new ArrayList();
    ArrayList<LeafRetained> xformChangeList = new ArrayList();
    private final ArrayList<Object[]> objFreeList = new ArrayList();
    LightRetained[] retlights = new LightRetained[5];
    boolean transformMsg = false;
    UpdateTargets targets = null;
    ArrayList blUsers = null;
    Integer ogInsert = new Integer(32);
    Integer ogRemove = new Integer(33);
    Object lockObj = new Object();

    RenderingEnvironmentStructure(VirtualUniverse virtualUniverse) {
        super(virtualUniverse, 4096);
    }

    Object[] getObjectArray() {
        int n = this.objFreeList.size();
        if (n == 0) {
            return new Object[5];
        }
        return this.objFreeList.remove(n - 1);
    }

    void addObjArrayToFreeList(Object[] objectArray) {
        Arrays.fill(objectArray, null);
        this.objFreeList.add(objectArray);
    }

    @Override
    public void updateObject() {
        int n;
        int n2 = this.objList.size();
        for (n = 0; n < n2; ++n) {
            Object[] objectArray = this.objList.get(n);
            LeafRetained leafRetained = (LeafRetained)objectArray[0];
            leafRetained.updateMirrorObject(objectArray);
            this.addObjArrayToFreeList(objectArray);
        }
        this.objList.clear();
        n2 = this.xformChangeList.size();
        for (n = 0; n < n2; ++n) {
            this.xformChangeList.get(n).updateTransformChange();
        }
        this.xformChangeList.clear();
    }

    @Override
    void processMessages(long l) {
        Object[] objectArray = this.getMessages(l);
        int n = this.getNumMessage();
        if (n <= 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            J3dMessage j3dMessage = objectArray[i];
            switch (j3dMessage.type) {
                case 0: {
                    this.insertNodes(j3dMessage);
                    break;
                }
                case 1: {
                    this.removeNodes(j3dMessage);
                    break;
                }
                case 19: {
                    this.updateLight(j3dMessage.args);
                    break;
                }
                case 23: {
                    this.updateBoundingLeaf(j3dMessage.args);
                    break;
                }
                case 22: {
                    this.updateFog(j3dMessage.args);
                    break;
                }
                case 41: {
                    this.updateAltApp(j3dMessage.args);
                    break;
                }
                case 24: {
                    this.updateShape3D(j3dMessage.args);
                    break;
                }
                case 46: {
                    this.updateOrientedShape3D(j3dMessage.args);
                    break;
                }
                case 16: {
                    this.updateMorph(j3dMessage.args);
                    break;
                }
                case 3: {
                    this.transformMsg = true;
                    break;
                }
                case 27: {
                    this.processSwitchChanged(j3dMessage);
                    if (!this.universe.transformStructure.getLazyUpdate()) break;
                    this.transformMsg = true;
                    break;
                }
                case 36: {
                    this.updateModelClip(j3dMessage.args);
                    break;
                }
                case 20: {
                    this.updateBackground(j3dMessage.args);
                    break;
                }
                case 21: {
                    this.updateClip(j3dMessage.args);
                    break;
                }
                case 32: {
                    this.updateOrderedGroupInserted(j3dMessage);
                    break;
                }
                case 33: {
                    this.updateOrderedGroupsRemoved(j3dMessage);
                    break;
                }
                case 56: {
                    this.updateViewSpecificGroupChanged(j3dMessage);
                    break;
                }
                case 57: {
                    this.initViewSpecificInfo(j3dMessage);
                    break;
                }
                case 58: {
                    this.clearViewSpecificInfo(j3dMessage);
                }
            }
            j3dMessage.decRefcount();
        }
        if (this.transformMsg) {
            this.updateTransformChange();
            this.transformMsg = false;
        }
        VirtualUniverse.mc.addMirrorObject(this);
        Arrays.fill(objectArray, 0, n, null);
    }

    void updateOrderedGroupInserted(J3dMessage j3dMessage) {
        Object[] objectArray = (Object[])j3dMessage.args[0];
        Object[] objectArray2 = (Object[])j3dMessage.args[1];
        Object[] objectArray3 = (Object[])j3dMessage.args[2];
        for (int i = 0; i < objectArray.length; ++i) {
            OrderedGroupRetained orderedGroupRetained = (OrderedGroupRetained)objectArray[i];
            orderedGroupRetained.updateChildIdTableInserted((Integer)objectArray2[i], (Integer)objectArray3[i]);
            orderedGroupRetained.incrChildCount();
        }
    }

    void updateOrderedGroupsRemoved(J3dMessage j3dMessage) {
        Object[] objectArray = (Object[])j3dMessage.args[0];
        Object[] objectArray2 = (Object[])j3dMessage.args[1];
        for (int i = 0; i < objectArray.length; ++i) {
            OrderedGroupRetained orderedGroupRetained = (OrderedGroupRetained)objectArray[i];
            orderedGroupRetained.updateChildIdTableRemoved((Integer)objectArray2[i]);
            orderedGroupRetained.decrChildCount();
        }
    }

    void processSwitchChanged(J3dMessage j3dMessage) {
        UpdateTargets updateTargets = (UpdateTargets)j3dMessage.args[0];
        UnorderList unorderList = updateTargets.targetList[5];
        if (unorderList != null) {
            Object[] objectArray = (Object[])j3dMessage.args[1];
            int n = unorderList.size();
            Object[] objectArray2 = unorderList.toArray(false);
            for (int i = 0; i < n; ++i) {
                Object[] objectArray3 = (Object[])objectArray2[i];
                Object[] objectArray4 = (Object[])objectArray[i];
                for (int j = 0; j < objectArray3.length; ++j) {
                    Object[] objectArray5 = (Object[])objectArray4[j];
                    BoundingLeafRetained boundingLeafRetained = (BoundingLeafRetained)objectArray3[j];
                    for (int k = 0; k < objectArray5.length; ++k) {
                        LeafRetained leafRetained = (LeafRetained)objectArray5[k];
                        if (!(leafRetained instanceof FogRetained) && !(leafRetained instanceof LightRetained) && !(leafRetained instanceof ModelClipRetained) && !(leafRetained instanceof ClipRetained) && !(leafRetained instanceof AlternateAppearanceRetained) && !(leafRetained instanceof BackgroundRetained)) continue;
                        leafRetained.updateBoundingLeaf();
                    }
                }
            }
        }
    }

    void insertNodes(J3dMessage j3dMessage) {
        int n;
        Object[] objectArray = (Object[])j3dMessage.args[0];
        ArrayList arrayList = (ArrayList)j3dMessage.args[3];
        ArrayList arrayList2 = (ArrayList)j3dMessage.args[4];
        for (n = 0; n < objectArray.length; ++n) {
            LeafRetained leafRetained;
            Object object = objectArray[n];
            if (object instanceof LightRetained) {
                leafRetained = (LightRetained)object;
                ++this.numberOfLights;
                if (leafRetained.inBackgroundGroup) {
                    leafRetained.geometryBackground.lights.add((LightRetained)leafRetained);
                    continue;
                }
                this.nonViewScopedLights.add((LightRetained)leafRetained);
                continue;
            }
            if (object instanceof FogRetained) {
                leafRetained = (FogRetained)object;
                ++this.numberOfFogs;
                if (((FogRetained)leafRetained).inBackgroundGroup) {
                    ((FogRetained)leafRetained).geometryBackground.fogs.add((FogRetained)leafRetained);
                    continue;
                }
                this.nonViewScopedFogs.add((FogRetained)leafRetained);
                continue;
            }
            if (object instanceof AlternateAppearanceRetained) {
                leafRetained = (AlternateAppearanceRetained)object;
                ++this.numberOfAltApps;
                this.nonViewScopedAltAppearances.add((AlternateAppearanceRetained)leafRetained);
                continue;
            }
            if (object instanceof BackgroundRetained) {
                leafRetained = (BackgroundRetained)object;
                ++this.numberOfBgs;
                this.nonViewScopedBackgrounds.add((BackgroundRetained)leafRetained);
                continue;
            }
            if (object instanceof ClipRetained) {
                leafRetained = (ClipRetained)object;
                ++this.numberOfClips;
                this.nonViewScopedClips.add((ClipRetained)leafRetained);
                continue;
            }
            if (!(object instanceof ModelClipRetained)) continue;
            leafRetained = (ModelClipRetained)object;
            ++this.numberOfModelClips;
            this.nonViewScopedModelClips.add((ModelClipRetained)leafRetained);
        }
        if (arrayList != null) {
            int n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                ArrayList<LeafRetained> arrayList3;
                View view;
                int n3;
                int n4;
                LeafRetained leafRetained;
                NodeRetained nodeRetained = (NodeRetained)arrayList.get(n);
                ArrayList arrayList4 = (ArrayList)arrayList2.get(n);
                if (nodeRetained instanceof LightRetained) {
                    leafRetained = (LightRetained)nodeRetained;
                    leafRetained.isViewScoped = true;
                    ++this.numberOfLights;
                    n4 = arrayList4.size();
                    for (n3 = 0; n3 < n4; ++n3) {
                        view = (View)arrayList4.get(n3);
                        arrayList3 = this.viewScopedLights.get(view);
                        if (arrayList3 == null) {
                            arrayList3 = new ArrayList();
                            this.viewScopedLights.put(view, arrayList3);
                        }
                        arrayList3.add(leafRetained);
                    }
                    continue;
                }
                if (nodeRetained instanceof FogRetained) {
                    leafRetained = (FogRetained)nodeRetained;
                    ((FogRetained)leafRetained).isViewScoped = true;
                    ++this.numberOfFogs;
                    n4 = arrayList4.size();
                    for (n3 = 0; n3 < n4; ++n3) {
                        view = (View)arrayList4.get(n3);
                        arrayList3 = this.viewScopedFogs.get(view);
                        if (arrayList3 == null) {
                            arrayList3 = new ArrayList();
                            this.viewScopedFogs.put(view, arrayList3);
                        }
                        arrayList3.add(leafRetained);
                    }
                    continue;
                }
                if (nodeRetained instanceof AlternateAppearanceRetained) {
                    leafRetained = (AlternateAppearanceRetained)nodeRetained;
                    ((AlternateAppearanceRetained)leafRetained).isViewScoped = true;
                    ++this.numberOfAltApps;
                    n4 = arrayList4.size();
                    for (n3 = 0; n3 < n4; ++n3) {
                        view = (View)arrayList4.get(n3);
                        arrayList3 = this.viewScopedAltAppearances.get(view);
                        if (arrayList3 == null) {
                            arrayList3 = new ArrayList();
                            this.viewScopedAltAppearances.put(view, arrayList3);
                        }
                        arrayList3.add(leafRetained);
                    }
                    continue;
                }
                if (nodeRetained instanceof BackgroundRetained) {
                    leafRetained = (BackgroundRetained)nodeRetained;
                    ((BackgroundRetained)leafRetained).isViewScoped = true;
                    ++this.numberOfBgs;
                    n4 = arrayList4.size();
                    for (n3 = 0; n3 < n4; ++n3) {
                        view = (View)arrayList4.get(n3);
                        arrayList3 = this.viewScopedBackgrounds.get(view);
                        if (arrayList3 == null) {
                            arrayList3 = new ArrayList();
                            this.viewScopedBackgrounds.put(view, arrayList3);
                        }
                        arrayList3.add(leafRetained);
                    }
                    continue;
                }
                if (nodeRetained instanceof ClipRetained) {
                    leafRetained = (ClipRetained)nodeRetained;
                    ((ClipRetained)leafRetained).isViewScoped = true;
                    ++this.numberOfClips;
                    n4 = arrayList4.size();
                    for (n3 = 0; n3 < n4; ++n3) {
                        view = (View)arrayList4.get(n3);
                        arrayList3 = this.viewScopedClips.get(view);
                        if (arrayList3 == null) {
                            arrayList3 = new ArrayList();
                            this.viewScopedClips.put(view, arrayList3);
                        }
                        arrayList3.add(leafRetained);
                    }
                    continue;
                }
                if (!(nodeRetained instanceof ModelClipRetained)) continue;
                leafRetained = (ModelClipRetained)nodeRetained;
                ((ModelClipRetained)leafRetained).isViewScoped = true;
                ++this.numberOfModelClips;
                n4 = arrayList4.size();
                for (n3 = 0; n3 < n4; ++n3) {
                    view = (View)arrayList4.get(n3);
                    arrayList3 = this.viewScopedModelClips.get(view);
                    if (arrayList3 == null) {
                        arrayList3 = new ArrayList();
                        this.viewScopedModelClips.put(view, arrayList3);
                    }
                    arrayList3.add(leafRetained);
                }
            }
        }
        if (this.numberOfLights > this.retlights.length) {
            this.retlights = new LightRetained[this.numberOfLights];
        }
        if (this.intersectedFogs.length < this.numberOfFogs) {
            this.intersectedFogs = new FogRetained[this.numberOfFogs];
        }
        if (this.intersectedAltApps.length < this.numberOfAltApps) {
            this.intersectedAltApps = new AlternateAppearanceRetained[this.numberOfAltApps];
        }
        if (this.intersectedBacks.length < this.numberOfBgs) {
            this.intersectedBacks = new BackgroundRetained[this.numberOfBgs];
        }
        if (this.intersectedClips.length < this.numberOfClips) {
            this.intersectedClips = new ClipRetained[this.numberOfClips];
        }
        if (this.intersectedModelClips.length < this.numberOfModelClips) {
            this.intersectedModelClips = new ModelClipRetained[this.numberOfModelClips];
        }
    }

    @Override
    void removeNodes(J3dMessage j3dMessage) {
        int n;
        Object[] objectArray = (Object[])j3dMessage.args[0];
        ArrayList arrayList = (ArrayList)j3dMessage.args[3];
        ArrayList arrayList2 = (ArrayList)j3dMessage.args[4];
        Shape3DRetained shape3DRetained = null;
        for (n = 0; n < objectArray.length; ++n) {
            LeafRetained leafRetained;
            Object object = objectArray[n];
            if (object instanceof LightRetained) {
                leafRetained = (LightRetained)object;
                if (leafRetained.inBackgroundGroup) {
                    leafRetained.geometryBackground.lights.remove(leafRetained);
                } else {
                    this.nonViewScopedLights.remove(leafRetained);
                }
                --this.numberOfLights;
                continue;
            }
            if (object instanceof FogRetained) {
                --this.numberOfFogs;
                leafRetained = (FogRetained)object;
                if (((FogRetained)leafRetained).inBackgroundGroup) {
                    ((FogRetained)leafRetained).geometryBackground.fogs.remove(leafRetained);
                    continue;
                }
                this.nonViewScopedFogs.remove(this.nonViewScopedFogs.indexOf(object));
                continue;
            }
            if (object instanceof AlternateAppearanceRetained) {
                --this.numberOfAltApps;
                this.nonViewScopedAltAppearances.remove(this.nonViewScopedAltAppearances.indexOf(object));
                continue;
            }
            if (object instanceof BackgroundRetained) {
                --this.numberOfBgs;
                this.nonViewScopedBackgrounds.remove(this.nonViewScopedBackgrounds.indexOf(object));
                continue;
            }
            if (object instanceof ClipRetained) {
                --this.numberOfClips;
                this.nonViewScopedClips.remove(this.nonViewScopedClips.indexOf(object));
                continue;
            }
            if (object instanceof ModelClipRetained) {
                leafRetained = (ModelClipRetained)object;
                --this.numberOfModelClips;
                this.nonViewScopedModelClips.remove(leafRetained);
                continue;
            }
            if (object instanceof GeometryAtom) {
                GeometryAtom geometryAtom = (GeometryAtom)object;
                if (geometryAtom.source == shape3DRetained) continue;
                geometryAtom.source.clearMirrorShape();
                shape3DRetained = geometryAtom.source;
                continue;
            }
            if (!(object instanceof OrderedGroupRetained)) continue;
            ((OrderedGroupRetained)object).clearDerivedDataStructures();
        }
        if (arrayList != null) {
            int n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                ArrayList<LeafRetained> arrayList3;
                View view;
                int n3;
                int n4;
                LeafRetained leafRetained;
                NodeRetained nodeRetained = (NodeRetained)arrayList.get(n);
                ArrayList arrayList4 = (ArrayList)arrayList2.get(n);
                if (nodeRetained instanceof LightRetained) {
                    leafRetained = (LightRetained)nodeRetained;
                    leafRetained.isViewScoped = false;
                    --this.numberOfLights;
                    n4 = arrayList4.size();
                    for (n3 = 0; n3 < n4; ++n3) {
                        view = (View)arrayList4.get(n3);
                        arrayList3 = this.viewScopedLights.get(view);
                        arrayList3.remove(leafRetained);
                        if (arrayList3.size() != 0) continue;
                        this.viewScopedLights.remove(view);
                    }
                    continue;
                }
                if (nodeRetained instanceof FogRetained) {
                    leafRetained = (FogRetained)nodeRetained;
                    ((FogRetained)leafRetained).isViewScoped = false;
                    --this.numberOfFogs;
                    n4 = arrayList4.size();
                    for (n3 = 0; n3 < n4; ++n3) {
                        view = (View)arrayList4.get(n3);
                        arrayList3 = this.viewScopedFogs.get(view);
                        arrayList3.remove(leafRetained);
                        if (arrayList3.size() != 0) continue;
                        this.viewScopedFogs.remove(view);
                    }
                    continue;
                }
                if (nodeRetained instanceof AlternateAppearanceRetained) {
                    leafRetained = (AlternateAppearanceRetained)nodeRetained;
                    ((AlternateAppearanceRetained)leafRetained).isViewScoped = false;
                    --this.numberOfAltApps;
                    n4 = arrayList4.size();
                    for (n3 = 0; n3 < n4; ++n3) {
                        view = (View)arrayList4.get(n3);
                        arrayList3 = this.viewScopedAltAppearances.get(view);
                        arrayList3.remove(leafRetained);
                        if (arrayList3.size() != 0) continue;
                        this.viewScopedAltAppearances.remove(view);
                    }
                    continue;
                }
                if (nodeRetained instanceof BackgroundRetained) {
                    leafRetained = (BackgroundRetained)nodeRetained;
                    ((BackgroundRetained)leafRetained).isViewScoped = false;
                    --this.numberOfBgs;
                    n4 = arrayList4.size();
                    for (n3 = 0; n3 < n4; ++n3) {
                        view = (View)arrayList4.get(n3);
                        arrayList3 = this.viewScopedBackgrounds.get(view);
                        arrayList3.remove(leafRetained);
                        if (arrayList3.size() != 0) continue;
                        this.viewScopedBackgrounds.remove(view);
                    }
                    continue;
                }
                if (nodeRetained instanceof ClipRetained) {
                    leafRetained = (ClipRetained)nodeRetained;
                    ((ClipRetained)leafRetained).isViewScoped = false;
                    --this.numberOfClips;
                    n4 = arrayList4.size();
                    for (n3 = 0; n3 < n4; ++n3) {
                        view = (View)arrayList4.get(n3);
                        arrayList3 = this.viewScopedClips.get(view);
                        arrayList3.remove(leafRetained);
                        if (arrayList3.size() != 0) continue;
                        this.viewScopedClips.remove(view);
                    }
                    continue;
                }
                if (!(nodeRetained instanceof ModelClipRetained)) continue;
                leafRetained = (ModelClipRetained)nodeRetained;
                ((ModelClipRetained)leafRetained).isViewScoped = false;
                --this.numberOfModelClips;
                n4 = arrayList4.size();
                for (n3 = 0; n3 < n4; ++n3) {
                    view = (View)arrayList4.get(n3);
                    arrayList3 = this.viewScopedModelClips.get(view);
                    arrayList3.remove(leafRetained);
                    if (arrayList3.size() != 0) continue;
                    this.viewScopedModelClips.remove(view);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LightRetained[] getInfluencingLights(RenderAtom renderAtom, View view) {
        LightRetained[] lightRetainedArray = null;
        LightRetained[] lightRetainedArray2 = this.retlights;
        synchronized (this.retlights) {
            int n;
            ArrayList<LightRetained> arrayList;
            int n2 = 0;
            if (renderAtom.geometryAtom.source.inBackgroundGroup) {
                arrayList = renderAtom.geometryAtom.source.geometryBackground.lights;
                n2 = this.processLights(arrayList, renderAtom, n2);
            } else {
                arrayList = this.viewScopedLights.get(view);
                if (arrayList != null) {
                    n2 = this.processLights(arrayList, renderAtom, n2);
                }
                n2 = this.processLights(this.nonViewScopedLights, renderAtom, n2);
            }
            boolean bl = false;
            if (renderAtom.lights != null && renderAtom.lights.length == n2) {
                for (n = 0; n < renderAtom.lights.length; ++n) {
                    int n3;
                    for (n3 = 0; n3 < n2 && renderAtom.lights[n] != this.retlights[n3]; ++n3) {
                    }
                    if (n3 != n2) continue;
                    bl = true;
                    break;
                }
            } else {
                bl = true;
            }
            if (bl) {
                lightRetainedArray = new LightRetained[n2];
                for (n = 0; n < n2; ++n) {
                    lightRetainedArray[n] = this.retlights[n];
                }
                // ** MonitorExit[var6_4] (shouldn't be in output)
                return lightRetainedArray;
            }
            // ** MonitorExit[var6_4] (shouldn't be in output)
            return renderAtom.lights;
        }
    }

    private int processLights(ArrayList<LightRetained> arrayList, RenderAtom renderAtom, int n) {
        BoundingBox boundingBox = renderAtom.localeVwcBounds;
        int n2 = arrayList.size();
        if (n2 > 0) {
            block0: for (int i = 0; i < n2; ++i) {
                LightRetained lightRetained = arrayList.get(i);
                if (!lightRetained.lightOn || !lightRetained.switchState.currentSwitchOn || !renderAtom.geometryAtom.source.inBackgroundGroup && !((Bounds)boundingBox).intersect(lightRetained.region)) continue;
                int n3 = renderAtom.geometryAtom.source.numlights;
                LightRetained[] lightRetainedArray = renderAtom.geometryAtom.source.lights;
                if (lightRetained.isScoped) {
                    for (int j = 0; j < n3; ++j) {
                        if (lightRetained != lightRetainedArray[j]) continue;
                        this.retlights[n++] = lightRetained;
                        continue block0;
                    }
                    continue;
                }
                this.retlights[n++] = lightRetained;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FogRetained getInfluencingFog(RenderAtom renderAtom, View view) {
        FogRetained fogRetained = null;
        Object object = this.lockObj;
        synchronized (object) {
            block10: {
                BoundingBox boundingBox;
                int n;
                block9: {
                    n = 0;
                    boundingBox = renderAtom.localeVwcBounds;
                    if (this.intersectedBounds.length < this.numberOfFogs) {
                        this.intersectedBounds = new Bounds[this.numberOfFogs];
                    }
                    if (!renderAtom.geometryAtom.source.inBackgroundGroup) break block9;
                    ArrayList<FogRetained> arrayList = renderAtom.geometryAtom.source.geometryBackground.fogs;
                    if ((n = this.processFogs(arrayList, renderAtom, n)) < 1) break block10;
                    fogRetained = this.intersectedFogs[0];
                    break block10;
                }
                ArrayList<FogRetained> arrayList = this.viewScopedFogs.get(view);
                if (arrayList != null) {
                    n = this.processFogs(arrayList, renderAtom, n);
                }
                if ((n = this.processFogs(this.nonViewScopedFogs, renderAtom, n)) == 1) {
                    fogRetained = this.intersectedFogs[0];
                } else if (n > 1) {
                    Bounds bounds = ((Bounds)boundingBox).closestIntersection(this.intersectedBounds);
                    for (int i = 0; i < n; ++i) {
                        if (this.intersectedBounds[i] != bounds) continue;
                        fogRetained = this.intersectedFogs[i];
                        break;
                    }
                }
            }
            return fogRetained;
        }
    }

    int processFogs(ArrayList<FogRetained> arrayList, RenderAtom renderAtom, int n) {
        int n2 = arrayList.size();
        BoundingBox boundingBox = renderAtom.localeVwcBounds;
        if (arrayList.size() > 0) {
            block0: for (int i = 0; i < n2; ++i) {
                FogRetained fogRetained = arrayList.get(i);
                if (fogRetained.region == null || !fogRetained.switchState.currentSwitchOn || !renderAtom.geometryAtom.source.inBackgroundGroup && !fogRetained.region.intersect(boundingBox)) continue;
                int n3 = renderAtom.geometryAtom.source.numfogs;
                FogRetained[] fogRetainedArray = renderAtom.geometryAtom.source.fogs;
                if (fogRetained.isScoped) {
                    for (int j = 0; j < n3; ++j) {
                        if (fogRetained != fogRetainedArray[j]) continue;
                        this.intersectedBounds[n] = fogRetained.region;
                        this.intersectedFogs[n++] = fogRetained;
                        continue block0;
                    }
                    continue;
                }
                this.intersectedBounds[n] = fogRetained.region;
                this.intersectedFogs[n++] = fogRetained;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ModelClipRetained getInfluencingModelClip(RenderAtom renderAtom, View view) {
        if (renderAtom.geometryAtom.source.inBackgroundGroup) {
            return null;
        }
        Object object = this.lockObj;
        synchronized (object) {
            ArrayList<ModelClipRetained> arrayList;
            BoundingBox boundingBox = renderAtom.localeVwcBounds;
            int n = 0;
            if (this.intersectedBounds.length < this.numberOfModelClips) {
                this.intersectedBounds = new Bounds[this.numberOfModelClips];
            }
            if ((arrayList = this.viewScopedModelClips.get(view)) != null) {
                n = this.processModelClips(arrayList, renderAtom, n);
            }
            n = this.processModelClips(this.nonViewScopedModelClips, renderAtom, n);
            ModelClipRetained modelClipRetained = null;
            if (n == 1) {
                modelClipRetained = this.intersectedModelClips[0];
            } else if (n > 1) {
                Bounds bounds = ((Bounds)boundingBox).closestIntersection(this.intersectedBounds);
                for (int i = 0; i < n; ++i) {
                    if (this.intersectedBounds[i] != bounds) continue;
                    modelClipRetained = this.intersectedModelClips[i];
                    break;
                }
            }
            return modelClipRetained;
        }
    }

    int processModelClips(ArrayList<ModelClipRetained> arrayList, RenderAtom renderAtom, int n) {
        int n2 = arrayList.size();
        BoundingBox boundingBox = renderAtom.localeVwcBounds;
        if (n2 > 0) {
            block0: for (int i = 0; i < n2; ++i) {
                ModelClipRetained modelClipRetained = arrayList.get(i);
                if (!modelClipRetained.enableFlag || modelClipRetained.region == null || !modelClipRetained.switchState.currentSwitchOn || !modelClipRetained.region.intersect(boundingBox)) continue;
                int n3 = renderAtom.geometryAtom.source.numModelClips;
                ModelClipRetained[] modelClipRetainedArray = renderAtom.geometryAtom.source.modelClips;
                if (modelClipRetained.isScoped) {
                    for (int j = 0; j < n3; ++j) {
                        if (modelClipRetainedArray[j] != modelClipRetained) continue;
                        this.intersectedBounds[n] = modelClipRetained.region;
                        this.intersectedModelClips[n++] = modelClipRetained;
                        continue block0;
                    }
                    continue;
                }
                this.intersectedBounds[n] = modelClipRetained.region;
                this.intersectedModelClips[n++] = modelClipRetained;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BackgroundRetained getApplicationBackground(BoundingSphere boundingSphere, Locale locale, View view) {
        BackgroundRetained backgroundRetained = null;
        int n = 0;
        Object object = this.lockObj;
        synchronized (object) {
            ArrayList<BackgroundRetained> arrayList;
            int n2 = 0;
            if (this.intersectedBounds.length < this.numberOfBgs) {
                this.intersectedBounds = new Bounds[this.numberOfBgs];
            }
            if ((arrayList = this.viewScopedBackgrounds.get(view)) != null) {
                n2 = this.processBgs(arrayList, boundingSphere, n2, locale);
            }
            if ((n2 = this.processBgs(this.nonViewScopedBackgrounds, boundingSphere, n2, locale)) == 1) {
                backgroundRetained = this.intersectedBacks[0];
            } else if (n2 > 1) {
                Bounds bounds = boundingSphere.closestIntersection(this.intersectedBounds);
                for (n = 0; n < n2; ++n) {
                    if (this.intersectedBounds[n] != bounds) continue;
                    backgroundRetained = this.intersectedBacks[n];
                    break;
                }
            }
            return backgroundRetained;
        }
    }

    int processBgs(ArrayList arrayList, BoundingSphere boundingSphere, int n, Locale locale) {
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            BackgroundRetained backgroundRetained = (BackgroundRetained)arrayList.get(i);
            if (backgroundRetained.transformedRegion == null || !backgroundRetained.switchState.currentSwitchOn) continue;
            if (backgroundRetained.cachedLocale != locale) {
                this.localeBounds = (Bounds)backgroundRetained.transformedRegion.clone();
                backgroundRetained.cachedLocale.hiRes.difference(locale.hiRes, this.localeTranslation);
                this.localeXform.setIdentity();
                this.localeXform.setTranslation(this.localeTranslation);
                this.localeBounds.transform(this.localeXform);
                if (!this.localeBounds.intersect(boundingSphere)) continue;
                this.intersectedBounds[n] = this.localeBounds;
                this.intersectedBacks[n++] = backgroundRetained;
                continue;
            }
            if (!backgroundRetained.transformedRegion.intersect(boundingSphere)) continue;
            this.intersectedBounds[n] = backgroundRetained.transformedRegion;
            this.intersectedBacks[n++] = backgroundRetained;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double[] backClipDistanceInVworld(BoundingSphere boundingSphere, View view) {
        Object object = this.lockObj;
        synchronized (object) {
            ArrayList<ClipRetained> arrayList;
            double[] dArray = null;
            boolean bl = false;
            int n = 0;
            double d = 0.0;
            if (this.intersectedBounds.length < this.numberOfClips) {
                this.intersectedBounds = new Bounds[this.numberOfClips];
            }
            if ((arrayList = this.viewScopedClips.get(view)) != null) {
                n = this.processClips(arrayList, boundingSphere, n);
            }
            if ((n = this.processClips(this.nonViewScopedClips, boundingSphere, n)) == 1) {
                d = this.intersectedClips[0].backDistanceInVworld;
                bl = true;
            } else if (n > 1) {
                Bounds bounds = boundingSphere.closestIntersection(this.intersectedBounds);
                for (int i = 0; i < n; ++i) {
                    if (this.intersectedBounds[i] != bounds) continue;
                    d = this.intersectedClips[i].backDistanceInVworld;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                dArray = new double[]{d};
            }
            return dArray;
        }
    }

    int processClips(ArrayList arrayList, BoundingSphere boundingSphere, int n) {
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            ClipRetained clipRetained = (ClipRetained)arrayList.get(i);
            if (clipRetained.transformedRegion == null || !clipRetained.transformedRegion.intersect(boundingSphere) || !clipRetained.switchState.currentSwitchOn) continue;
            this.intersectedBounds[n] = clipRetained.transformedRegion;
            this.intersectedClips[n++] = clipRetained;
        }
        return n;
    }

    void updateLight(Object[] objectArray) {
        LightRetained lightRetained = (LightRetained)objectArray[0];
        int n = (Integer)objectArray[1];
        if ((n & 0x20) != 0) {
            lightRetained.initMirrorObject(objectArray);
        }
        if (lightRetained instanceof AmbientLightRetained && (n & 8) != 0) {
            lightRetained.updateImmediateMirrorObject(objectArray);
        } else if ((n & 0xFA8) != 0) {
            Object[] objectArray2 = this.getObjectArray();
            objectArray2[0] = objectArray[0];
            objectArray2[1] = objectArray[1];
            objectArray2[2] = objectArray[2];
            objectArray2[3] = objectArray[3];
            objectArray2[4] = objectArray[4];
            this.objList.add(objectArray2);
        } else if ((n & 0x40) != 0) {
            lightRetained.clearMirrorObject(objectArray);
        } else {
            lightRetained.updateImmediateMirrorObject(objectArray);
        }
    }

    void updateBackground(Object[] objectArray) {
        BackgroundRetained backgroundRetained = (BackgroundRetained)objectArray[0];
        backgroundRetained.updateImmediateMirrorObject(objectArray);
    }

    void updateFog(Object[] objectArray) {
        FogRetained fogRetained = (FogRetained)objectArray[0];
        int n = (Integer)objectArray[1];
        if ((n & 0x10) != 0) {
            fogRetained.initMirrorObject(objectArray);
            Object[] objectArray2 = this.getObjectArray();
            objectArray2[0] = objectArray[0];
            objectArray2[1] = objectArray[1];
            objectArray2[2] = objectArray[2];
            objectArray2[3] = objectArray[3];
            objectArray2[4] = objectArray[4];
            this.objList.add(objectArray2);
        } else if ((n & 0x20) != 0) {
            fogRetained.clearMirrorObject(objectArray);
        } else if ((n & 0xC1) != 0) {
            Object[] objectArray3 = this.getObjectArray();
            objectArray3[0] = objectArray[0];
            objectArray3[1] = objectArray[1];
            objectArray3[2] = objectArray[2];
            objectArray3[3] = objectArray[3];
            objectArray3[4] = objectArray[4];
            this.objList.add(objectArray3);
        } else {
            fogRetained.updateImmediateMirrorObject(objectArray);
        }
    }

    void updateAltApp(Object[] objectArray) {
        AlternateAppearanceRetained alternateAppearanceRetained = (AlternateAppearanceRetained)objectArray[0];
        int n = (Integer)objectArray[1];
        if ((n & 0x10) != 0) {
            AlternateAppearanceRetained alternateAppearanceRetained2 = (AlternateAppearanceRetained)objectArray[0];
            alternateAppearanceRetained2.initMirrorObject(objectArray);
        } else if ((n & 0x20) != 0) {
            AlternateAppearanceRetained alternateAppearanceRetained3 = (AlternateAppearanceRetained)objectArray[0];
            alternateAppearanceRetained3.clearMirrorObject(objectArray);
        } else {
            alternateAppearanceRetained.updateImmediateMirrorObject(objectArray);
        }
    }

    void updateClip(Object[] objectArray) {
        ClipRetained clipRetained = (ClipRetained)objectArray[0];
        clipRetained.updateImmediateMirrorObject(objectArray);
    }

    void updateModelClip(Object[] objectArray) {
        ModelClipRetained modelClipRetained = (ModelClipRetained)objectArray[0];
        int n = (Integer)objectArray[1];
        if ((n & 0x80) != 0) {
            modelClipRetained.initMirrorObject(objectArray);
        }
        if ((n & 0x100) != 0) {
            modelClipRetained.clearMirrorObject(objectArray);
        } else if ((n & 0x83) != 0) {
            Object[] objectArray2 = this.getObjectArray();
            objectArray2[0] = objectArray[0];
            objectArray2[1] = objectArray[1];
            objectArray2[2] = objectArray[2];
            objectArray2[3] = objectArray[3];
            objectArray2[4] = objectArray[4];
            this.objList.add(objectArray2);
        } else {
            modelClipRetained.updateImmediateMirrorObject(objectArray);
        }
    }

    void updateBoundingLeaf(Object[] objectArray) {
        BoundingLeafRetained boundingLeafRetained = (BoundingLeafRetained)objectArray[0];
        Object[] objectArray2 = (Object[])objectArray[3];
        boundingLeafRetained.updateImmediateMirrorObject(objectArray);
        for (int i = 0; i < objectArray2.length; ++i) {
            LeafRetained leafRetained = (LeafRetained)objectArray2[i];
            leafRetained.updateBoundingLeaf();
        }
    }

    void updateShape3D(Object[] objectArray) {
        Shape3DRetained shape3DRetained = (Shape3DRetained)objectArray[0];
        shape3DRetained.updateImmediateMirrorObject(objectArray);
    }

    void updateOrientedShape3D(Object[] objectArray) {
        OrientedShape3DRetained orientedShape3DRetained = (OrientedShape3DRetained)objectArray[4];
        orientedShape3DRetained.updateImmediateMirrorObject(objectArray);
    }

    void updateMorph(Object[] objectArray) {
        MorphRetained morphRetained = (MorphRetained)objectArray[0];
        morphRetained.updateImmediateMirrorObject(objectArray);
    }

    void updateTransformChange() {
        LeafRetained leafRetained;
        int n;
        Object[] objectArray;
        int n2;
        Object[] objectArray2;
        int n3;
        this.targets = this.universe.transformStructure.getTargetList();
        this.blUsers = this.universe.transformStructure.getBlUsers();
        UnorderList unorderList = this.targets.targetList[1];
        if (unorderList != null) {
            n3 = unorderList.size();
            objectArray2 = unorderList.toArray(false);
            for (n2 = 0; n2 < n3; ++n2) {
                objectArray = (Object[])objectArray2[n2];
                for (n = 0; n < objectArray.length; ++n) {
                    if (objectArray[n] instanceof LightRetained) {
                        leafRetained = (LightRetained)objectArray[n];
                        ((LightRetained)leafRetained).updateImmediateTransformChange();
                        this.xformChangeList.add(leafRetained);
                        continue;
                    }
                    if (objectArray[n] instanceof FogRetained) {
                        leafRetained = (FogRetained)objectArray[n];
                        ((FogRetained)leafRetained).updateImmediateTransformChange();
                        this.xformChangeList.add(leafRetained);
                        continue;
                    }
                    if (objectArray[n] instanceof AlternateAppearanceRetained) {
                        leafRetained = (AlternateAppearanceRetained)objectArray[n];
                        ((AlternateAppearanceRetained)leafRetained).updateImmediateTransformChange();
                        this.xformChangeList.add(leafRetained);
                        continue;
                    }
                    if (objectArray[n] instanceof BackgroundRetained) {
                        leafRetained = (BackgroundRetained)objectArray[n];
                        ((BackgroundRetained)leafRetained).updateImmediateTransformChange();
                        continue;
                    }
                    if (!(objectArray[n] instanceof ModelClipRetained)) continue;
                    leafRetained = (ModelClipRetained)objectArray[n];
                    ((ModelClipRetained)leafRetained).updateImmediateTransformChange();
                }
            }
        }
        if ((unorderList = this.targets.targetList[5]) != null) {
            n3 = unorderList.size();
            objectArray2 = unorderList.toArray(false);
            for (n2 = 0; n2 < n3; ++n2) {
                objectArray = (Object[])objectArray2[n2];
                for (n = 0; n < objectArray.length; ++n) {
                    BoundingLeafRetained boundingLeafRetained = (BoundingLeafRetained)objectArray[n];
                    boundingLeafRetained.updateImmediateTransformChange();
                }
            }
        }
        if (this.blUsers != null) {
            for (n = 0; n < this.blUsers.size(); ++n) {
                leafRetained = (LeafRetained)this.blUsers.get(n);
                leafRetained.updateBoundingLeaf();
            }
        }
        this.targets = null;
        this.blUsers = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] getInfluencingAppearance(RenderAtom renderAtom, View view) {
        AlternateAppearanceRetained alternateAppearanceRetained = null;
        Object[] objectArray = new Object[2];
        if (renderAtom.geometryAtom.source.inBackgroundGroup) {
            objectArray[0] = Boolean.FALSE;
            return objectArray;
        }
        Object object = this.lockObj;
        synchronized (object) {
            ArrayList<AlternateAppearanceRetained> arrayList;
            int n = 0;
            BoundingBox boundingBox = renderAtom.localeVwcBounds;
            if (this.intersectedBounds.length < this.numberOfAltApps) {
                this.intersectedBounds = new Bounds[this.numberOfAltApps];
            }
            if ((arrayList = this.viewScopedAltAppearances.get(view)) != null) {
                n = this.processAltApps(arrayList, renderAtom, n);
            }
            n = this.processAltApps(this.nonViewScopedAltAppearances, renderAtom, n);
            alternateAppearanceRetained = null;
            if (n == 1) {
                alternateAppearanceRetained = this.intersectedAltApps[0];
            } else if (n > 1) {
                Bounds bounds = ((Bounds)boundingBox).closestIntersection(this.intersectedBounds);
                for (int i = 0; i < n; ++i) {
                    if (this.intersectedBounds[i] != bounds) continue;
                    alternateAppearanceRetained = this.intersectedAltApps[i];
                    break;
                }
            }
            if (alternateAppearanceRetained == null) {
                objectArray[0] = Boolean.FALSE;
                return objectArray;
            }
            objectArray[0] = Boolean.TRUE;
            objectArray[1] = alternateAppearanceRetained.appearance;
            return objectArray;
        }
    }

    int processAltApps(ArrayList arrayList, RenderAtom renderAtom, int n) {
        int n2 = arrayList.size();
        BoundingBox boundingBox = renderAtom.localeVwcBounds;
        if (n2 > 0) {
            block0: for (int i = 0; i < n2; ++i) {
                AlternateAppearanceRetained alternateAppearanceRetained = (AlternateAppearanceRetained)arrayList.get(i);
                if (alternateAppearanceRetained.region == null || !alternateAppearanceRetained.switchState.currentSwitchOn || !alternateAppearanceRetained.region.intersect(boundingBox)) continue;
                int n3 = renderAtom.geometryAtom.source.numAltApps;
                AlternateAppearanceRetained[] alternateAppearanceRetainedArray = renderAtom.geometryAtom.source.altApps;
                if (alternateAppearanceRetained.isScoped) {
                    for (int j = 0; j < n3; ++j) {
                        if (alternateAppearanceRetained != alternateAppearanceRetainedArray[j]) continue;
                        this.intersectedBounds[n] = alternateAppearanceRetained.region;
                        this.intersectedAltApps[n++] = alternateAppearanceRetained;
                        continue block0;
                    }
                    continue;
                }
                this.intersectedBounds[n] = alternateAppearanceRetained.region;
                this.intersectedAltApps[n++] = alternateAppearanceRetained;
            }
        }
        return n;
    }

    void initViewSpecificInfo(J3dMessage j3dMessage) {
        int[] nArray = (int[])j3dMessage.args[2];
        ArrayList arrayList = (ArrayList)j3dMessage.args[1];
        ArrayList arrayList2 = (ArrayList)j3dMessage.args[0];
        if (arrayList2 != null) {
            int n = arrayList2.size();
            for (int i = 0; i < n; ++i) {
                ViewSpecificGroupRetained viewSpecificGroupRetained = (ViewSpecificGroupRetained)arrayList2.get(i);
                ArrayList arrayList3 = (ArrayList)arrayList.get(i);
                int n2 = nArray[i];
                viewSpecificGroupRetained.cachedViewList.add(n2, arrayList3);
            }
        }
    }

    void clearViewSpecificInfo(J3dMessage j3dMessage) {
        int[] nArray = (int[])j3dMessage.args[1];
        ArrayList arrayList = (ArrayList)j3dMessage.args[0];
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ViewSpecificGroupRetained viewSpecificGroupRetained = (ViewSpecificGroupRetained)arrayList.get(i);
                int n2 = nArray[i];
                if (n2 == -1) {
                    int n3 = viewSpecificGroupRetained.cachedViewList.size();
                    for (int j = 0; j < n3; ++j) {
                        ArrayList arrayList2 = (ArrayList)viewSpecificGroupRetained.cachedViewList.get(j);
                        arrayList2.clear();
                    }
                    viewSpecificGroupRetained.cachedViewList.clear();
                    continue;
                }
                ArrayList arrayList3 = (ArrayList)viewSpecificGroupRetained.cachedViewList.remove(n2);
                arrayList3.clear();
            }
        }
    }

    void updateViewSpecificGroupChanged(J3dMessage j3dMessage) {
        Object e;
        Object object;
        NodeRetained nodeRetained;
        int n;
        int n2;
        Object object2;
        Object object3;
        ArrayList arrayList;
        Object object4;
        int n3 = (Integer)j3dMessage.args[0];
        Object[] objectArray = (Object[])j3dMessage.args[1];
        ArrayList<LightRetained> arrayList2 = null;
        ArrayList<FogRetained> arrayList3 = null;
        ArrayList<ModelClipRetained> arrayList4 = null;
        ArrayList<AlternateAppearanceRetained> arrayList5 = null;
        ArrayList<BackgroundRetained> arrayList6 = null;
        ArrayList<ClipRetained> arrayList7 = null;
        if ((n3 & 2) != 0 || (n3 & 1) != 0) {
            object4 = (View)objectArray[0];
            arrayList = (ArrayList)objectArray[1];
            object3 = (ArrayList)objectArray[2];
            object2 = (int[])objectArray[3];
            n2 = arrayList.size();
            if (object4 != null) {
                for (n = 0; n < n2; ++n) {
                    nodeRetained = (ViewSpecificGroupRetained)arrayList.get(n);
                    object = object2[n];
                    nodeRetained.updateCachedInformation(2, (View)object4, (int)object);
                }
                n2 = ((ArrayList)object3).size();
                if (n2 > 0) {
                    for (n = 0; n < n2; ++n) {
                        e = ((ArrayList)object3).get(n);
                        if (e instanceof LightRetained) {
                            nodeRetained = (LightRetained)e;
                            ((LightRetained)nodeRetained).isViewScoped = true;
                            ++this.numberOfLights;
                            if (arrayList2 == null && (arrayList2 = this.viewScopedLights.get(object4)) == null) {
                                arrayList2 = new ArrayList();
                                this.viewScopedLights.put((View)object4, arrayList2);
                            }
                            arrayList2.add((LightRetained)nodeRetained);
                        }
                        if (e instanceof FogRetained) {
                            nodeRetained = (FogRetained)e;
                            ((FogRetained)nodeRetained).isViewScoped = true;
                            ++this.numberOfFogs;
                            if (arrayList3 == null && (arrayList3 = this.viewScopedFogs.get(object4)) == null) {
                                arrayList3 = new ArrayList();
                                this.viewScopedFogs.put((View)object4, arrayList3);
                            }
                            arrayList3.add((FogRetained)nodeRetained);
                        }
                        if (e instanceof ModelClipRetained) {
                            nodeRetained = (ModelClipRetained)e;
                            ((ModelClipRetained)nodeRetained).isViewScoped = true;
                            ++this.numberOfModelClips;
                            if (arrayList4 == null && (arrayList4 = this.viewScopedModelClips.get(object4)) == null) {
                                arrayList4 = new ArrayList();
                                this.viewScopedModelClips.put((View)object4, arrayList4);
                            }
                            arrayList4.add((ModelClipRetained)nodeRetained);
                        }
                        if (e instanceof AlternateAppearanceRetained) {
                            nodeRetained = (AlternateAppearanceRetained)e;
                            ((AlternateAppearanceRetained)nodeRetained).isViewScoped = true;
                            ++this.numberOfAltApps;
                            if (arrayList5 == null && (arrayList5 = this.viewScopedAltAppearances.get(object4)) == null) {
                                arrayList5 = new ArrayList();
                                this.viewScopedAltAppearances.put((View)object4, arrayList5);
                            }
                            arrayList5.add((AlternateAppearanceRetained)nodeRetained);
                        }
                        if (e instanceof ClipRetained) {
                            nodeRetained = (ClipRetained)e;
                            ((ClipRetained)nodeRetained).isViewScoped = true;
                            ++this.numberOfClips;
                            if (arrayList7 == null && (arrayList7 = this.viewScopedClips.get(object4)) == null) {
                                arrayList7 = new ArrayList();
                                this.viewScopedClips.put((View)object4, arrayList7);
                            }
                            arrayList7.add((ClipRetained)nodeRetained);
                        }
                        if (!(e instanceof BackgroundRetained)) continue;
                        nodeRetained = (BackgroundRetained)e;
                        ((BackgroundRetained)nodeRetained).isViewScoped = true;
                        ++this.numberOfBgs;
                        if (arrayList6 == null && (arrayList6 = this.viewScopedBackgrounds.get(object4)) == null) {
                            arrayList6 = new ArrayList();
                            this.viewScopedBackgrounds.put((View)object4, arrayList6);
                        }
                        arrayList6.add((BackgroundRetained)nodeRetained);
                    }
                    if (this.numberOfLights > this.retlights.length) {
                        this.retlights = new LightRetained[this.numberOfLights];
                    }
                    if (this.intersectedFogs.length < this.numberOfFogs) {
                        this.intersectedFogs = new FogRetained[this.numberOfFogs];
                    }
                    if (this.intersectedAltApps.length < this.numberOfAltApps) {
                        this.intersectedAltApps = new AlternateAppearanceRetained[this.numberOfAltApps];
                    }
                    if (this.intersectedBacks.length < this.numberOfBgs) {
                        this.intersectedBacks = new BackgroundRetained[this.numberOfBgs];
                    }
                    if (this.intersectedClips.length < this.numberOfClips) {
                        this.intersectedClips = new ClipRetained[this.numberOfClips];
                    }
                    if (this.intersectedModelClips.length < this.numberOfModelClips) {
                        this.intersectedModelClips = new ModelClipRetained[this.numberOfModelClips];
                    }
                }
            }
        }
        if ((n3 & 4) != 0 || (n3 & 1) != 0) {
            if ((n3 & 4) != 0) {
                object2 = (View)objectArray[0];
                object4 = (ArrayList)objectArray[1];
                arrayList = (ArrayList)objectArray[2];
                object3 = (int[])objectArray[3];
            } else {
                object2 = (View)objectArray[4];
                object4 = (ArrayList)objectArray[5];
                arrayList = (ArrayList)objectArray[6];
                object3 = (int[])objectArray[7];
            }
            if (object2 != null) {
                n2 = ((ArrayList)object4).size();
                for (n = 0; n < n2; ++n) {
                    nodeRetained = (ViewSpecificGroupRetained)((ArrayList)object4).get(n);
                    object = object3[n];
                    nodeRetained.updateCachedInformation(4, (View)object2, (int)object);
                }
                n2 = arrayList.size();
                if (n2 > 0) {
                    for (n = 0; n < n2; ++n) {
                        e = arrayList.get(n);
                        if (e instanceof LightRetained) {
                            ((LightRetained)e).isViewScoped = false;
                            --this.numberOfLights;
                            if (arrayList2 == null) {
                                arrayList2 = this.viewScopedLights.get(object2);
                            }
                            arrayList2.remove(e);
                        }
                        if (e instanceof FogRetained) {
                            ((FogRetained)e).isViewScoped = false;
                            --this.numberOfFogs;
                            if (arrayList3 == null) {
                                arrayList3 = this.viewScopedFogs.get(object2);
                            }
                            arrayList3.remove(e);
                        }
                        if (e instanceof ModelClipRetained) {
                            ((ModelClipRetained)e).isViewScoped = false;
                            --this.numberOfModelClips;
                            if (arrayList4 == null) {
                                arrayList4 = this.viewScopedModelClips.get(object2);
                            }
                            arrayList4.remove(e);
                        }
                        if (e instanceof AlternateAppearanceRetained) {
                            ((AlternateAppearanceRetained)e).isViewScoped = false;
                            --this.numberOfAltApps;
                            if (arrayList5 == null) {
                                arrayList5 = this.viewScopedAltAppearances.get(object2);
                            }
                            arrayList5.remove(e);
                        }
                        if (e instanceof ClipRetained) {
                            ((ClipRetained)e).isViewScoped = false;
                            --this.numberOfClips;
                            if (arrayList7 == null) {
                                arrayList7 = this.viewScopedClips.get(object2);
                            }
                            arrayList7.remove(e);
                        }
                        if (!(e instanceof BackgroundRetained)) continue;
                        ((BackgroundRetained)e).isViewScoped = false;
                        ++this.numberOfBgs;
                        if (arrayList6 == null) {
                            arrayList6 = this.viewScopedBackgrounds.get(object2);
                        }
                        arrayList6.remove(e);
                    }
                    if (arrayList2 != null && arrayList2.size() == 0) {
                        this.viewScopedLights.remove(object2);
                    }
                    if (arrayList3 != null && arrayList3.size() == 0) {
                        this.viewScopedFogs.remove(object2);
                    }
                    if (arrayList4 != null && arrayList4.size() == 0) {
                        this.viewScopedModelClips.remove(object2);
                    }
                    if (arrayList5 != null && arrayList5.size() == 0) {
                        this.viewScopedAltAppearances.remove(object2);
                    }
                    if (arrayList7 != null && arrayList7.size() == 0) {
                        this.viewScopedClips.remove(object2);
                    }
                    if (arrayList6 != null && arrayList6.size() == 0) {
                        this.viewScopedBackgrounds.remove(object2);
                    }
                }
            }
        }
    }

    boolean isLightScopedToThisView(Object object, View view) {
        ArrayList<LightRetained> arrayList;
        LightRetained lightRetained = (LightRetained)object;
        return !lightRetained.isViewScoped || (arrayList = this.viewScopedLights.get(view)) != null && arrayList.contains(lightRetained);
    }

    boolean isFogScopedToThisView(Object object, View view) {
        ArrayList<FogRetained> arrayList;
        FogRetained fogRetained = (FogRetained)object;
        return !fogRetained.isViewScoped || (arrayList = this.viewScopedFogs.get(view)) != null && arrayList.contains(fogRetained);
    }

    boolean isAltAppScopedToThisView(Object object, View view) {
        ArrayList<AlternateAppearanceRetained> arrayList;
        AlternateAppearanceRetained alternateAppearanceRetained = (AlternateAppearanceRetained)object;
        return !alternateAppearanceRetained.isViewScoped || (arrayList = this.viewScopedAltAppearances.get(view)) != null && arrayList.contains(alternateAppearanceRetained);
    }

    boolean isBgScopedToThisView(Object object, View view) {
        ArrayList<BackgroundRetained> arrayList;
        BackgroundRetained backgroundRetained = (BackgroundRetained)object;
        return !backgroundRetained.isViewScoped || (arrayList = this.viewScopedBackgrounds.get(view)) != null && arrayList.contains(backgroundRetained);
    }

    boolean isClipScopedToThisView(Object object, View view) {
        ArrayList<ClipRetained> arrayList;
        ClipRetained clipRetained = (ClipRetained)object;
        return !clipRetained.isViewScoped || (arrayList = this.viewScopedClips.get(view)) != null && arrayList.contains(clipRetained);
    }

    boolean isMclipScopedToThisView(Object object, View view) {
        ArrayList<ModelClipRetained> arrayList;
        ModelClipRetained modelClipRetained = (ModelClipRetained)object;
        return !modelClipRetained.isViewScoped || (arrayList = this.viewScopedModelClips.get(view)) != null && arrayList.contains(modelClipRetained);
    }

    @Override
    void cleanup() {
    }
}

