/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.resourcepools;

import com.sun.j3d.utils.image.TextureLoader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.media.j3d.Texture;
import org.newdawn.loaders.resourcepools.ResourceLoadFailedException;
import org.newdawn.loaders.resourcepools.ResourcePool;

public class TextureResourcePool
extends ResourcePool {
    private static TextureResourcePool instance = new TextureResourcePool();

    public Object loadResource(String key) throws ResourceLoadFailedException {
        URL location;
        try {
            location = new URL(key);
        }
        catch (MalformedURLException e) {
            throw new ResourceLoadFailedException(key + " is an invalid location" + e.getMessage());
        }
        return this.loadResource(location);
    }

    public Object loadResource(URL location) throws ResourceLoadFailedException {
        return new TextureLoader(location, null).getTexture();
    }

    public static Texture getTexture(URL location) throws ResourceLoadFailedException {
        return (Texture)instance.getResource(location.toString());
    }
}

