/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.awt.event;

import com.jogamp.common.util.IntIntHashMap;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;

public class AWTNewtEventFactory {
    protected static final IntIntHashMap eventTypeAWT2NEWT;

    public static final int awtModifiers2Newt(int n, boolean bl) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 2) != 0) {
            n2 |= 2;
        }
        if ((n & 4) != 0) {
            n2 |= 4;
        }
        if ((n & 8) != 0) {
            n2 |= 8;
        }
        if ((n & 0x20) != 0) {
            n2 |= 0x10;
        }
        return n2;
    }

    public static final int awtButton2Newt(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    public static final com.jogamp.newt.event.WindowEvent createWindowEvent(WindowEvent windowEvent, Window window) {
        int n = eventTypeAWT2NEWT.get(windowEvent.getID());
        if (-1 != n) {
            return new com.jogamp.newt.event.WindowEvent(n, null == window ? windowEvent.getComponent() : window, System.currentTimeMillis());
        }
        return null;
    }

    public static final com.jogamp.newt.event.WindowEvent createWindowEvent(ComponentEvent componentEvent, Window window) {
        int n = eventTypeAWT2NEWT.get(componentEvent.getID());
        if (-1 != n) {
            return new com.jogamp.newt.event.WindowEvent(n, null == window ? componentEvent.getComponent() : window, System.currentTimeMillis());
        }
        return null;
    }

    public static final com.jogamp.newt.event.WindowEvent createWindowEvent(FocusEvent focusEvent, Window window) {
        int n = eventTypeAWT2NEWT.get(focusEvent.getID());
        if (-1 != n) {
            return new com.jogamp.newt.event.WindowEvent(n, null == window ? focusEvent.getComponent() : window, System.currentTimeMillis());
        }
        return null;
    }

    public static final com.jogamp.newt.event.MouseEvent createMouseEvent(MouseEvent mouseEvent, Window window) {
        int n = eventTypeAWT2NEWT.get(mouseEvent.getID());
        if (-1 != n) {
            int n2 = 0;
            if (mouseEvent instanceof MouseWheelEvent) {
                n2 = -1 * ((MouseWheelEvent)mouseEvent).getWheelRotation();
            }
            int n3 = AWTNewtEventFactory.awtModifiers2Newt(mouseEvent.getModifiers(), true);
            if (null != window) {
                if (window.isPointerConfined()) {
                    n3 |= 0x40000000;
                }
                if (!window.isPointerVisible()) {
                    n3 |= Integer.MIN_VALUE;
                }
            }
            return new com.jogamp.newt.event.MouseEvent(n, null == window ? mouseEvent.getComponent() : window, mouseEvent.getWhen(), n3, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), AWTNewtEventFactory.awtButton2Newt(mouseEvent.getButton()), n2);
        }
        return null;
    }

    public static final KeyEvent createKeyEvent(java.awt.event.KeyEvent keyEvent, Window window) {
        int n = eventTypeAWT2NEWT.get(keyEvent.getID());
        if (-1 != n) {
            return new KeyEvent(n, null == window ? keyEvent.getComponent() : window, keyEvent.getWhen(), AWTNewtEventFactory.awtModifiers2Newt(keyEvent.getModifiers(), false), keyEvent.getKeyCode(), keyEvent.getKeyChar());
        }
        return null;
    }

    static {
        IntIntHashMap intIntHashMap = new IntIntHashMap();
        intIntHashMap.setKeyNotFoundValue(-1);
        intIntHashMap.put(201, 102);
        intIntHashMap.put(202, 106);
        intIntHashMap.put(205, 103);
        intIntHashMap.put(207, 103);
        intIntHashMap.put(1004, 103);
        intIntHashMap.put(206, 104);
        intIntHashMap.put(208, 104);
        intIntHashMap.put(1005, 104);
        intIntHashMap.put(100, 101);
        intIntHashMap.put(101, 100);
        intIntHashMap.put(500, 200);
        intIntHashMap.put(501, 203);
        intIntHashMap.put(502, 204);
        intIntHashMap.put(503, 205);
        intIntHashMap.put(504, 201);
        intIntHashMap.put(505, 202);
        intIntHashMap.put(506, 206);
        intIntHashMap.put(507, 207);
        intIntHashMap.put(401, 300);
        intIntHashMap.put(402, 301);
        intIntHashMap.put(400, 302);
        eventTypeAWT2NEWT = intIntHashMap;
    }
}

