/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BHLeafInterface;
import javax.media.j3d.BHLeafNode;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.NnuId;
import javax.media.j3d.NnuIdManager;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.RenderAtomListInfo;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

class GeometryAtom
implements BHLeafInterface,
NnuId {
    GeometryRetained[] geometryArray = null;
    Transform3D[] lastLocalTransformArray = null;
    Locale locale = null;
    Shape3DRetained source = null;
    BHLeafNode bhLeafNode = null;
    boolean alphaEditable;
    boolean visible = true;
    int geoType = -1;
    RenderAtom[] renderAtoms = new RenderAtom[0];
    int nnuId;
    Point3d[] centroid = null;
    boolean centroidIsDirty = true;
    Object lockObj = new Object();

    GeometryAtom() {
        this.nnuId = NnuIdManager.getId();
    }

    public int getId() {
        return this.nnuId;
    }

    public int equal(NnuId nnuId) {
        int n = nnuId.getId();
        if (this.nnuId < n) {
            return -1;
        }
        if (this.nnuId > n) {
            return 1;
        }
        return 0;
    }

    public BoundingBox computeBoundingHull() {
        return this.source.vwcBounds;
    }

    public boolean isEnable() {
        return this.source.vwcBounds != null && !this.source.vwcBounds.isEmpty() && this.source.switchState.currentSwitchOn;
    }

    public boolean isEnable(int n) {
        if (this.source.vwcBounds != null && !this.source.vwcBounds.isEmpty() && this.source.switchState.currentSwitchOn) {
            switch (n) {
                case 0: {
                    return this.visible;
                }
                case 1: {
                    return !this.visible;
                }
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }

    public Locale getLocale2() {
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RenderAtom getRenderAtom(View view) {
        Object object = this.lockObj;
        synchronized (object) {
            Object object2;
            if (this.source.viewList != null && !this.source.viewList.contains(view)) {
                return null;
            }
            int n = view.viewIndex;
            if (n >= this.renderAtoms.length) {
                object2 = new RenderAtom[n + 1];
                System.arraycopy(this.renderAtoms, 0, object2, 0, this.renderAtoms.length);
                this.renderAtoms = object2;
            }
            if ((object2 = this.renderAtoms[n]) == null) {
                this.renderAtoms[n] = object2 = new RenderAtom();
                object2.geometryAtom = this;
                boolean bl = this.geoType == 16;
                object2.rListInfo = new RenderAtomListInfo[this.geometryArray.length];
                for (int i = 0; i < object2.rListInfo.length; ++i) {
                    object2.rListInfo[i] = new RenderAtomListInfo((RenderAtom)object2, i);
                    if (!bl) continue;
                    object2.rListInfo[i].localToVworld = new Transform3D();
                }
            }
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCentroid() {
        if (VirtualUniverse.mc.sortShape3DBounds && !this.source.boundsAutoCompute) {
            Object object = this.lockObj;
            synchronized (object) {
                if (this.centroid == null) {
                    this.centroid = new Point3d[this.geometryArray.length];
                    for (int i = 0; i < this.centroid.length; ++i) {
                        this.centroid[i] = new Point3d();
                        this.source.localBounds.getCenter(this.centroid[i]);
                        this.source.getCurrentLocalToVworld(0).transform(this.centroid[i]);
                    }
                } else {
                    for (int i = 0; i < this.centroid.length; ++i) {
                        this.source.localBounds.getCenter(this.centroid[i]);
                        this.source.getCurrentLocalToVworld(0).transform(this.centroid[i]);
                    }
                }
            }
            return;
        }
        Object object = this.lockObj;
        synchronized (object) {
            int n;
            for (n = 0; n < this.geometryArray.length; ++n) {
                if (this.geometryArray[n] == null) continue;
                Point3d point3d = this.geometryArray[n].centroid;
                synchronized (point3d) {
                    if (this.geometryArray[n].recompCentroid) {
                        this.geometryArray[n].computeCentroid();
                        this.geometryArray[n].recompCentroid = false;
                    }
                    continue;
                }
            }
            if (this.centroidIsDirty) {
                if (this.centroid == null) {
                    this.centroid = new Point3d[this.geometryArray.length];
                    for (n = 0; n < this.centroid.length; ++n) {
                        if (this.geometryArray[n] == null) continue;
                        this.centroid[n] = new Point3d(this.geometryArray[n].centroid);
                        this.source.getCurrentLocalToVworld(0).transform(this.centroid[n]);
                    }
                } else {
                    for (n = 0; n < this.centroid.length; ++n) {
                        if (this.geometryArray[n] == null) continue;
                        this.centroid[n].set((Tuple3d)this.geometryArray[n].centroid);
                        this.source.getCurrentLocalToVworld(0).transform(this.centroid[n]);
                    }
                }
                this.centroidIsDirty = false;
            }
        }
    }
}

