/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97.impl;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Group;
import javax.media.j3d.Link;
import javax.media.j3d.Locale;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SharedGroup;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;

public class TreePrinter {
    PrintStream printStream;
    String j3dPkg = new String("javax.media.j3d.");
    String v97Pkg = new String("org.jdesktop.j3d.loaders.vrml97.impl.");

    public void print(PrintStream s, Locale l) {
        this.printStream = s;
        HashSet sharedGroups = new HashSet();
        this.printTree(l, 0, sharedGroups);
        Iterator iterator = sharedGroups.iterator();
        while (iterator.hasNext()) {
            SharedGroup sg = (SharedGroup)iterator.next();
            this.print(s, (SceneGraphObject)sg);
        }
    }

    public void print(Locale l) {
        this.print(System.out, l);
    }

    private void printTree(Locale l, int graphDepth, Set sharedGroups) {
        this.printNode(l, 0, sharedGroups);
        try {
            Enumeration e = l.getAllBranchGraphs();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (o instanceof Locale) {
                    this.printTree((Locale)o, graphDepth + 1, sharedGroups);
                    continue;
                }
                if (o instanceof SceneGraphObject) {
                    this.printTree((SceneGraphObject)o, graphDepth + 1, sharedGroups);
                    continue;
                }
                this.printStream.println(o + " unknown and in tree");
            }
        }
        catch (CapabilityNotSetException e) {
            this.printStream.println("No capability to read children");
        }
    }

    public void print(PrintStream s, SceneGraphObject sgo) {
        this.printStream = s;
        HashSet sharedGroups = new HashSet();
        this.printTree(sgo, 0, sharedGroups);
        Iterator iterator = sharedGroups.iterator();
        while (iterator.hasNext()) {
            SharedGroup sg = (SharedGroup)iterator.next();
            this.print(s, (SceneGraphObject)sg);
        }
    }

    public void print(SceneGraphObject sgo) {
        this.print(System.out, sgo);
    }

    private void printTree(SceneGraphObject sgo, int graphDepth, Set sharedGroups) {
        this.printNode(sgo, graphDepth, sharedGroups);
        if (sgo instanceof Group) {
            try {
                Enumeration e = ((Group)sgo).getAllChildren();
                while (e.hasMoreElements()) {
                    this.printTree((SceneGraphObject)e.nextElement(), graphDepth + 1, sharedGroups);
                }
            }
            catch (CapabilityNotSetException e) {
                // empty catch block
            }
        }
    }

    private String nodeString(Object o) {
        String objString = o.toString();
        if (objString.startsWith(this.j3dPkg)) {
            objString = objString.substring(this.j3dPkg.length());
        }
        if (objString.startsWith(this.v97Pkg)) {
            objString = objString.substring(this.v97Pkg.length());
        }
        return objString;
    }

    private void printNode(Object o, int indent, Set sharedGroups) {
        for (int i = 0; i < indent; ++i) {
            this.printStream.print(">");
        }
        this.printStream.print(this.nodeString(o) + ": ");
        if (o instanceof SceneGraphObject) {
            SceneGraphObject sgo = (SceneGraphObject)o;
            int capBits = 0;
            for (int i = 0; i < 64; ++i) {
                if (!sgo.getCapability(i)) continue;
                capBits |= 1 << i;
            }
            this.printStream.print("capBits:Ox" + Integer.toHexString(capBits));
            if (o instanceof Group) {
                Group g = (Group)o;
                int numChildren = 0;
                try {
                    numChildren = g.numChildren();
                }
                catch (CapabilityNotSetException e) {
                    g.setCapability(12);
                    numChildren = g.numChildren();
                }
                this.printStream.print(" children:" + numChildren);
                if (o instanceof TransformGroup) {
                    Transform3D transform = new Transform3D();
                    Transform3D identity = new Transform3D();
                    TransformGroup t = (TransformGroup)o;
                    t.getTransform(transform);
                    if (transform.equals(identity)) {
                        this.printStream.print(" xform:IDENTITY ");
                    } else {
                        this.printStream.print(" xform:NON-IDENTITY ");
                    }
                }
            } else if (o instanceof Link) {
                Link l = (Link)o;
                SharedGroup sg = l.getSharedGroup();
                this.printStream.print(" sg:" + this.nodeString(sg));
                sharedGroups.add(sg);
            } else {
                this.printStream.print(": leaf");
            }
        }
        this.printStream.println();
    }
}

