/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.macosx.cgl;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.media.nativewindow.NativeSurface;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.macosx.cgl.MacOSXCGLContext;

public abstract class MacOSXCGLDrawable
extends GLDrawableImpl {
    List<WeakReference<MacOSXCGLContext>> createdContexts = new ArrayList<WeakReference<MacOSXCGLContext>>();
    private boolean haveSetOpenGLMode = false;
    private GLBackendType openGLMode = GLBackendType.NSOPENGL;

    public MacOSXCGLDrawable(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface, boolean bl) {
        super(gLDrawableFactory, nativeSurface, bl);
        this.initOpenGLImpl(this.getOpenGLMode());
    }

    @Override
    protected void setRealizedImpl() {
    }

    protected long getNSViewHandle() {
        return GLBackendType.NSOPENGL == this.openGLMode ? this.getHandle() : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void associateContext(GLContext gLContext, boolean bl) {
        List<WeakReference<MacOSXCGLContext>> list = this.createdContexts;
        synchronized (list) {
            if (bl) {
                this.createdContexts.add(new WeakReference<MacOSXCGLContext>((MacOSXCGLContext)gLContext));
            } else {
                int n = 0;
                while (n < this.createdContexts.size()) {
                    WeakReference<MacOSXCGLContext> weakReference = this.createdContexts.get(n);
                    MacOSXCGLContext macOSXCGLContext = (MacOSXCGLContext)weakReference.get();
                    if (macOSXCGLContext == null || macOSXCGLContext == gLContext) {
                        this.createdContexts.remove(n);
                        continue;
                    }
                    ++n;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void swapBuffersImpl(boolean bl) {
        if (bl) {
            List<WeakReference<MacOSXCGLContext>> list = this.createdContexts;
            synchronized (list) {
                int n = 0;
                while (n < this.createdContexts.size()) {
                    WeakReference<MacOSXCGLContext> weakReference = this.createdContexts.get(n);
                    MacOSXCGLContext macOSXCGLContext = (MacOSXCGLContext)weakReference.get();
                    if (macOSXCGLContext != null) {
                        macOSXCGLContext.swapBuffers();
                        ++n;
                        continue;
                    }
                    this.createdContexts.remove(n);
                }
            }
        }
    }

    @Override
    public GLDynamicLookupHelper getGLDynamicLookupHelper() {
        return this.getFactoryImpl().getGLDynamicLookupHelper(0);
    }

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }

    public void setOpenGLMode(GLBackendType gLBackendType) {
        if (gLBackendType == this.openGLMode) {
            return;
        }
        if (this.haveSetOpenGLMode) {
            throw new GLException("Can't switch between using NSOpenGLPixelBuffer and CGLPBufferObj more than once");
        }
        this.setRealized(false);
        if (DEBUG) {
            System.err.println("MacOSXCGLDrawable: Switching context mode " + (Object)((Object)this.openGLMode) + " -> " + (Object)((Object)gLBackendType));
        }
        this.initOpenGLImpl(gLBackendType);
        this.openGLMode = gLBackendType;
        this.haveSetOpenGLMode = true;
    }

    public final GLBackendType getOpenGLMode() {
        return this.openGLMode;
    }

    protected void initOpenGLImpl(GLBackendType gLBackendType) {
    }

    public static enum GLBackendType {
        NSOPENGL(0),
        CGL(1);

        public final int id;

        private GLBackendType(int n2) {
            this.id = n2;
        }
    }
}

