/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97.impl;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.PointArray;
import org.jdesktop.j3d.loaders.vrml97.impl.Color;
import org.jdesktop.j3d.loaders.vrml97.impl.Coordinate;
import org.jdesktop.j3d.loaders.vrml97.impl.Geometry;
import org.jdesktop.j3d.loaders.vrml97.impl.Loader;
import org.jdesktop.j3d.loaders.vrml97.impl.SFNode;

public class PointSet
extends Geometry {
    PointArray impl;
    BoundingBox bounds;
    SFNode color;
    SFNode coord;
    int vertexFormat = 0;
    int vertexCount = 0;
    boolean haveColors = false;
    Coordinate coordNode = null;
    Color colorNode = null;

    public PointSet(Loader loader) {
        super(loader);
        this.color = new SFNode(null);
        this.coord = new SFNode(null);
        this.initFields();
    }

    PointSet(Loader loader, SFNode coord, SFNode color) {
        super(loader);
        this.coord = coord;
        this.color = color;
        this.initFields();
    }

    public void initImpl() {
        if (this.coord.node != null && this.coord.node instanceof Coordinate) {
            this.coordNode = (Coordinate)this.coord.node;
            if (this.coordNode.point.size >= 3) {
                this.vertexFormat = 1;
                this.vertexCount = this.coordNode.point.size / 3;
                if (this.color.node != null && this.color.node instanceof Color) {
                    this.colorNode = (Color)this.color.node;
                    if (this.colorNode.color.vals.length / 3 == this.vertexCount) {
                        this.haveColors = true;
                        this.vertexFormat |= 4;
                    }
                }
                this.impl = new PointArray(this.vertexCount, this.vertexFormat);
                this.impl.setCoordinates(0, this.coordNode.point.value, 0, this.vertexCount);
                if (this.haveColors) {
                    this.impl.setColors(0, this.colorNode.color.vals);
                }
                this.bounds = this.coordNode.point.getBoundingBox();
            }
        }
    }

    public void notifyMethod(String eventInName, double time) {
        if (eventInName.equals("color") || eventInName.equals("coord")) {
            this.initImpl();
        }
    }

    public Object clone() {
        return new PointSet(this.loader, (SFNode)this.coord.clone(), (SFNode)this.color.clone());
    }

    public String getType() {
        return "PointSet";
    }

    void initFields() {
        this.coord.init(this, this.FieldSpec, 3, "coord");
        this.color.init(this, this.FieldSpec, 3, "color");
    }

    public javax.media.j3d.Geometry getImplGeom() {
        return this.impl;
    }

    public BoundingBox getBoundingBox() {
        return this.bounds;
    }

    public boolean haveTexture() {
        return false;
    }

    public int getNumTris() {
        return 0;
    }
}

