/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.md2;

import java.util.ArrayList;
import java.util.HashMap;
import javax.media.j3d.Shape3D;
import org.newdawn.j3d.loaders.md2.MD2ModelInstance;
import org.newdawn.j3d.loaders.md2.MD2RenderedFrame;

public class MD2Model {
    private MD2RenderedFrame[] frames;
    private HashMap animMap = new HashMap();

    public MD2Model(MD2RenderedFrame[] frames) {
        this.frames = frames;
        int i = 0;
        while (i < frames.length) {
            if (frames[i] != null) {
                String anim = frames[i].getAnimName();
                String frame = frames[i].getAnimIndex();
                ArrayList<MD2RenderedFrame> v = (ArrayList<MD2RenderedFrame>)this.animMap.get(anim);
                if (v == null) {
                    v = new ArrayList<MD2RenderedFrame>();
                    this.animMap.put(anim, v);
                    v.add(frames[i]);
                } else {
                    v.add(frames[i]);
                }
            }
            ++i;
        }
    }

    public ArrayList getAnimation(String tag) {
        return (ArrayList)this.animMap.get(tag);
    }

    public String[] getAnimationTags() {
        String[] tags = new String[this.animMap.keySet().size()];
        this.animMap.keySet().toArray(tags);
        return tags;
    }

    public Shape3D getFrame(int index) {
        return this.frames[index].getShape();
    }

    public MD2ModelInstance getInstance() {
        return new MD2ModelInstance(this.getAnimationTags()[0], this);
    }
}

