/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.md3;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedTime;
import javax.vecmath.Point3d;
import org.newdawn.j3d.loaders.md3.MD3AnimConfig;
import org.newdawn.j3d.loaders.md3.MD3Frame;
import org.newdawn.j3d.loaders.md3.MD3ModelPart;
import org.newdawn.j3d.loaders.md3.MD3PartListener;

public class MD3PartInstance
extends TransformGroup
implements MD3PartListener {
    private MD3ModelPart part;
    private MD3AnimConfig config;
    private String anim;
    private int animIndex = -1;
    private Group disp;
    private int newFrame = 0;
    private MD3Frame currentFrame;
    private ArrayList listeners = new ArrayList();
    private String dep;
    private MD3PartInstance depPart;
    private String name;
    private Transform3D depTrans;
    private int firstFrame;
    private int frameCount;
    private boolean animLooping;
    private Object userData;

    public MD3PartInstance(MD3ModelPart part, MD3AnimConfig config, MD3PartInstance depPart, String dep) {
        this.part = part;
        this.config = config;
        this.dep = dep;
        this.depPart = depPart;
        this.name = part.getName();
        this.addChild((Node)new AnimBehavior());
        if (depPart != null) {
            depPart.addChild((Node)this);
            depPart.addListener(this);
        }
        this.setCapability(17);
        this.setCapability(18);
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(14);
        this.setFrame();
    }

    public void setUserData(Object data) {
        this.userData = data;
    }

    public String getName() {
        return this.name;
    }

    public void setAnimation(String anim) {
        this.anim = anim;
        this.firstFrame = this.newFrame = this.config.getFirstFrame(anim);
        this.frameCount = this.config.getFrameCount(anim);
        this.animLooping = this.config.isLooping(anim);
    }

    public void nextFrame() {
        int frame = this.newFrame + 1;
        if (frame - this.firstFrame >= this.frameCount) {
            if (!this.animLooping) {
                return;
            }
            frame = this.firstFrame;
        }
        this.newFrame = frame;
    }

    void setFrame() {
        if (this.newFrame == -1) {
            return;
        }
        if (this.disp != null) {
            this.removeChild((Node)this.disp);
            this.currentFrame.releaseToPool(this.disp);
        }
        this.animIndex = this.newFrame;
        this.currentFrame = this.part.getFrameData(this.animIndex);
        this.disp = this.part.getFrame(this.animIndex);
        if (this.userData != null) {
            this.setupUserData(this.disp);
        }
        this.addChild((Node)this.disp);
        this.fireUpdate();
    }

    public void setupUserData(Group g) {
        int size = g.numChildren();
        int i = 0;
        while (i < size) {
            if (g.getChild(i) instanceof Group) {
                this.setupUserData((Group)g.getChild(i));
            }
            if (g.getChild(i) instanceof Shape3D) {
                g.getChild(i).setUserData(this.userData);
            }
            ++i;
        }
    }

    private void fireUpdate() {
        int i = 0;
        while (i < this.listeners.size()) {
            ((MD3PartListener)this.listeners.get(i)).partUpdated();
            ++i;
        }
    }

    public void addListener(MD3PartListener l) {
        this.listeners.add(l);
    }

    public void partUpdated() {
        if (this.dep != null) {
            this.depTrans = this.depPart.getTagTransform(this.dep);
            this.setTransform(this.depTrans);
            this.fireUpdate();
        }
    }

    public Transform3D getTagTransform(String tag) {
        Transform3D ret = this.currentFrame.getTagTransform(tag);
        return ret;
    }

    private class AnimBehavior
    extends Behavior {
        private AnimBehavior() {
        }

        public void initialize() {
            this.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0));
            this.wakeupOn((WakeupCondition)new WakeupOnElapsedTime(10L));
        }

        public void processStimulus(Enumeration enumeration) {
            if (MD3PartInstance.this.newFrame != MD3PartInstance.this.animIndex) {
                MD3PartInstance.this.setFrame();
            }
            this.wakeupOn((WakeupCondition)new WakeupOnElapsedTime(10L));
        }
    }
}

