/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.util.locks;

import com.jogamp.common.util.locks.RecursiveLock;
import java.util.List;
import java.util.concurrent.locks.AbstractOwnableSynchronizer;
import jogamp.common.util.locks.LockDebugUtil;

public class RecursiveLockImpl01Unfairish
implements RecursiveLock {
    protected final Sync sync;

    public RecursiveLockImpl01Unfairish(Sync sync) {
        this.sync = sync;
    }

    public RecursiveLockImpl01Unfairish() {
        this(new SingleThreadSync());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Throwable getLockedStack() {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.getLockedStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Thread getOwner() {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.getOwner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isOwner(Thread thread) {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.isOwner(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isLocked() {
        Sync sync = this.sync;
        synchronized (sync) {
            return null != this.sync.getOwner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isLockedByOtherThread() {
        Sync sync = this.sync;
        synchronized (sync) {
            Thread thread = this.sync.getOwner();
            return null != thread && Thread.currentThread() != thread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getHoldCount() {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.getHoldCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void validateLocked() throws RuntimeException {
        Sync sync = this.sync;
        synchronized (sync) {
            if (!this.sync.isOwner(Thread.currentThread())) {
                if (null == this.sync.getOwner()) {
                    throw new RuntimeException(this.threadName(Thread.currentThread()) + ": Not locked: " + this.toString());
                }
                if (null != this.sync.getLockedStack()) {
                    this.sync.getLockedStack().printStackTrace();
                }
                throw new RuntimeException(Thread.currentThread() + ": Not owner: " + this.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void lock() {
        Sync sync = this.sync;
        synchronized (sync) {
            try {
                if (!this.tryLock(TIMEOUT)) {
                    if (null != this.sync.getLockedStack()) {
                        this.sync.getLockedStack().printStackTrace();
                    }
                    throw new RuntimeException("Waited " + TIMEOUT + "ms for: " + this.toString() + " - " + this.threadName(Thread.currentThread()));
                }
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("Interrupted", interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean tryLock(long l) throws InterruptedException {
        Sync sync = this.sync;
        synchronized (sync) {
            Thread thread = Thread.currentThread();
            if (TRACE_LOCK) {
                System.err.println("+++ LOCK 0 " + this.toString() + ", cur " + this.threadName(thread));
            }
            if (this.sync.isOwner(thread)) {
                this.sync.incrHoldCount(thread);
                if (TRACE_LOCK) {
                    System.err.println("+++ LOCK XR " + this.toString() + ", cur " + this.threadName(thread));
                }
                return true;
            }
            if (this.sync.getOwner() != null || 0L < l && 0 < this.sync.getQSz()) {
                long l2;
                if (0L >= l) {
                    return false;
                }
                this.sync.incrQSz();
                do {
                    l2 = System.currentTimeMillis();
                    this.sync.wait(l);
                } while (null != this.sync.getOwner() && 0L < (l -= System.currentTimeMillis() - l2));
                this.sync.decrQSz();
                if (0L >= l) {
                    if (TRACE_LOCK || DEBUG) {
                        System.err.println("+++ LOCK XX " + this.toString() + ", cur " + this.threadName(thread) + ", left " + l + " ms");
                    }
                    return false;
                }
                if (TRACE_LOCK) {
                    System.err.println("+++ LOCK X1 " + this.toString() + ", cur " + this.threadName(thread) + ", left " + l + " ms");
                }
            } else if (TRACE_LOCK) {
                System.err.println("+++ LOCK X0 " + this.toString() + ", cur " + this.threadName(thread));
            }
            this.sync.setOwner(thread);
            this.sync.incrHoldCount(thread);
            if (DEBUG) {
                this.sync.setLockedStack(new Throwable("Previously locked by " + this.toString()));
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unlock() {
        Sync sync = this.sync;
        synchronized (sync) {
            this.unlock(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(Runnable runnable) {
        Sync sync = this.sync;
        synchronized (sync) {
            this.validateLocked();
            Thread thread = Thread.currentThread();
            this.sync.decrHoldCount(thread);
            if (this.sync.getHoldCount() > 0) {
                if (TRACE_LOCK) {
                    System.err.println("--- LOCK XR " + this.toString() + ", cur " + this.threadName(thread));
                }
                return;
            }
            this.sync.setOwner(null);
            if (DEBUG) {
                this.sync.setLockedStack(null);
            }
            if (null != runnable) {
                runnable.run();
            }
            if (TRACE_LOCK) {
                System.err.println("--- LOCK X0 " + this.toString() + ", cur " + this.threadName(thread) + ", signal any");
            }
            this.sync.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getQueueLength() {
        Sync sync = this.sync;
        synchronized (sync) {
            return this.sync.getQSz();
        }
    }

    public String toString() {
        return this.syncName() + "[count " + this.sync.getHoldCount() + ", qsz " + this.sync.getQSz() + ", owner " + this.threadName(this.sync.getOwner()) + "]";
    }

    final String syncName() {
        return "<" + Integer.toHexString(this.hashCode()) + ", " + Integer.toHexString(this.sync.hashCode()) + ">";
    }

    final String threadName(Thread thread) {
        return null != thread ? "<" + thread.getName() + ">" : "<NULL>";
    }

    static class SingleThreadSync
    extends AbstractOwnableSynchronizer
    implements Sync {
        private int holdCount = 0;
        private Throwable lockedStack = null;
        private int qsz = 0;

        SingleThreadSync() {
        }

        @Override
        public final Thread getOwner() {
            return this.getExclusiveOwnerThread();
        }

        @Override
        public boolean isOwner(Thread thread) {
            return this.getExclusiveOwnerThread() == thread;
        }

        @Override
        public final void setOwner(Thread thread) {
            this.setExclusiveOwnerThread(thread);
        }

        @Override
        public final Throwable getLockedStack() {
            return this.lockedStack;
        }

        @Override
        public final void setLockedStack(Throwable throwable) {
            List<Throwable> list = LockDebugUtil.getRecursiveLockTrace();
            if (throwable == null) {
                list.remove(this.lockedStack);
            } else {
                list.add(throwable);
            }
            this.lockedStack = throwable;
        }

        @Override
        public final int getHoldCount() {
            return this.holdCount;
        }

        @Override
        public void incrHoldCount(Thread thread) {
            ++this.holdCount;
        }

        @Override
        public void decrHoldCount(Thread thread) {
            --this.holdCount;
        }

        @Override
        public final int getQSz() {
            return this.qsz;
        }

        @Override
        public final void incrQSz() {
            ++this.qsz;
        }

        @Override
        public final void decrQSz() {
            --this.qsz;
        }
    }

    static interface Sync {
        public Thread getOwner();

        public boolean isOwner(Thread var1);

        public void setOwner(Thread var1);

        public Throwable getLockedStack();

        public void setLockedStack(Throwable var1);

        public int getHoldCount();

        public void incrHoldCount(Thread var1);

        public void decrHoldCount(Thread var1);

        public int getQSz();

        public void incrQSz();

        public void decrQSz();
    }
}

