/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayDeque;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HtmlPanel
extends JPanel
implements ActionListener,
HyperlinkListener {
    private static final long serialVersionUID = 1L;
    JButton backB;
    JEditorPane pane;
    ArrayDeque<URL> rireki = new ArrayDeque();
    URL dummyURL;
    String firstPageHtml;

    public HtmlPanel(String urlString) {
        this.setLayout(new BorderLayout());
        this.backB = new JButton("\u3082\u3069\u308b");
        this.backB.addActionListener(this);
        this.add((Component)this.backB, "North");
        this.pane = new JEditorPane();
        this.pane.addHyperlinkListener(this);
        this.pane.setEditable(false);
        this.pane.setContentType("text/html");
        JScrollPane scrollPane = new JScrollPane(this.pane);
        this.add((Component)scrollPane, "Center");
        try {
            this.dummyURL = new URL("http://localhost:1234/");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open(URL url) {
        this.rireki.clear();
        this.rireki.push(url);
        try {
            this.pane.setPage(url);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public void open(String s) {
        this.firstPageHtml = s;
        this.rireki.clear();
        this.rireki.push(this.dummyURL);
        this.pane.setText(this.firstPageHtml);
    }

    public void open(File f) {
        try {
            this.open(f.toURI().toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.backB) {
            if (this.rireki.size() <= 1) {
                return;
            }
            this.rireki.pop();
            URL url = this.rireki.peekFirst();
            try {
                if (url == this.dummyURL) {
                    this.pane.setText(this.firstPageHtml);
                } else {
                    this.pane.setPage(url);
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                URL url = e.getURL();
                this.rireki.push(url);
                this.pane.setPage(url);
            }
            catch (IOException ee) {
                ee.printStackTrace();
            }
        }
    }
}

