/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickShape;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Transform3D;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOnElapsedTime;
import javax.media.j3d.WakeupOr;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3BranchGroup;
import jp.sourceforge.acerola3d.a3.A3Canvas;
import jp.sourceforge.acerola3d.a3.A3CanvasInterface;
import jp.sourceforge.acerola3d.a3.A3Event;
import jp.sourceforge.acerola3d.a3.A3Listener;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.A3Screen;
import jp.sourceforge.acerola3d.a3.A3SubCanvas;
import jp.sourceforge.acerola3d.a3.A3Widget;
import jp.sourceforge.acerola3d.a3.A3Window;
import jp.sourceforge.acerola3d.a3.JA3Canvas;
import jp.sourceforge.acerola3d.a3.JA3Canvas2;
import jp.sourceforge.acerola3d.a3.JA3SubCanvas;
import jp.sourceforge.acerola3d.a3.JA3Window;

class PickingBehavior
extends Behavior {
    A3CanvasInterface canvas;
    Locale locale;
    Transform3D vpt = new Transform3D();
    ArrayList<A3Listener> listeners;
    Object eventMaker;
    int mouseX;
    int mouseY;
    A3Object currentA3;
    int doubleClickMaxTime = 400;
    long clickedTime;
    MouseEvent meTmp;

    public PickingBehavior(A3CanvasInterface c, Locale l) {
        this.canvas = c;
        this.locale = l;
        this.listeners = new ArrayList();
        if (c instanceof A3Window) {
            this.eventMaker = ((A3Window)c).canvas;
        } else if (c instanceof JA3Window) {
            this.eventMaker = ((JA3Window)c).canvas;
        } else if (c instanceof A3Canvas) {
            this.eventMaker = c;
        } else if (c instanceof JA3Canvas) {
            this.eventMaker = c;
        } else if (c instanceof A3Screen) {
            this.eventMaker = c;
        } else if (c instanceof A3Widget) {
            this.eventMaker = ((A3Widget)c).tCanvas;
        } else if (c instanceof JA3Canvas2) {
            this.eventMaker = c;
        } else if (c instanceof A3SubCanvas) {
            this.eventMaker = c;
        } else if (c instanceof JA3SubCanvas) {
            this.eventMaker = c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addA3Listener(A3Listener l) {
        ArrayList<A3Listener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeA3Listener(A3Listener l) {
        ArrayList<A3Listener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(l);
        }
    }

    public void initialize() {
        WakeupOnAWTEvent w = new WakeupOnAWTEvent(501);
        this.wakeupOn((WakeupCondition)w);
    }

    public void processStimulus(Enumeration criteria) {
        while (criteria.hasMoreElements()) {
            WakeupCriterion w = (WakeupCriterion)criteria.nextElement();
            if (w instanceof WakeupOnAWTEvent) {
                AWTEvent[] e = ((WakeupOnAWTEvent)w).getAWTEvent();
                for (int i = 0; i < e.length; ++i) {
                    if (e[i].getID() == 501) {
                        this.processMousePressed((MouseEvent)e[i]);
                        continue;
                    }
                    if (e[i].getID() == 506) {
                        this.processMouseDragged((MouseEvent)e[i]);
                        continue;
                    }
                    if (e[i].getID() != 502) continue;
                    this.processMouseReleased((MouseEvent)e[i]);
                }
                continue;
            }
            if (!(w instanceof WakeupOnElapsedTime)) continue;
            this.wakeupOnElapsedTime((WakeupOnElapsedTime)w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMousePressed(MouseEvent me) {
        if (me.getSource() == this.eventMaker) {
            this.mouseX = me.getX();
            this.mouseY = me.getY();
            this.currentA3 = this.pickA3(me.getX(), me.getY());
            A3Event a3Event = new A3Event();
            a3Event.setMouseEvent(me);
            a3Event.setA3Object(this.currentA3);
            ArrayList<A3Listener> ls = null;
            ArrayList<A3Listener> arrayList = this.listeners;
            synchronized (arrayList) {
                ls = new ArrayList<A3Listener>(this.listeners);
            }
            for (A3Listener l : ls) {
                l.mousePressed(a3Event);
            }
        }
        WakeupOnAWTEvent[] ws = new WakeupOnAWTEvent[]{new WakeupOnAWTEvent(506), new WakeupOnAWTEvent(502)};
        WakeupOr w = new WakeupOr((WakeupCriterion[])ws);
        this.wakeupOn((WakeupCondition)w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMouseDragged(MouseEvent me) {
        if (me.getSource() == this.eventMaker) {
            A3Event a3Event = new A3Event();
            a3Event.setMouseEvent(me);
            a3Event.setA3Object(this.currentA3);
            ArrayList<A3Listener> ls = null;
            ArrayList<A3Listener> arrayList = this.listeners;
            synchronized (arrayList) {
                ls = new ArrayList<A3Listener>(this.listeners);
            }
            for (A3Listener l : ls) {
                l.mouseDragged(a3Event);
            }
        }
        WakeupOnAWTEvent[] ws = new WakeupOnAWTEvent[]{new WakeupOnAWTEvent(506), new WakeupOnAWTEvent(502)};
        WakeupOr w = new WakeupOr((WakeupCriterion[])ws);
        this.wakeupOn((WakeupCondition)w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMouseReleased(MouseEvent me) {
        if (me.getSource() == this.eventMaker) {
            A3Event a3Event = new A3Event();
            a3Event.setMouseEvent(me);
            a3Event.setA3Object(this.currentA3);
            A3Object a3 = this.pickA3(me.getX(), me.getY());
            ArrayList<A3Listener> ls = null;
            ArrayList<A3Listener> arrayList = this.listeners;
            synchronized (arrayList) {
                ls = new ArrayList<A3Listener>(this.listeners);
            }
            for (A3Listener l : ls) {
                l.mouseReleased(a3Event);
            }
            if (a3 == this.currentA3) {
                this.processMouseClicked(me);
                return;
            }
        }
        WakeupOnAWTEvent w = new WakeupOnAWTEvent(501);
        this.wakeupOn((WakeupCondition)w);
    }

    void processMouseClicked(MouseEvent me) {
        if (System.currentTimeMillis() - this.clickedTime < (long)this.doubleClickMaxTime) {
            this.clickedTime = 0L;
            this.processMouseDoubleClicked(me);
            return;
        }
        this.meTmp = me;
        this.clickedTime = System.currentTimeMillis();
        WakeupCriterion[] ws = new WakeupCriterion[]{new WakeupOnAWTEvent(501), new WakeupOnElapsedTime((long)this.doubleClickMaxTime)};
        WakeupOr w = new WakeupOr(ws);
        this.wakeupOn((WakeupCondition)w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeupOnElapsedTime(WakeupOnElapsedTime w) {
        A3Event a3Event = new A3Event();
        a3Event.setA3Object(this.currentA3);
        a3Event.setMouseEvent(this.meTmp);
        ArrayList<A3Listener> ls = null;
        ArrayList<A3Listener> arrayList = this.listeners;
        synchronized (arrayList) {
            ls = new ArrayList<A3Listener>(this.listeners);
        }
        for (A3Listener l : ls) {
            l.mouseClicked(a3Event);
        }
        WakeupOnAWTEvent ww = new WakeupOnAWTEvent(501);
        this.wakeupOn((WakeupCondition)ww);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMouseDoubleClicked(MouseEvent me) {
        A3Event a3Event = new A3Event();
        a3Event.setA3Object(this.currentA3);
        a3Event.setMouseEvent(me);
        ArrayList<A3Listener> ls = null;
        ArrayList<A3Listener> arrayList = this.listeners;
        synchronized (arrayList) {
            ls = new ArrayList<A3Listener>(this.listeners);
        }
        for (A3Listener l : ls) {
            l.mouseDoubleClicked(a3Event);
        }
        WakeupOnAWTEvent ww = new WakeupOnAWTEvent(501);
        this.wakeupOn((WakeupCondition)ww);
    }

    Point3d canvasToVirtualCS(int x, int y, double dis) {
        Point3d point = this.canvasToPhysicalCS(x, y, dis);
        this.physicalCSToVirtualCS(point);
        return point;
    }

    Point3d canvasToVirtualCS(int x, int y) {
        A3Object avatar = this.canvas.getAvatar();
        if (avatar == null) {
            return null;
        }
        Vector3d v1 = avatar.getLoc();
        Vector3d v2 = this.canvas.getCameraLoc();
        Vector3d v = new Vector3d();
        v.sub((Tuple3d)v1, (Tuple3d)v2);
        Point3d p = this.virtualCSToPhysicalCS(new Point3d((Tuple3d)v));
        return this.canvasToVirtualCS(x, y, p.z);
    }

    Point virtualCSToCanvas(Point3d p) {
        Point3d point = this.virtualCSToPhysicalCS(p);
        return this.physicalCSToCanvas(point);
    }

    Point3d canvasToPhysicalCS_BAK(int x, int y, double dis) {
        Point3d ret = new Point3d();
        this.canvas.getCanvas3D().getPixelLocationInImagePlate(x, y, ret);
        return ret;
    }

    Point3d canvasToPhysicalCS(int x, int y, double dis) {
        int dw = this.canvas.getCanvas3D().getWidth();
        int dh = this.canvas.getCanvas3D().getHeight();
        double ww = this.canvas.getCanvas3D().getPhysicalWidth();
        double hh = this.canvas.getCanvas3D().getPhysicalHeight();
        double tt = this.canvas.getCanvas3D().getView().getFieldOfView();
        double dx = (double)x * ww / (double)dw - ww / 2.0;
        double dy = -((double)y) * hh / (double)dh + hh / 2.0;
        double dz = -ww / 2.0 / Math.tan(tt / 2.0);
        if (this.canvas.getCanvas3D().getView().getProjectionPolicy() == 0) {
            double s = this.canvas.getCanvas3D().getView().getScreenScale();
            double sw = this.canvas.getCanvas3D().getScreen3D().getPhysicalScreenWidth();
            return new Point3d(dx / s * (sw / ww), dy / s * (sw / ww), -dis);
        }
        double s = dis / -dz;
        return new Point3d(s * dx, s * dy, s * dz);
    }

    Point3d canvasToPhysicalCS(int x, int y) {
        A3Object avatar = this.canvas.getAvatar();
        if (avatar == null) {
            return null;
        }
        Vector3d v1 = avatar.getLoc();
        Vector3d v2 = this.canvas.getCameraLoc();
        Vector3d v = new Vector3d();
        v.sub((Tuple3d)v1, (Tuple3d)v2);
        Point3d p = this.virtualCSToPhysicalCS(new Point3d((Tuple3d)v));
        return this.canvasToPhysicalCS(x, y, p.z);
    }

    Point physicalCSToCanvas(Point3d p) {
        int dw = this.canvas.getCanvas3D().getWidth();
        int dh = this.canvas.getCanvas3D().getHeight();
        double ww = this.canvas.getCanvas3D().getPhysicalWidth();
        double hh = this.canvas.getCanvas3D().getPhysicalHeight();
        double tt = this.canvas.getCanvas3D().getView().getFieldOfView();
        tt = ww / 2.0 / Math.tan(tt / 2.0);
        double zz = -p.z;
        Point ret = new Point();
        if (this.canvas.getCanvas3D().getView().getProjectionPolicy() == 0) {
            double s = this.canvas.getCanvas3D().getView().getScreenScale();
            double sw = this.canvas.getCanvas3D().getScreen3D().getPhysicalScreenWidth();
            ret.x = (int)(p.x * ((double)dw / ww) * s * ww / sw + (double)(dw / 2));
            ret.y = (int)(-p.y * ((double)dh / hh) * s * ww / sw + (double)(dh / 2));
        } else {
            ret.x = (int)(p.x * ((double)dw / ww) / (zz / tt)) + dw / 2;
            ret.y = (int)(-p.y * ((double)dh / hh) / (zz / tt)) + dh / 2;
        }
        return ret;
    }

    Point3d physicalCSToVirtualCS(Point3d p) {
        this.canvas.getTransformGroupForViewPlatform().getTransform(this.vpt);
        this.vpt.transform(p);
        return p;
    }

    Point3d virtualCSToPhysicalCS(Point3d p) {
        this.canvas.getTransformGroupForViewPlatform().getTransform(this.vpt);
        this.vpt.invert();
        this.vpt.transform(p);
        return p;
    }

    A3Object pickA3(int x, int y) {
        PickRay pr = null;
        if (this.canvas.getCanvas3D().getView().getProjectionPolicy() == 0) {
            Vector3d v0 = new Vector3d((Tuple3d)this.canvasToVirtualCS(x, y, 0.0));
            Vector3d v1 = new Vector3d((Tuple3d)this.canvasToVirtualCS(x, y, 1.0));
            v1.sub((Tuple3d)v0);
            pr = new PickRay(new Point3d((Tuple3d)v0), v1);
        } else {
            Vector3d v = new Vector3d((Tuple3d)this.canvasToVirtualCS(x, y, 1.0));
            Point3d p = new Point3d((Tuple3d)this.canvas.getCameraLoc());
            v.sub((Tuple3d)p);
            pr = new PickRay(p, v);
        }
        SceneGraphPath[] sgp = this.locale.pickAllSorted((PickShape)pr);
        if (sgp == null) {
            return null;
        }
        for (int i = 0; i < sgp.length; ++i) {
            for (int j = 0; j < sgp[i].nodeCount(); ++j) {
                Node n = sgp[i].getNode(j);
                if (!(n instanceof A3BranchGroup)) continue;
                A3BranchGroup ebn = (A3BranchGroup)n;
                if (!ebn.getA3().pickable) continue;
                return ebn.getA3();
            }
        }
        return null;
    }

    A3Object pickA3(Vector3d origin, Vector3d dir) {
        PickRay pr = new PickRay(new Point3d((Tuple3d)origin), dir);
        SceneGraphPath[] sgp = this.locale.pickAllSorted((PickShape)pr);
        if (sgp == null) {
            return null;
        }
        for (int i = 0; i < sgp.length; ++i) {
            for (int j = 0; j < sgp[i].nodeCount(); ++j) {
                Node n = sgp[i].getNode(j);
                if (!(n instanceof A3BranchGroup)) continue;
                A3BranchGroup ebn = (A3BranchGroup)n;
                if (!ebn.getA3().pickable) continue;
                return ebn.getA3();
            }
        }
        return null;
    }
}

