/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import org.sablecc.sablecc.Cast;
import org.sablecc.sablecc.MacroExpander;
import org.sablecc.sablecc.ResolveIds;
import org.sablecc.sablecc.TypedLinkedList;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.AElem;
import org.sablecc.sablecc.node.AIgnoredAlt;
import org.sablecc.sablecc.node.AParsedAlt;
import org.sablecc.sablecc.node.APlusUnOp;
import org.sablecc.sablecc.node.AProd;
import org.sablecc.sablecc.node.AQMarkUnOp;
import org.sablecc.sablecc.node.AStarUnOp;
import org.sablecc.sablecc.node.PAlt;

public class GenAlts
extends DepthFirstAdapter {
    private MacroExpander macros;
    private ResolveIds ids;
    private File pkgDir;
    private String pkgName;
    private List elemList;
    private String currentProd;
    ElemInfo info;

    public void inAProd(AProd aProd) {
        this.currentProd = (String)this.ids.names.get(aProd);
    }

    public void inAParsedAlt(AParsedAlt aParsedAlt) {
        this.inPAlt(aParsedAlt);
    }

    public void inAIgnoredAlt(AIgnoredAlt aIgnoredAlt) {
        this.inPAlt(aIgnoredAlt);
    }

    public void inPAlt(PAlt pAlt) {
        this.elemList = new TypedLinkedList(ElemInfoCast.instance);
    }

    public void inAElem(AElem aElem) {
        this.info = new ElemInfo();
        this.info.name = (String)this.ids.names.get(aElem);
        this.info.type = (String)this.ids.elemTypes.get(aElem);
        this.info.operator = 0;
        if (aElem.getUnOp() != null) {
            aElem.getUnOp().apply(new DepthFirstAdapter(this){
                final /* synthetic */ GenAlts this$0;

                public final void caseAStarUnOp(AStarUnOp aStarUnOp) {
                    this.this$0.info.operator = 1;
                }

                public final void caseAQMarkUnOp(AQMarkUnOp aQMarkUnOp) {
                    this.this$0.info.operator = 2;
                }

                public final void caseAPlusUnOp(APlusUnOp aPlusUnOp) {
                    this.this$0.info.operator = 3;
                }
                {
                    this.this$0 = genAlts;
                }
            });
        }
        this.elemList.add(this.info);
        this.info = null;
    }

    public void outAParsedAlt(AParsedAlt aParsedAlt) {
        this.outPAlt(aParsedAlt);
    }

    public void outAIgnoredAlt(AIgnoredAlt aIgnoredAlt) {
        this.outPAlt(aIgnoredAlt);
    }

    public void outPAlt(PAlt pAlt) {
        BufferedWriter bufferedWriter;
        String string = (String)this.ids.names.get(pAlt);
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, string + ".java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, string + ".java").getAbsolutePath());
        }
        try {
            ElemInfo elemInfo;
            boolean bl = false;
            this.macros.apply(bufferedWriter, "AlternativeHeader", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "analysis" : this.ids.pkgName + ".analysis", string, this.currentProd});
            Iterator iterator = this.elemList.iterator();
            while (iterator.hasNext()) {
                elemInfo = (ElemInfo)iterator.next();
                switch (elemInfo.operator) {
                    case 0: 
                    case 2: {
                        this.macros.apply(bufferedWriter, "NodeElement", new String[]{elemInfo.type, GenAlts.nodeName(elemInfo.name)});
                        break;
                    }
                    case 1: 
                    case 3: {
                        bl = true;
                        this.macros.apply(bufferedWriter, "ListElement", new String[]{elemInfo.name, GenAlts.nodeName(elemInfo.name)});
                    }
                }
            }
            this.macros.apply(bufferedWriter, "ConstructorHeader", new String[]{string});
            this.macros.apply(bufferedWriter, "ConstructorBodyHeader", null);
            this.macros.apply(bufferedWriter, "ConstructorBodyTail", null);
            if (this.elemList.size() > 0) {
                this.macros.apply(bufferedWriter, "ConstructorHeader", new String[]{string});
                iterator = this.elemList.iterator();
                while (iterator.hasNext()) {
                    elemInfo = (ElemInfo)iterator.next();
                    switch (elemInfo.operator) {
                        case 0: 
                        case 2: {
                            this.macros.apply(bufferedWriter, "ConstructorHeaderDeclNode", new String[]{elemInfo.type, GenAlts.nodeName(elemInfo.name), iterator.hasNext() ? "," : ""});
                            break;
                        }
                        case 1: 
                        case 3: {
                            this.macros.apply(bufferedWriter, "ConstructorHeaderDeclList", new String[]{"List", GenAlts.nodeName(elemInfo.name), iterator.hasNext() ? "," : ""});
                        }
                    }
                }
                this.macros.apply(bufferedWriter, "ConstructorBodyHeader", null);
                iterator = this.elemList.iterator();
                while (iterator.hasNext()) {
                    elemInfo = (ElemInfo)iterator.next();
                    switch (elemInfo.operator) {
                        case 0: 
                        case 2: {
                            this.macros.apply(bufferedWriter, "ConstructorBodyNode", new String[]{elemInfo.name, GenAlts.nodeName(elemInfo.name)});
                            break;
                        }
                        case 1: 
                        case 3: {
                            this.macros.apply(bufferedWriter, "ConstructorBodyList", new String[]{GenAlts.nodeName(elemInfo.name)});
                        }
                    }
                }
                this.macros.apply(bufferedWriter, "ConstructorBodyTail", null);
            }
            if (bl) {
                this.macros.apply(bufferedWriter, "ConstructorHeader", new String[]{string});
                iterator = this.elemList.iterator();
                while (iterator.hasNext()) {
                    elemInfo = (ElemInfo)iterator.next();
                    switch (elemInfo.operator) {
                        case 0: 
                        case 2: {
                            this.macros.apply(bufferedWriter, "ConstructorHeaderDeclNode", new String[]{elemInfo.type, GenAlts.nodeName(elemInfo.name), iterator.hasNext() ? "," : ""});
                            break;
                        }
                        case 1: 
                        case 3: {
                            this.macros.apply(bufferedWriter, "ConstructorHeaderDeclList", new String[]{"X" + elemInfo.type, GenAlts.nodeName(elemInfo.name), iterator.hasNext() ? "," : ""});
                        }
                    }
                }
                this.macros.apply(bufferedWriter, "ConstructorBodyHeader", null);
                iterator = this.elemList.iterator();
                while (iterator.hasNext()) {
                    elemInfo = (ElemInfo)iterator.next();
                    switch (elemInfo.operator) {
                        case 0: 
                        case 2: {
                            this.macros.apply(bufferedWriter, "ConstructorBodyNode", new String[]{elemInfo.name, GenAlts.nodeName(elemInfo.name)});
                            break;
                        }
                        case 1: 
                        case 3: {
                            this.macros.apply(bufferedWriter, "ConstructorBodyPlus", new String[]{GenAlts.nodeName(elemInfo.name), elemInfo.type});
                        }
                    }
                }
                this.macros.apply(bufferedWriter, "ConstructorBodyTail", null);
            }
            this.macros.apply(bufferedWriter, "CloneHeader", new String[]{string});
            iterator = this.elemList.iterator();
            while (iterator.hasNext()) {
                elemInfo = (ElemInfo)iterator.next();
                switch (elemInfo.operator) {
                    case 0: 
                    case 2: {
                        this.macros.apply(bufferedWriter, "CloneBodyNode", new String[]{elemInfo.type, GenAlts.nodeName(elemInfo.name), iterator.hasNext() ? "," : ""});
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.macros.apply(bufferedWriter, "CloneBodyList", new String[]{GenAlts.nodeName(elemInfo.name), iterator.hasNext() ? "," : ""});
                    }
                }
            }
            this.macros.apply(bufferedWriter, "CloneTail", null);
            this.macros.apply(bufferedWriter, "Apply", new String[]{string});
            iterator = this.elemList.iterator();
            while (iterator.hasNext()) {
                elemInfo = (ElemInfo)iterator.next();
                switch (elemInfo.operator) {
                    case 0: 
                    case 2: {
                        this.macros.apply(bufferedWriter, "GetSetNode", new String[]{elemInfo.type, elemInfo.name, GenAlts.nodeName(elemInfo.name)});
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.macros.apply(bufferedWriter, "GetSetList", new String[]{elemInfo.name, GenAlts.nodeName(elemInfo.name)});
                    }
                }
            }
            this.macros.apply(bufferedWriter, "ToStringHeader", null);
            iterator = this.elemList.iterator();
            while (iterator.hasNext()) {
                elemInfo = (ElemInfo)iterator.next();
                switch (elemInfo.operator) {
                    case 0: 
                    case 2: {
                        this.macros.apply(bufferedWriter, "ToStringBodyNode", new String[]{GenAlts.nodeName(elemInfo.name)});
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.macros.apply(bufferedWriter, "ToStringBodyList", new String[]{GenAlts.nodeName(elemInfo.name)});
                    }
                }
            }
            this.macros.apply(bufferedWriter, "ToStringTail", null);
            this.macros.apply(bufferedWriter, "RemoveChildHeader", null);
            iterator = this.elemList.iterator();
            while (iterator.hasNext()) {
                elemInfo = (ElemInfo)iterator.next();
                switch (elemInfo.operator) {
                    case 0: 
                    case 2: {
                        this.macros.apply(bufferedWriter, "RemoveChildNode", new String[]{GenAlts.nodeName(elemInfo.name)});
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.macros.apply(bufferedWriter, "RemoveChildList", new String[]{GenAlts.nodeName(elemInfo.name)});
                    }
                }
            }
            this.macros.apply(bufferedWriter, "RemoveChildTail", null);
            this.macros.apply(bufferedWriter, "ReplaceChildHeader", null);
            iterator = this.elemList.iterator();
            while (iterator.hasNext()) {
                elemInfo = (ElemInfo)iterator.next();
                switch (elemInfo.operator) {
                    case 0: 
                    case 2: {
                        this.macros.apply(bufferedWriter, "ReplaceChildNode", new String[]{GenAlts.nodeName(elemInfo.name), elemInfo.name, elemInfo.type});
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.macros.apply(bufferedWriter, "ReplaceChildList", new String[]{GenAlts.nodeName(elemInfo.name)});
                    }
                }
            }
            this.macros.apply(bufferedWriter, "ReplaceChildTail", null);
            iterator = this.elemList.iterator();
            while (iterator.hasNext()) {
                elemInfo = (ElemInfo)iterator.next();
                switch (elemInfo.operator) {
                    case 1: 
                    case 3: {
                        this.macros.apply(bufferedWriter, "Cast", new String[]{elemInfo.name, elemInfo.type, string});
                    }
                }
            }
            this.macros.apply(bufferedWriter, "AlternativeTail", null);
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, string + ".java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.elemList = null;
    }

    public static String nodeName(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (stringBuffer.length() > 0) {
            stringBuffer.setCharAt(0, Character.toLowerCase(stringBuffer.charAt(0)));
        }
        return stringBuffer.toString();
    }

    public GenAlts(ResolveIds resolveIds) {
        this.ids = resolveIds;
        try {
            this.macros = new MacroExpander(new InputStreamReader(this.getClass().getResourceAsStream("alternatives.txt")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("unable to open alternatives.txt.");
        }
        this.pkgDir = new File(resolveIds.pkgDir, "node");
        String string = this.pkgName = resolveIds.pkgName.equals("") ? "node" : resolveIds.pkgName + ".node";
        if (!this.pkgDir.exists() && !this.pkgDir.mkdir()) {
            throw new RuntimeException("Unable to create " + this.pkgDir.getAbsolutePath());
        }
    }

    private static class ElemInfo {
        static final int NONE = 0;
        static final int STAR = 1;
        static final int QMARK = 2;
        static final int PLUS = 3;
        String name;
        String type;
        int operator;

        private ElemInfo() {
        }
    }

    private static class ElemInfoCast
    implements Cast {
        public static final ElemInfoCast instance = new ElemInfoCast();

        public Object cast(Object object) {
            return (ElemInfo)object;
        }

        private ElemInfoCast() {
        }
    }
}

